/*
  Gas Cap
 
 Turns on an LED bar graph on the hat based on the value of the methane (fart) 
 sensor.  This uses XBee Series 2 from Digi to make wireless connectivity
 easy.
 
 created 1 May 2012
 by instructable member Qtechknow

 */

int analogValue = 0;
int lowVal = 40;          // declare the low value of the methane sensor
int highVal = 200;      // declare the high value of the methane sensor

// these constants won't change:
const int ledCount = 10;    // the number of LEDs in the Bar Graph

int ledPins[] = { 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14 };   // an array of our LED pins


void setup() {
  // loop over the pin array and set them all to output:
  for (int thisLed = 0; thisLed < ledCount; thisLed++) {
    pinMode(ledPins[thisLed], OUTPUT); 
  }
  pinMode(13, OUTPUT);
  Serial.begin(9600);    // start serial communication
}

void loop() {
  if(Serial.available() >= 21) {   // look for the start byte
    
    if(Serial.read() == 0x7E) {

      digitalWrite(13, HIGH);
      delay(50);
      digitalWrite(13, LOW);
      for(int i = 0; i<18; i++) {
        byte discard = Serial.read();  // discard what we don't need
      }
      int analogHigh = Serial.read();  // get the analog values
      int analogLow = Serial.read();
      analogValue = analogLow + (analogHigh * 256);   // convert the values
      Serial.println(analogValue);
    }
  }
  
  // map the result to a range from 0 to the number of LEDs:
  int ledLevel = map(analogValue, lowVal, highVal, 0, ledCount);

  // loop over the Bar Graph:
  for (int thisLed = 0; thisLed < ledCount; thisLed++) {
    // if the array element's index is less than ledLevel,
    // turn the pin for this element on:
    if (thisLed < ledLevel) {
      digitalWrite(ledPins[thisLed], HIGH);
    } 
    // turn off all pins higher than the ledLevel:
    else {
      digitalWrite(ledPins[thisLed], LOW); 
    }
  } 
}



