/**************************************************************************************************************
DIY Game & Watch
Written by A M Hannay
Target device PIC 18F4550 with bootloader
Nokia 5110 84x48 Graphic LCD display PCD8544
***************************************************************************************************************/

#include <p18cxxx.h>
#include "spi.h"

void YourHighPriorityISRCode();
void YourLowPriorityISRCode();


#define BOOTVERSION				// comment this line out for a non-bootloaded version


// set addresses of reset, high int and low int.
#if defined BOOTVERSION
	#define REMAPPED_RESET_VECTOR_ADDRESS			0x1000
	#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x1008
	#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x1018
#else
	#define REMAPPED_RESET_VECTOR_ADDRESS			0x00
	#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x08
	#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x18
#endif

// If bootloaded a reset vector needs to be added at 0x1000 to point to 'c' start-up code.
// Its done automatically for non-bootloaded code.
#if defined(BOOTVERSION)
	extern void _startup (void);        // See c018i.c in your C18 compiler dir
	#pragma code REMAPPED_RESET_VECTOR = REMAPPED_RESET_VECTOR_ADDRESS
	void _reset (void)
	{
	    _asm goto _startup _endasm
	}
#endif

// Insert actual interrupt vectors
#pragma code REMAPPED_HIGH_INTERRUPT_VECTOR = REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS
	void Remapped_High_ISR (void)
	{
	     _asm goto YourHighPriorityISRCode  _endasm
	}
#pragma code REMAPPED_LOW_INTERRUPT_VECTOR = REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS
	void Remapped_Low_ISR (void)
	{
	     _asm goto YourLowPriorityISRCode _endasm
	}


// This bit of code is for safety, but not always needed. It puts int vectors at 0x8 and 0x18 in case you program a bootversion 
// of this code on a system not using the bootloader. The bootloader ignores all code below 0x1000 so will not program this.
#if defined(BOOTVERSION)
#pragma code HIGH_INTERRUPT_VECTOR = 0x08
	void High_ISR (void)
	{
	     _asm goto REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS _endasm
	}
#pragma code LOW_INTERRUPT_VECTOR = 0x18
	void Low_ISR (void)
	{
	     _asm goto REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS _endasm
	}

#endif	

#pragma code

/***********************************************************************************************
*
* Defines & consts
*
************************************************************************************************/
#define FLIPDISPLAY

#define LCD_RES	LATDbits.LATD7
#define LCD_DC	LATDbits.LATD6
#define LCD_SCE	LATDbits.LATD5
#define LCD_SCL	LATBbits.LATB1
#define LCD_SDO	LATCbits.LATC7

#define SPEAKER	LATAbits.LATA0
#define BLIGHT	LATAbits.LATA1
#define	LCD_POW	LATDbits.LATD1

#define SW_MODE		PORTBbits.RB2
#define SW_PRO		PORTBbits.RB3
#define SW_LEFT		PORTBbits.RB4
#define SW_RIGHT	PORTBbits.RB5

#define LCD_C	0
#define LCD_D	1

#define LCD_X	84
#define LCD_Y	48

static const unsigned char rom ASCII[][5] =
{
 {0x00, 0x00, 0x00, 0x00, 0x00} // 20  
,{0x00, 0x00, 0x5f, 0x00, 0x00} // 21 !
,{0x00, 0x07, 0x00, 0x07, 0x00} // 22 "
,{0x14, 0x7f, 0x14, 0x7f, 0x14} // 23 #
,{0x24, 0x2a, 0x7f, 0x2a, 0x12} // 24 $
,{0x23, 0x13, 0x08, 0x64, 0x62} // 25 %
,{0x36, 0x49, 0x55, 0x22, 0x50} // 26 &
,{0x00, 0x05, 0x03, 0x00, 0x00} // 27 '
,{0x00, 0x1c, 0x22, 0x41, 0x00} // 28 (
,{0x00, 0x41, 0x22, 0x1c, 0x00} // 29 )
,{0x14, 0x08, 0x3e, 0x08, 0x14} // 2a *
,{0x08, 0x08, 0x3e, 0x08, 0x08} // 2b +
,{0x00, 0x50, 0x30, 0x00, 0x00} // 2c ,
,{0x08, 0x08, 0x08, 0x08, 0x08} // 2d -
,{0x00, 0x60, 0x60, 0x00, 0x00} // 2e .
,{0x20, 0x10, 0x08, 0x04, 0x02} // 2f /
/*
,{0x3e, 0x51, 0x49, 0x45, 0x3e} // 30 0
,{0x00, 0x42, 0x7f, 0x40, 0x00} // 31 1
,{0x42, 0x61, 0x51, 0x49, 0x46} // 32 2
,{0x21, 0x41, 0x45, 0x4b, 0x31} // 33 3
,{0x18, 0x14, 0x12, 0x7f, 0x10} // 34 4
,{0x27, 0x45, 0x45, 0x45, 0x39} // 35 5
,{0x3c, 0x4a, 0x49, 0x49, 0x30} // 36 6
,{0x01, 0x71, 0x09, 0x05, 0x03} // 37 7
,{0x36, 0x49, 0x49, 0x49, 0x36} // 38 8
,{0x06, 0x49, 0x49, 0x29, 0x1e} // 39 9
*/
,{0xfe, 0x82, 0x82, 0x82, 0xfe} // 30 0 7 segment
,{0x00, 0x00, 0x00, 0x00, 0xfe} // 31 1 7 segment
,{0xf2, 0x92, 0x92, 0x92, 0x9e} // 32 2 7 segment
,{0x92, 0x92, 0x92, 0x92, 0xfe} // 33 3 7 segment
,{0x1e, 0x10, 0x10, 0x10, 0xfe} // 34 4 7 segment
,{0x9e, 0x92, 0x92, 0x92, 0xf2} // 35 5 7 segment
,{0xfe, 0x92, 0x92, 0x92, 0xf2} // 36 6 7 segment
,{0x02, 0x02, 0x02, 0x02, 0xfe} // 37 7 7 segment
,{0xfe, 0x92, 0x92, 0x92, 0xfe} // 38 8 7 segment
,{0x9e, 0x92, 0x92, 0x92, 0xfe} // 39 9 7 segment

,{0x00, 0x36, 0x36, 0x00, 0x00} // 3a :
,{0x00, 0x56, 0x36, 0x00, 0x00} // 3b ;
,{0x08, 0x14, 0x22, 0x41, 0x00} // 3c <
,{0x14, 0x14, 0x14, 0x14, 0x14} // 3d =
,{0x00, 0x41, 0x22, 0x14, 0x08} // 3e >
,{0x02, 0x01, 0x51, 0x09, 0x06} // 3f ?
,{0x32, 0x49, 0x79, 0x41, 0x3e} // 40 @
,{0x7e, 0x11, 0x11, 0x11, 0x7e} // 41 A
,{0x7f, 0x49, 0x49, 0x49, 0x36} // 42 B
,{0x3e, 0x41, 0x41, 0x41, 0x22} // 43 C
,{0x7f, 0x41, 0x41, 0x22, 0x1c} // 44 D
,{0x7f, 0x49, 0x49, 0x49, 0x41} // 45 E
,{0x7f, 0x09, 0x09, 0x09, 0x01} // 46 F
,{0x3e, 0x41, 0x49, 0x49, 0x7a} // 47 G
,{0x7f, 0x08, 0x08, 0x08, 0x7f} // 48 H
,{0x00, 0x41, 0x7f, 0x41, 0x00} // 49 I
,{0x20, 0x40, 0x41, 0x3f, 0x01} // 4a J
,{0x7f, 0x08, 0x14, 0x22, 0x41} // 4b K
,{0x7f, 0x40, 0x40, 0x40, 0x40} // 4c L
,{0x7f, 0x02, 0x0c, 0x02, 0x7f} // 4d M
,{0x7f, 0x04, 0x08, 0x10, 0x7f} // 4e N
,{0x3e, 0x41, 0x41, 0x41, 0x3e} // 4f O
,{0x7f, 0x09, 0x09, 0x09, 0x06} // 50 P
,{0x3e, 0x41, 0x51, 0x21, 0x5e} // 51 Q
,{0x7f, 0x09, 0x19, 0x29, 0x46} // 52 R
,{0x46, 0x49, 0x49, 0x49, 0x31} // 53 S
,{0x01, 0x01, 0x7f, 0x01, 0x01} // 54 T
,{0x3f, 0x40, 0x40, 0x40, 0x3f} // 55 U
,{0x1f, 0x20, 0x40, 0x20, 0x1f} // 56 V
,{0x3f, 0x40, 0x38, 0x40, 0x3f} // 57 W
,{0x63, 0x14, 0x08, 0x14, 0x63} // 58 X
,{0x07, 0x08, 0x70, 0x08, 0x07} // 59 Y
,{0x61, 0x51, 0x49, 0x45, 0x43} // 5a Z
,{0x00, 0x7f, 0x41, 0x41, 0x00} // 5b [
,{0x02, 0x04, 0x08, 0x10, 0x20} // 5c 
,{0x00, 0x41, 0x41, 0x7f, 0x00} // 5d ]
,{0x04, 0x02, 0x01, 0x02, 0x04} // 5e ^
,{0x40, 0x40, 0x40, 0x40, 0x40} // 5f _
,{0x00, 0x01, 0x02, 0x04, 0x00} // 60 `
,{0x20, 0x54, 0x54, 0x54, 0x78} // 61 a
,{0x7f, 0x48, 0x44, 0x44, 0x38} // 62 b
,{0x38, 0x44, 0x44, 0x44, 0x20} // 63 c
,{0x38, 0x44, 0x44, 0x48, 0x7f} // 64 d
,{0x38, 0x54, 0x54, 0x54, 0x18} // 65 e
,{0x08, 0x7e, 0x09, 0x01, 0x02} // 66 f
,{0x0c, 0x52, 0x52, 0x52, 0x3e} // 67 g
,{0x7f, 0x08, 0x04, 0x04, 0x78} // 68 h
,{0x00, 0x44, 0x7d, 0x40, 0x00} // 69 i
,{0x20, 0x40, 0x44, 0x3d, 0x00} // 6a j 
,{0x7f, 0x10, 0x28, 0x44, 0x00} // 6b k
,{0x00, 0x41, 0x7f, 0x40, 0x00} // 6c l
,{0x7c, 0x04, 0x18, 0x04, 0x78} // 6d m
,{0x7c, 0x08, 0x04, 0x04, 0x78} // 6e n
,{0x38, 0x44, 0x44, 0x44, 0x38} // 6f o
,{0x7c, 0x14, 0x14, 0x14, 0x08} // 70 p
,{0x08, 0x14, 0x14, 0x18, 0x7c} // 71 q
,{0x7c, 0x08, 0x04, 0x04, 0x08} // 72 r
,{0x48, 0x54, 0x54, 0x54, 0x20} // 73 s
,{0x04, 0x3f, 0x44, 0x40, 0x20} // 74 t
,{0x3c, 0x40, 0x40, 0x20, 0x7c} // 75 u
,{0x1c, 0x20, 0x40, 0x20, 0x1c} // 76 v
,{0x3c, 0x40, 0x30, 0x40, 0x3c} // 77 w
,{0x44, 0x28, 0x10, 0x28, 0x44} // 78 x
,{0x0c, 0x50, 0x50, 0x50, 0x3c} // 79 y
,{0x44, 0x64, 0x54, 0x4c, 0x44} // 7a z
,{0x00, 0x08, 0x36, 0x41, 0x00} // 7b {
,{0x00, 0x00, 0x7f, 0x00, 0x00} // 7c |
,{0x00, 0x41, 0x36, 0x08, 0x00} // 7d }
,{0x10, 0x08, 0x08, 0x10, 0x08} // 7e ?
,{0x78, 0x46, 0x41, 0x46, 0x78} // 7f ?
};

//exterminator_all 0,0
static const unsigned char rom exterminator_all [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x01, 0x01, 0x03, 0x06, 0x08, 0x08, 0x18, 0x10, 0x30, 0xA3, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF,
0x07, 0xA3, 0x30, 0x10, 0x18, 0x08, 0x08, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0xF8, 0xF8,
0xF8, 0xF8, 0xF8, 0x20, 0xA0, 0xA0, 0x80, 0x30, 0x30, 0x18, 0x0C, 0x02, 0x83, 0x85, 0x04, 0x06,
0x01, 0x01, 0x01, 0x06, 0x04, 0x85, 0x83, 0x02, 0x0C, 0x18, 0x30, 0x30, 0x80, 0xA0, 0xA0, 0x20,
0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x10, 0x12, 0x42, 0x3B,
0x3D, 0x3E, 0x7E, 0x3A, 0x5E, 0x6C, 0x6D, 0x6C, 0x06, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x42,
0x3B, 0x3D, 0x3E, 0x7E, 0x3A, 0x5E, 0x6C, 0x6D, 0x6C, 0x06, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12,
0x62, 0x63, 0x59, 0x3C, 0x7A, 0x56, 0x7A, 0x3C, 0x59, 0x63, 0x62, 0x12, 0x10, 0x10, 0x10, 0x10,
0x10, 0x06, 0x6C, 0x6D, 0x6C, 0x5E, 0x3A, 0x7E, 0x3E, 0x3D, 0x3B, 0x42, 0x12, 0x10, 0x10, 0x10,
0x10, 0x10, 0x06, 0x6C, 0x6D, 0x6C, 0x5E, 0x3A, 0x7E, 0x3E, 0x3D, 0x3B, 0x42, 0x12, 0x10, 0x10,
0x00, 0x90, 0x90, 0x4A, 0x4A, 0x49, 0x51, 0x92, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x50, 0x50, 0x48, 0x4A, 0x8A, 0x91, 0x11, 0x02, 0x02, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40,
0x40, 0x90, 0x90, 0x08, 0x08, 0x0A, 0x12, 0x11, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x11, 0x91, 0x8A, 0x4A,
0x48, 0x50, 0x50, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x92, 0x52, 0x49, 0x49, 0x4A, 0x92,
0x90, 0x00, 0x00, 0x00, 0x02, 0x62, 0xF2, 0xC2, 0xF2, 0xBA, 0xF2, 0xC2, 0xF2, 0x62, 0x02, 0x02,
0x62, 0xF2, 0xC2, 0xF2, 0xBA, 0xF2, 0xC2, 0xF2, 0x62, 0x02, 0x02, 0x62, 0xF2, 0xC2, 0xF2, 0xBA,
0xF2, 0xC2, 0xF2, 0x62, 0x06, 0xFC, 0x00, 0xFE, 0x92, 0x92, 0x92, 0xFE, 0x00, 0xFE, 0x92, 0x92,
0x92, 0xFE, 0x00, 0xFE, 0x92, 0x92, 0x92, 0xFE, 0x00, 0xFE, 0x92, 0x92, 0x92, 0xFE, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//empty screen 0,0
static const unsigned char rom empty [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10,
0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
0x02, 0x02, 0x02, 0x02, 0x06, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//hump 1 1,4
static const unsigned char rom hump_1 [] = {0x90, 0x90, 0x4A, 0x4A, 0x49, 0x51, 0x92, 0x82};
//hump 2 14,4
static const unsigned char rom hump_2 [] = {0x80, 0x80, 0x50, 0x50, 0x48, 0x4A, 0x8A, 0x91, 0x11, 0x02, 0x02};
//hump 3 27,4
static const unsigned char rom hump_3 [] = {0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x90, 0x90, 0x08, 0x08, 0x0A, 0x12, 0x11, 0x01, 0x02, 0x02};
//hump 4 58,4
static const unsigned char rom hump_4 [] = {0x02, 0x02, 0x11, 0x91, 0x8A, 0x4A, 0x48, 0x50, 0x50, 0x80, 0x80};
//hump 5 73,4
static const unsigned char rom hump_5 [] = {0x80, 0x92, 0x52, 0x49, 0x49, 0x4A, 0x92, 0x90};
//life 1,5 12,5 23,5
static const unsigned char rom life [] = {0x62, 0xF2, 0xC2, 0xF2, 0xBA, 0xF2, 0xC2, 0xF2, 0x62};
//man 1 left arm down 0,0
static const unsigned char rom man_1l [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC3, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF, 0x07,
0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0xF8, 0xF8, 0xF8,
0xF8, 0xF8, 0x00, 0xA0, 0xA0, 0xA0, 0x20, 0x20, 0x18, 0x1C, 0x06, 0x01, 0x04, 0x04, 0x06, 0x01,
0x01, 0x01, 0x02, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 1 right arm down 0,0
static const unsigned char rom man_1r [] = {
0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF, 0x07,
0xC3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x06, 0x01,
0x01, 0x01, 0x02, 0x04, 0x02, 0x01, 0x06, 0x1C, 0x18, 0x20, 0x20, 0x20, 0xA0, 0xA0, 0x00, 0xF8,
0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 1 both arms up 0,0
static const unsigned char rom man_1u [] = {
0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF, 0x07,
0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x06, 0x01,
0x01, 0x01, 0x02, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 2 left arm down 0,0
static const unsigned char rom man_2l [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC3, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF,
0x07, 0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0xF8, 0xF8,
0xF8, 0xF8, 0xF8, 0x00, 0xA0, 0xA0, 0xA0, 0x20, 0x20, 0x18, 0x1C, 0x06, 0x01, 0x04, 0x04, 0x06,
0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 2 right arm down 0,0
static const unsigned char rom man_2r [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF,
0x07, 0xC3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x06,
0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x01, 0x06, 0x1C, 0x18, 0x20, 0x20, 0xA0, 0xA0, 0xA0, 0x00,
0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 2 both arms up 0,0
static const unsigned char rom man_2u [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7, 0xF5, 0xEF,
0x07, 0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x06,
0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 3 left arm down 0,0
static const unsigned char rom man_3l [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC3, 0x07, 0xEF, 0xF5, 0xF7, 0xF5,
0xEF, 0x07, 0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0xF8,
0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0xA0, 0xA0, 0x20, 0x20, 0x20, 0x18, 0x1C, 0x06, 0x01, 0x02, 0x04,
0x02, 0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//man 3 right arm down 0,0
static const unsigned char rom man_3r [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7,
0xF5, 0xEF, 0x07, 0xC3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
0x04, 0x02, 0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x01, 0x06, 0x1C, 0x18, 0x20, 0x20, 0xA0, 0xA0,
0xA0, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00};

//man 3 both arms up 0,0
static const unsigned char rom man_3u [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x3F, 0x3F, 0x1E, 0x2C, 0x40, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x2C, 0x1E, 0x3F, 0x3F, 0x1E, 0x0C,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x0C, 0x10, 0x10, 0x30, 0x20, 0x23, 0x07, 0xEF, 0xF5, 0xF7,
0xF5, 0xEF, 0x07, 0x23, 0x20, 0x30, 0x10, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
0x04, 0x02, 0x01, 0x01, 0x01, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//mole left 1,3 18,3
static const unsigned char rom mole_1 [] = {0x10, 0x40, 0x38, 0x3C, 0x3E, 0x7E, 0x3A, 0x5E, 0x6C, 0x6C, 0x6C, 0x06, 0x10};

//mole left hit 1,3 18,3
static const unsigned char rom mole_1_hit [] = {0x12, 0x42, 0x3B, 0x3D, 0x3E, 0x7E, 0x3A, 0x5E, 0x6C, 0x6D, 0x6C, 0x06, 0x10};

//mole centre 35,3
static const unsigned char rom mole_2 [] = {0x10, 0x60, 0x60, 0x58, 0x3C, 0x7A, 0x56, 0x7A, 0x3C, 0x58, 0x60, 0x60, 0x10};

//mole centre hit 35,3
static const unsigned char rom mole_2_hit [] = {0x12, 0x62, 0x63, 0x59, 0x3C, 0x7A, 0x56, 0x7A, 0x3C, 0x59, 0x63, 0x62, 0x12};

//mole right 52,3 69,3
static const unsigned char rom mole_3 [] = {0x10, 0x06, 0x6C, 0x6C, 0x6C, 0x5E, 0x3A, 0x7E, 0x3E, 0x3C, 0x38, 0x40, 0x10};

//mole right 52,3 69,3
static const unsigned char rom mole_3_hit [] = {0x10, 0x06, 0x6C, 0x6D, 0x6C, 0x5E, 0x3A, 0x7E, 0x3E, 0x3D, 0x3B, 0x42, 0x12};

//mole clear 1,3 18,3 35,3 52,3 69,3
static const unsigned char rom mole_clear [] = {0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10};

//used to flip bits
static const unsigned char rom rtable[] = {
0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, 0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, 0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, 0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff};

//pseudo random numbers
unsigned char rand;

static const unsigned char rom randomtable1[] = {
2,5,4,1,2,5,4,5,2,1,5,2,4,5,2,1,2,4,2,1,2,4,2,1,4,1,2,5,2,5,4,1,
4,1,4,5,4,2,4,1,4,5,4,2,1,4,1,2,4,2,1,2,4,2,1,2,4,2,1,4,1,5,2,4,
5,1,5,1,4,2,1,2,4,1,4,2,5,1,2,4,5,1,4,2,1,2,1,5,1,4,1,4,1,5,2,4,
5,1,4,2,4,1,2,1,4,5,4,2,5,4,2,1,2,1,2,1,4,5,4,2,1,4,1,5,2,1,4,5,
4,2,5,1,5,2,5,2,4,5,2,1,2,4,5,4,1,5,2,1,4,5,2,1,4,2,1,2,1,2,5,4,
4,1,2,5,2,1,4,5,4,2,1,2,5,4,2,1,2,5,1,4,5,4,2,4,5,4,2,1,4,1,5,2,
4,2,4,1,2,4,5,4,1,4,5,4,5,4,2,1,2,4,1,5,2,5,2,5,1,4,5,2,1,2,4,5,
2,5,4,1,5,2,1,2,5,1,4,1,5,1,2,4,5,4,2,1,5,1,4,1,5,2,1,2,1,5,4,5};

static const unsigned char rom randomtable2[] = {
4,5,4,1,3,2,5,4,1,4,5,3,5,2,5,1,2,4,1,4,2,3,1,3,5,4,1,4,1,5,1,2,
4,5,1,2,4,1,2,5,2,3,2,5,4,5,1,4,1,5,4,1,4,2,5,4,1,5,4,1,2,5,4,1,
2,3,1,3,1,3,5,1,5,4,1,3,1,2,3,4,5,2,3,1,4,2,3,1,2,4,5,4,2,1,2,5,
4,5,3,1,4,1,3,1,4,2,1,3,2,1,2,3,2,5,4,2,4,5,1,5,1,5,3,2,1,3,2,4,
2,4,5,1,2,4,5,1,3,5,2,4,5,4,2,3,2,1,2,5,1,2,3,2,5,1,5,4,2,4,2,4,
5,2,3,2,1,3,5,3,1,3,1,2,4,2,3,2,4,1,3,5,4,5,2,4,1,4,5,3,2,5,3,5,
1,5,3,4,5,2,3,1,2,4,5,4,1,3,2,5,4,1,4,5,3,5,2,5,1,2,4,1,4,2,3,1,
3,5,4,1,4,1,5,1,2,4,5,1,2,4,1,2,5,2,3,2,5,4,5,1,4,1,5,4,1,4,2,5};

static const unsigned char rom randomtable3[] = {
1,2,0,1,2,0,2,0,1,2,0,2,1,2,1,0,1,2,0,1,2,0,2,1,2,1,2,0,1,0,2,0,
1,0,1,2,1,2,0,2,0,2,0,1,2,0,2,0,1,0,2,0,1,0,2,1,2,0,1,2,0,1,0,2,
0,2,0,2,1,2,0,1,2,0,2,1,2,0,2,0,2,0,2,0,1,2,0,1,2,1,0,1,0,2,0,2,
0,1,2,0,2,0,2,0,2,1,0,2,0,2,0,1,0,2,0,1,2,0,1,0,2,0,2,0,1,0,1,2,
0,1,2,0,2,1,2,0,1,2,1,0,1,0,2,0,1,0,2,0,1,0,2,1,0,1,0,1,2,1,0,2,
1,2,0,2,0,1,0,1,2,1,2,0,1,2,0,2,0,1,2,0,2,1,2,1,0,1,2,0,1,2,0,2,
1,2,1,2,0,1,0,2,0,1,0,1,2,1,2,0,2,0,2,0,1,2,0,2,0,1,0,2,0,1,0,2,
1,2,0,1,2,0,1,0,2,0,2,0,2,1,2,0,1,2,0,2,1,2,0,2,0,2,0,2,0,1,2,0};

unsigned char rbyte(unsigned char x)
{
    return rtable[x];
}

unsigned char random1(void)
{
    return randomtable1[rand++];
}

unsigned char random2(void)
{
    return randomtable2[rand++];
}

unsigned char random3(void)
{
    return randomtable3[rand++];
}

void LcdWrite(unsigned char dc, unsigned char data)
{
	LCD_DC = dc;
	LCD_SCE = 0;

	WriteSPI(data);
	LCD_SCE = 1;	
}

void gotoXY(unsigned char x, unsigned char y)
{
#ifdef FLIPDISPLAY
	LcdWrite(LCD_C, 0x80 | (83-x));  // Column.
	LcdWrite(LCD_C, 0x40 | (5-y));  // Row.
#else
	LcdWrite(LCD_C, 0x80 | x);  // Column.
	LcdWrite(LCD_C, 0x40 | y);  // Row.
#endif
}

void LcdCharacter(char character)
{
	unsigned char index;
	LcdWrite(LCD_D, 0x00);
	for (index = 0; index < 5; index++)
	{
#ifdef FLIPDISPLAY
		LcdWrite(LCD_D, rbyte(ASCII[character - 0x20][4-index]));
#else
		LcdWrite(LCD_D, ASCII[character - 0x20][index]);
#endif
	}
	//LcdWrite(LCD_D, 0x00);
}

void LcdString(rom char *characters)
{
	while (*characters)
	{
		LcdCharacter(*characters++);
	}
}

void LcdGraphic(rom char *graphic)
{
	unsigned int pointer;

	LcdWrite(LCD_C, 0x80);  // Column.
	LcdWrite(LCD_C, 0x40);  // Row.
	for (pointer = 0; pointer < 504; pointer++)
	{
#ifdef FLIPDISPLAY
		LcdWrite(LCD_D, rbyte(graphic[503-pointer]));
#else
		LcdWrite(LCD_D, graphic[pointer]);
#endif
	}
}

void NumberXY(unsigned int value, unsigned char x, unsigned char y)
{
	unsigned char d1;
	unsigned char d2;
	unsigned char d3;
	unsigned char d4;
	unsigned char z;
	z = 0;
	
	d1 = 0x30 | value/1000;
	d2 = 0x30 | (value%1000)/100;
	d3 = 0x30 | ((value%1000)%100)/10;
	d4 = 0x30 | ((value%1000)%100)%10;
	
#ifdef FLIPDISPLAY
	LcdWrite(LCD_C, 0x80 | (59-x));  // Column.
	LcdWrite(LCD_C, 0x40 | (5-y));  // Row.
	LcdCharacter(d4);
	if (value > 9) LcdCharacter(d3);
	if (value > 99) LcdCharacter(d2);
	if (value > 999) LcdCharacter(d1);
#else
	LcdWrite(LCD_C, 0x80 | x);  // Column.
	LcdWrite(LCD_C, 0x40 | y);  // Row.
	if (value > 999) LcdCharacter(d1);
	if (value > 99) LcdCharacter(d2);
	if (value > 9) LcdCharacter(d3);
	LcdCharacter(d4);
#endif
}

void BGraphicY(rom char *graphic, unsigned char y, unsigned int lines)
{
	unsigned char len;
	unsigned int pointer;
	len = (lines * 84) - 1;
	LcdWrite(LCD_C, 0x80);  // Column 0
#ifdef FLIPDISPLAY
	LcdWrite(LCD_C, 0x40 | (6-y-lines));  // Row.
	for (pointer = 0; pointer < len; pointer++)
	{
		LcdWrite(LCD_D, rbyte(graphic[len-pointer]));
	}
#else
	LcdWrite(LCD_C, 0x40 | y);  // Row.
	for (pointer = 0; pointer < len; pointer++)
	{
		LcdWrite(LCD_D, graphic[pointer]);
	}
#endif
}

void SGraphicXY(rom char *graphic, unsigned char x, unsigned char y, unsigned char len, unsigned char mask)
{
	unsigned int pointer;
#ifdef FLIPDISPLAY
	LcdWrite(LCD_C, 0x80 | (84-x-len));  // Column.
	LcdWrite(LCD_C, 0x40 | (5-y));  // Row.
	for (pointer = 0; pointer < len; pointer++)
	{
		LcdWrite(LCD_D, rbyte(mask & (graphic[len-pointer-1])));
	}	
#else
	LcdWrite(LCD_C, 0x80 | x);  // Column.
	LcdWrite(LCD_C, 0x40 | y);  // Row.
	for (pointer = 0; pointer < len; pointer++)
	{
		LcdWrite(LCD_D, mask & (graphic[pointer]));
	}	
#endif
}

void LcdClear(void)
{
	unsigned int n;
	LcdWrite(LCD_C, 0x80);  // Column.
	LcdWrite(LCD_C, 0x40);  // Row.
	for(n=0;n<504;n++)
	{
		LcdWrite(LCD_D, 0x00);
	}
}

void LcdInitialise(void)
{
	unsigned int n;
	LCD_RES = 0;
	LCD_RES = 1;

	LcdWrite(LCD_C,0x21);	//Tell LCD that extended commands follow
	LcdWrite(LCD_C,0xBF);	//Set LCD Vop (Contrast): Try 0xB1(good @ 3.3V) or 0xBF if your display is too dark
	LcdWrite(LCD_C,0x04);	//Set Temp coefficent
	LcdWrite(LCD_C,0x14);	//LCD bias mode 1:48: Try 0x13 or 0x14
	LcdWrite(LCD_C,0x20);	//We must send 0x20 before modifying the display control mode
	LcdWrite(LCD_C,0x0C);	//Set display control, normal mode. 0x0D for inverse
}

void ToggleBL(void)
{
	if (BLIGHT == 0)
	{
		BLIGHT = 1;
	}
	else
	{
		BLIGHT = 0;
	}		
}
	
void Shutdown(void)
{
	SSPCON1 = 0;
	LATA = 0;
	LATB = 0;
	LATC = 0;
	LATD = 0;
	LATE = 0;
	TRISA = 0x00;
	TRISB = 0x04;
	TRISC = 0x00;
	TRISD = 0x00;
	TRISE = 0x00;
	Sleep();
}	

unsigned char SWST_MODE;
unsigned char SWST_PRO;
unsigned char SWST_LEFT;
unsigned char SWST_RIGHT;
unsigned char LAST_MODE;
unsigned char LAST_PRO;
unsigned char LAST_LEFT;
unsigned char LAST_RIGHT;
unsigned int PROcount;
unsigned int MODEcount;
unsigned int AUTOcount;

void scanswlr(void)		//scan left & right switches
{
	SWST_LEFT = 0;
	SWST_RIGHT = 0;
	if(SW_LEFT == 0)
	{
		AUTOcount = 0;
		if(LAST_LEFT == 1)
		{
			LAST_LEFT = 0;
			SWST_LEFT = 1;
			SWST_RIGHT = 0;
		}
	}
	else
	{
		LAST_LEFT = 1;
	}	

	if(SW_RIGHT == 0)
	{
		AUTOcount = 0;
		if(LAST_RIGHT == 1)
		{
			LAST_RIGHT = 0;
			SWST_RIGHT = 1;
			SWST_LEFT = 0;
		}
	}
	else
	{
		LAST_RIGHT = 1;
	}	
}

void scanswct(void)		//scan control switches
{
	SWST_MODE = 0;
	SWST_PRO = 0;
	if(SW_MODE == 0)
	{
		AUTOcount = 0;
		MODEcount++;
		if (MODEcount > 50)
		{
			MODEcount = 0;
			Shutdown();
		}	
	}
	else
	{
		if (MODEcount)
			SWST_MODE = 1;
		MODEcount = 0;
	}	

	if(SW_PRO == 0)
	{
		AUTOcount = 0;
		if (PROcount < 50) PROcount++;
		if (PROcount == 50)
		{
			PROcount++;
			ToggleBL();
		}	
	}
	else
	{
		if ((PROcount) && (PROcount < 50))
			SWST_PRO = 1;
		PROcount = 0;
	}	
}

unsigned int tmr3ov;			//Timer 3 overflow counter
unsigned char tick;
unsigned int beep1;				//mole beep
unsigned int beep2;				//hit beep
unsigned int beep3;				//miss beep
unsigned char tone;
unsigned char sound;

#define UPTIME	10
#define MTIME	60

void main()
{
	unsigned char n;
	unsigned char gamelevel;
	unsigned char humplevel;
	unsigned char subcount;
	unsigned char gametime;
	unsigned char ltimer;
	unsigned char utimer;
	unsigned char mtimer;
	unsigned int score;
	unsigned char mole;
	unsigned char manpos;
	unsigned char humpstat[6];	//humpstat[1] - humpstat[5]
	unsigned char molemiss;
	unsigned char hump;
	unsigned char nexthump;
//	unsigned char mask;
//	char string[4];
	
	SWST_MODE = 0;
	SWST_PRO = 0;
	SWST_LEFT = 0;
	SWST_RIGHT = 0;
	LAST_MODE = 1;
	LAST_PRO = 1;
	LAST_LEFT = 1;
	LAST_RIGHT = 1;
	PROcount = 0;
	MODEcount = 0;
	AUTOcount = 0;

	gamelevel = 0;
	humplevel = 0;
	subcount = 0;
	ltimer = 0;
	utimer = 0;
	tmr3ov = 0;
	tick = 0;
	score = 0;
	manpos = 1;
	mole = 0;
	molemiss = 0;
	beep1 = 0;
	beep2 = 0;
	beep3 = 0;
	tone = 0;
	rand = 0;
	sound = 0xff;	//sound ON
	
	humpstat[0] = 0xff;
	humpstat[1] = 0;	//0 = off
	humpstat[2] = 0;	//0 = off
	humpstat[3] = 0;	//0 = off
	humpstat[4] = 0;	//0 = off
	humpstat[5] = 0;	//0 = off

 	ADCON1 = 0x0F;			// Default all pins to digital

	TRISA = 0xc0; 			// IIOOOOOO
	TRISB = 0xfd; 			// IIIIIIOI
	TRISC = 0x7f;			// OIIIIIII
	TRISD = 0x00; 			// OOOOOOOO
	TRISE = 0xF8; 			// IIIIIOOO

	INTCON2bits.RBPU = 0;	// Port B pull-ups enabled

	SPEAKER	= 0;
	BLIGHT = 0;
	LCD_POW = 1;
	
	LCD_RES = 0;
	LCD_DC  = 1;
	LCD_SCE = 1;
	LCD_SCL = 1;
	LCD_SDO = 1;

	LATDbits.LATD2 = 0;
	LATDbits.LATD3 = 0;
	
	OSCCONbits.IDLEN = 0;

	// interrupt setup
	INTCONbits.GIE = 0;		// disable high priority interrupts
	INTCONbits.PEIE = 0;	// disable low priority interrupts
	RCONbits.IPEN = 1;		// enable interrupt priority

	// Timer3 setup
	T3CONbits.RD16 = 1;		// read/write Timer3 in one 16-bit operation
	T3CONbits.T3CKPS1 = 1;	// 1:4 Prescale
	T3CONbits.T3CKPS0 = 0;	// 1:4 Prescale
	T3CONbits.TMR3CS = 0;	// Timer3 derived from Fosc/4
	T3CONbits.TMR3ON = 0;	// Stop Timer 3
	TMR3H = 0x00;			// Clear Timer 3
	TMR3L = 0x00;			// Clear Timer 3
	
	//CCP setup
	//CCP1CON = 0b00000100;	// capture mode falling edge 

	// Timer3 interrupt setup
	IPR2bits.TMR3IP = 1;	// timer3 overflow interrupt = high priority
	PIE2bits.TMR3IE = 1;	// enable Timer3 overflow interrupts
	PIR2bits.TMR3IF = 0;	// clear Timer3 interrupt flag

	// CCP1 interrupt setup
	//IPR1bits.CCP1IP = 1;	// CCP1 interrupt = high priority
	//PIE1bits.CCP1IE = 1;	// enable CCP1 interrupts
	//PIR1bits.CCP1IF = 0;	// clear CCP1 interrupt flag

	CloseSPI();				// Turn off SPI modules  if was previosly on
	OpenSPI(SPI_FOSC_64,MODE_11,SMPEND);
	
//	gotoXY(0,5);
//	LcdString("1234567890");
	LcdInitialise();
	LcdClear();
	LcdGraphic(empty);
	BGraphicY(man_2u,0,3);
	SGraphicXY(hump_1, 1, 4, 8, 0xff);
	SGraphicXY(hump_2, 14, 4, 11, 0xff);
	SGraphicXY(hump_3, 27, 4, 16, 0xff);
	SGraphicXY(hump_4, 58, 4, 11, 0xff);
	SGraphicXY(hump_5, 73, 4, 8, 0xff);
	SGraphicXY(mole_1, 1, 3, 13, 0xff);
	SGraphicXY(mole_1, 18, 3, 13, 0xff);
	SGraphicXY(mole_2, 35, 3, 13, 0xff);
	SGraphicXY(mole_3, 52, 3, 13, 0xff);
	SGraphicXY(mole_3, 69, 3, 13, 0xff);
	SGraphicXY(life, 1, 5, 9, 0xff);
	SGraphicXY(life, 12, 5, 9, 0xff);
	SGraphicXY(life, 23, 5, 9, 0xff);
	NumberXY(0,35,5);
	
	//start interrupts and timers
	INTCONbits.GIE = 1;		// enable high priority interrupts
	T3CONbits.TMR3ON = 1;	// Start Timer 3

	while(1)
	{
		scanswlr();
		if ((utimer == 0) && (gamelevel > 0))
		{
			if (SWST_LEFT)
			{
				if(manpos > 0)
				{
					manpos--;
				}	
			}	
			if (SWST_RIGHT)
			{
				if(manpos < 2)
				{
					manpos++;
				}	
			}
			if (manpos == 0) BGraphicY(man_1u,0,3);
			if (manpos == 1) BGraphicY(man_2u,0,3);
			if (manpos == 2) BGraphicY(man_3u,0,3);	
		}

		if(tick == 1)
		{
			tick = 0;
			AUTOcount++;
			if (AUTOcount > 3000)
			{
				AUTOcount = 0;
				Shutdown();
			}

			scanswct();
			if (gamelevel == 0)
			{
				if (SWST_MODE)
				{
					gamelevel = 1;		//Game A
					gametime = 35;
					subcount = 10;
				}	
				if (SWST_PRO)
				{
					gamelevel = 2;		//Game B
					gametime = 25;
					subcount = 6;
				}
				if (gamelevel)
				{
					hump = 0;
					humplevel = 4;	//4=easy, 3=mid, 2=hard
					nexthump = 0;
					mole = 0;
					manpos = 1;
					LcdGraphic(empty);	
					score = 0;
					humpstat[1] = 0;
					humpstat[2] = 0;
					humpstat[3] = 0;
					humpstat[4] = 0;
					humpstat[5] = 0;
				}	
			}
			else
			{
				if (SWST_MODE)
				{
					if (sound) sound = 0;
					else sound = 0xff;
				}	

				ltimer++;
				if (ltimer >= gametime)
				{
					ltimer = 0;
					if (!mtimer)	//don't auto inc if mole miss sequence in progress
					{
						//speed 1	1 sec
						//1		on 4 	10
						//speed 2	0.8 sec
						//11	on 3 8	7,8,9
						//19	on 2 6	4,5,6
						//25	on 4 4	3,4,5
						//speed 3	0.7
						//29	on 3 7
						//36	on 2 5
						//41	on 4 5
						//speed 4	0.6
						//46	on 3 8
						//54	on 2 5
						//59	on 4 3
						//speed 5	0.5
						//62	on 3 9
						//71	on 2 4
						//75	on 4 4
						//79	on 3 9
						//88	on 2 6
						//94	on 4 3
						//97	on 3 8
						//105	on 2 5
						//110	on 4 3
						//113	on 3 
						//
						
						if ((humpstat[1] > 0) && (humpstat[1] < 6)) humpstat[1]++; beep1 = 40;
						if ((humpstat[2] > 0) && (humpstat[2] < 6)) humpstat[2]++; beep1 = 40;
						if ((humpstat[3] > 0) && (humpstat[3] < 6)) humpstat[3]++; beep1 = 40;
						if ((humpstat[4] > 0) && (humpstat[4] < 6)) humpstat[4]++; beep1 = 40;
						if ((humpstat[5] > 0) && (humpstat[5] < 6)) humpstat[5]++; beep1 = 40;
						
						n=0;
						if (gamelevel == 1)
						{
							if (score < 10) gametime = 35;		//speed 1	1 sec
							else if (score < 25) gametime = 30;	//speed 2	0.8 sec
							else if (score < 45) gametime = 25; //speed 3	0.7
							else if (score < 60) gametime = 20;	//speed 4	0.6
							else gametime = 15;	//speed 5	0.5
							
							if (subcount == 0)
							{
								if (humplevel == 4)
								{
									humplevel = 3;
									subcount = 4 + random3();	//4,5,6
								}
								else if(humplevel == 3)
								{
									humplevel = 2;
									subcount = 3 + random3();	//3,4,5
								}	
								else // humplevel == 2
								{
									humplevel = 4;
									subcount = 7 + random3();	//7,8,9
								}	
							}
							
							while((humpstat[nexthump]) && (n++<128))
							{
								nexthump = random1();
							}	
						}
						else if (gamelevel == 2)
						{
							if (score < 25) gametime = 25;	//speed 2	0.7 sec
							else if (score < 45) gametime = 20; //speed 3	0.6
							else if (score < 60) gametime = 15;	//speed 4	0.5
							else gametime = 10;	//speed 5	0.4

							if (subcount == 0)
							{
								if (humplevel == 4)
								{
									humplevel = 3;
									subcount = 4 + random3();	//4,5,6
								}
								else if(humplevel == 3)
								{
									humplevel = 2;
									subcount = 3 + random3();	//3,4,5
								}	
								else // humplevel == 2
								{
									humplevel = 4;
									subcount = 5 + random3();	//5,6,7
								}	
							}

							while((humpstat[nexthump]) && (n++<128))
							{
								nexthump = random2();
							}	
						}
						//NumberXY(nexthump,35,5);	//debug

						if (n<128) //successful random hump selection
						{
							if ((hump == 0) || ((hump == 1)&&(humpstat[1] == humplevel)) || ((hump == 2)&&(humpstat[2] == humplevel)) || ((hump == 3)&&(humpstat[3] == humplevel)) || ((hump == 4)&&(humpstat[4] == humplevel)) || ((hump == 5)&&(humpstat[5] == humplevel)))
							{
								hump = nexthump;
								if (hump == 1)
									humpstat[1] = 1;
								else if (hump == 2)
									humpstat[2] = 1;
								else if (hump == 3)
									humpstat[3] = 1;
								else if (hump == 4)
									humpstat[4] = 1;
								else if (hump == 5)
									humpstat[5] = 1;
								subcount--;
							}
						}	
					}	
				}	
	
				if (utimer)	utimer--;
				if (mtimer) mtimer--;
				
				switch (humpstat[1])
				{
					case 0: SGraphicXY(hump_1, 1, 4, 8, 0); break;
					case 1: SGraphicXY(hump_1, 1, 4, 8, 0xc0); break;
					case 2: SGraphicXY(hump_1, 1, 4, 8, 0xf8); break;
					case 3: SGraphicXY(hump_1, 1, 4, 8, 0xff); break;
					case 4: SGraphicXY(mole_1, 1, 3, 13, 0xff); humpstat[1] = 5; break;
					case 5: if ((!molemiss)&&(manpos == 0)){SGraphicXY(mole_1_hit, 1, 3, 13, 0xff); BGraphicY(man_1l,0,3); score++; utimer = UPTIME; humpstat[1] = 7;} break;	//hit
					case 6: beep2 = 4000; SGraphicXY(mole_clear, 1, 3, 13, 0xff); mtimer = MTIME; molemiss = 1; humpstat[1] = 8; break;	//miss
					case 7: if (!utimer) {beep2 = 40; BGraphicY(man_1u,0,3); SGraphicXY(mole_clear, 1, 3, 13, 0xff); SGraphicXY(hump_1, 1, 4, 8, 0); humpstat[1] = 0;} break;
					case 8: if (!mtimer) {beep1 = 40; SGraphicXY(hump_1, 1, 4, 8, 0xf8); mtimer = MTIME; humpstat[1] = 9;} break;
					case 9: if (!mtimer) {beep1 = 40; SGraphicXY(hump_1, 1, 4, 8, 0xc0); mtimer = MTIME; humpstat[1] = 10;} break;
					case 10: if (!mtimer) {beep1 = 40; SGraphicXY(hump_1, 1, 4, 8, 0x00); mole++; mtimer = MTIME; humpstat[1] = 11;} break;
					case 11: if (!mtimer) humpstat[1] = 0; if(humplevel==2) hump = 0; break;
				}	
				switch (humpstat[2])
				{
					case 0: SGraphicXY(hump_2, 14, 4, 11, 0); break;
					case 1: SGraphicXY(hump_2, 14, 4, 11, 0xc0); break;
					case 2: SGraphicXY(hump_2, 14, 4, 11, 0xf8); break;
					case 3: SGraphicXY(hump_2, 14, 4, 11, 0xff); break;
					case 4: SGraphicXY(mole_1, 18, 3, 13, 0xff); humpstat[2] = 5; break;
					case 5: if ((!molemiss)&&(manpos == 1)){SGraphicXY(mole_1_hit, 18, 3, 13, 0xff); BGraphicY(man_2l,0,3); score++; utimer = UPTIME; humpstat[2] = 7;} break;	//hit
					case 6: beep2 = 4000; SGraphicXY(mole_clear, 18, 3, 13, 0xff); mtimer = MTIME; molemiss = 1; humpstat[2] = 8; break; //miss
					case 7: if (!utimer) {beep2 = 40; BGraphicY(man_2u,0,3); SGraphicXY(mole_clear, 18, 3, 13, 0xff); SGraphicXY(hump_2, 14, 4, 11, 0); humpstat[2] = 0;} break;
					case 8: if (!mtimer) {beep1 = 40;SGraphicXY(hump_2, 14, 4, 11, 0xf8); mtimer = MTIME; humpstat[2] = 9;} break;
					case 9: if (!mtimer) {beep1 = 40;SGraphicXY(hump_2, 14, 4, 11, 0xc0); mtimer = MTIME; humpstat[2] = 10;} break;
					case 10: if (!mtimer) {beep1 = 40;SGraphicXY(hump_2, 14, 4, 11, 0x00); mole++; mtimer = MTIME; humpstat[2] = 11;} break;
					case 11: if (!mtimer) humpstat[2] = 0; if(humplevel==2) hump = 0; break;
				}	
				switch (humpstat[3])
				{
					case 0: SGraphicXY(hump_3, 27, 4, 16, 0); break;
					case 1: SGraphicXY(hump_3, 27, 4, 16, 0xc0); break;
					case 2: SGraphicXY(hump_3, 27, 4, 16, 0xf8); break;
					case 3: SGraphicXY(hump_3, 27, 4, 16, 0xff); break;
					case 4: SGraphicXY(mole_2, 35, 3, 13, 0xff); humpstat[3] = 5; break;
					case 5: if ((!molemiss) && (manpos == 0)){SGraphicXY(mole_2_hit, 35, 3, 13, 0xff); BGraphicY(man_1r,0,3); score++; utimer = UPTIME; humpstat[3] = 7;} //hit
							else if ((!mtimer) && (manpos == 2)){SGraphicXY(mole_2_hit, 35, 3, 13, 0xff); BGraphicY(man_3l,0,3); score++; utimer = UPTIME; humpstat[3] = 7;} break;
					case 6: beep2 = 4000; SGraphicXY(mole_clear, 35, 3, 13, 0xff); mtimer = MTIME; molemiss = 1; humpstat[3] = 8; break;
					case 7: if (!utimer) {beep2 = 40; if(manpos == 0) BGraphicY(man_1u,0,3); else if(manpos == 2) BGraphicY(man_3u,0,3); SGraphicXY(mole_clear, 35, 3, 13, 0xff); SGraphicXY(hump_3, 27, 4, 16, 0); humpstat[3] = 0;} break;
					case 8: if (!mtimer) {beep1 = 40; SGraphicXY(hump_3, 27, 4, 16, 0xf8); mtimer = MTIME; humpstat[3] = 9;} break;
					case 9: if (!mtimer) {beep1 = 40; SGraphicXY(hump_3, 27, 4, 16, 0xc0); mtimer = MTIME; humpstat[3] = 10;} break;
					case 10: if (!mtimer) {beep1 = 40; SGraphicXY(hump_3, 27, 4, 16, 0x00); mole++; mtimer = MTIME; humpstat[3] = 11;} break;
					case 11: if (!mtimer) humpstat[3] = 0; if(humplevel==2) hump = 0; break;
				}	
				switch (humpstat[4])
				{
					case 0: SGraphicXY(hump_4, 58, 4, 11, 0); break;
					case 1: SGraphicXY(hump_4, 58, 4, 11, 0xc0); break;
					case 2: SGraphicXY(hump_4, 58, 4, 11, 0xf8); break;
					case 3: SGraphicXY(hump_4, 58, 4, 11, 0xff); break;
					case 4: SGraphicXY(mole_3, 52, 3, 13, 0xff); humpstat[4] = 5; break;
					case 5: if ((!molemiss)&&(manpos == 1)){SGraphicXY(mole_3_hit, 52, 3, 13, 0xff); BGraphicY(man_2r,0,3); score++; utimer = UPTIME; humpstat[4] = 7;} break;	//hit
					case 6: beep2 = 4000; SGraphicXY(mole_clear, 52, 3, 13, 0xff); mtimer = MTIME; molemiss = 1; humpstat[4] = 8; break;
					case 7: if (!utimer) {beep2 = 40; BGraphicY(man_2u,0,3); SGraphicXY(mole_clear, 52, 3, 13, 0xff); SGraphicXY(hump_4, 58, 4, 11, 0); humpstat[4] = 0;} break;
					case 8: if (!mtimer) {beep1 = 40; SGraphicXY(hump_4, 58, 4, 11, 0xf8); mtimer = MTIME; humpstat[4] = 9;} break;
					case 9: if (!mtimer) {beep1 = 40; SGraphicXY(hump_4, 58, 4, 11, 0xc0); mtimer = MTIME; humpstat[4] = 10;} break;
					case 10: if (!mtimer) {beep1 = 40; SGraphicXY(hump_4, 58, 4, 11, 0x00); mole++; mtimer = MTIME; humpstat[4] = 11;} break;
					case 11: if (!mtimer) humpstat[4] = 0; if(humplevel==2) hump = 0; break;
				}	
				switch (humpstat[5])
				{
					case 0: SGraphicXY(hump_5, 73, 4, 8, 0); break;
					case 1: SGraphicXY(hump_5, 73, 4, 8, 0xc0); break;
					case 2: SGraphicXY(hump_5, 73, 4, 8, 0xf8); break;
					case 3: SGraphicXY(hump_5, 73, 4, 8, 0xff); break;
					case 4: SGraphicXY(mole_3, 69, 3, 13, 0xff); humpstat[5] = 5; break;
					case 5: if ((!molemiss)&&(manpos == 2)){SGraphicXY(mole_3_hit, 69, 3, 13, 0xff); BGraphicY(man_3r,0,3); score++; utimer = UPTIME; humpstat[5] = 7;} break;	//hit
					case 6: beep2 = 4000; SGraphicXY(mole_clear, 69, 3, 13, 0xff); mtimer = MTIME; molemiss = 1; humpstat[5] = 8; break;
					case 7: if (!utimer) {beep2 = 40; BGraphicY(man_3u,0,3); SGraphicXY(mole_clear, 69, 3, 13, 0xff); SGraphicXY(hump_5, 73, 4, 8, 0); humpstat[5] = 0;} break;
					case 8: if (!mtimer) {beep1 = 40; SGraphicXY(hump_5, 73, 4, 8, 0xf8); mtimer = MTIME; humpstat[5] = 9;} break;
					case 9: if (!mtimer) {beep1 = 40; SGraphicXY(hump_5, 73, 4, 8, 0xc0); mtimer = MTIME; humpstat[5] = 10;} break;
					case 10: if (!mtimer) {beep1 = 40; SGraphicXY(hump_5, 73, 4, 8, 0x00); mole++; mtimer = MTIME; humpstat[5] = 11;} break;
					case 11: if (!mtimer) humpstat[5] = 0; if(humplevel==2) hump = 0; break;
				}
				if (!mtimer) molemiss = 0;
				if (mole == 1) SGraphicXY(life, 1, 5, 9, 0xff);
				if (mole == 2) SGraphicXY(life, 12, 5, 9, 0xff);
				if (mole == 3) {SGraphicXY(life, 23, 5, 9, 0xff); gamelevel = 0; beep3 = 8000;} //end game
				NumberXY(score,35,5);
			}		
		}		
	}		

//exterminator_all	//empty
//hump_1 1,4 8	//hump_2 14,4 11//hump_3 27,4 16//hump_4 58,4 11//hump_5 73,4 8
//life 1,5 12,5 23,5 9
//man_1l 0,3	//man_1r 0,3	//man_1u 0,3
//man_2l 0,3	//man_2r 0,3	//man_2u 0,3
//man_3l 0,3	//man_3r 0,3	//man_3u 0,3
//mole_1 1,3 18,3	//mole_1_hit 1,3 18,3	13
//mole_2 35,3		//mole_2_hit 35,3		13
//mole_3 52,3 69,3	//mole_3_hit 52,3 69,3	13
//mole_clear 1,3 18,3 35,3 52,3 69,3		13

	//CloseSPI();							// Turn off SPI modules  if was previosly on
}

//These are your actual interrupt handling routines.
#pragma interrupt YourHighPriorityISRCode
	void YourHighPriorityISRCode()
	{
		//LATDbits.LATD3 = 1;		// turn on LED
		if(PIR2bits.TMR3IF)			//timer 3 overflow
		{
			TMR3H = 0xfe;			// Set Timer 3 Hi
			TMR3L = 0x00;			// Set Timer 3 Lo
			tmr3ov++;
			PIR2bits.TMR3IF = 0;	// clear Timer3 interrupt flag
			//LATDbits.LATD3 = ~LATDbits.LATD3;	//toggle red LED
			if (tmr3ov == 128)
			{
				tmr3ov = 0;
				tick = 1;
				//LATDbits.LATD2 = ~LATDbits.LATD2;	//toggle other red LED
			}
			if (sound)
			{
				if (beep1)	//35ms @ 2kHz
				{
					beep1--;
					SPEAKER = ~SPEAKER;
				}
				else if (beep2)	//50ms gap 50ms @ ?kHz
				{
					beep2--;
					tone++;
					if (tone > 1)
					{
						tone = 0;
						SPEAKER = ~SPEAKER;
					}	
				}
				else if (beep3)//300ms @ ?kHz
				{
					beep3--;
					tone++;
					if (tone > 3)
					{
						tone = 0;
						SPEAKER = ~SPEAKER;
					}	
				}
				else
				{
					SPEAKER = 0;
				}
				//end game 1.3secs of 20ms @ 2kHz 20ms @ ?kHz
			}	
			else
			{
				SPEAKER = 0;
				beep1 = 0;
				beep2 = 0;
				beep3 = 0;
			}	
		}
	}	//This return will be a "retfie fast", since this is in a #pragma interrupt section 


#pragma interruptlow YourLowPriorityISRCode
	void YourLowPriorityISRCode()
	{
		//Check which interrupt flag caused the interrupt.
		//Service the interrupt
		//Clear the interrupt flag
		//Etc.
	
	}	

