
//Flight Simulator Code for 'Arduino Serial PWM'
//By Dominick Lee | Copyright (c) 2013. All Rights Reserved.

/* The goal of the Arduino program is to design code that will

	1. Accept serial input at 57600 BAUD (for high data transfer).
	2. Parse the signals by byte.
	3. Be able to convert voltages (from 0-5v) to the tenth decimal place to analog 255.
	4. Do an inverse conversion to reverse the voltage command.
	5. Recognize which pin to turn on the PWM signal; 'p' for pitch, and 'r' for roll.
	6. Send the PWM signals rapidly and efficiently every milisecond. The less code, the better.
*/


int incomingByte = 0;   //variable for incoming serial data

int roll = 10;    //Digital Pin for Roll

int pitch = 9;    //Digital Pin for Pitch

int volts (float voltage)    //this function converts voltage to analog 0-255 values
{
  float analogval;
  analogval = ((255 * voltage)/5);    //equation to convert analog to 5 volts max
  return analogval;
}


float getFloatFromSerialMonitor(){    // this function parses and converts voltages
  char inData[20];  
  float f=0;    
  int x=0;  
  while (x<1){  
  if (Serial.available()) {
    delay(5); //lower the better
    int i=0;
    while (Serial.available() > 0) {
     char  inByte = Serial.read();
      str=str+inByte;
      inData[0]=inByte;
      i+=1;
      x=2;
    }
    f = atof(inData);
    memset(inData, sizeof(inData));  
  }
  }//END WHILE X<1  
   return f; 
  }


void setup() {							// this is the initial setup function
  // initialize serial communication:
  Serial.begin(57600);
  pinMode(13, OUTPUT);  				//we want to start pin 13. Other pins are analog and don't need to be declared.

}


void loop() {
    digitalWrite(13, HIGH);   // set the power indicator on
  
      // send data only when you receive data:
        if (Serial.available() > 0) {
                // read the incoming byte:
                incomingByte = Serial.read();

                if (incomingByte == 114) {  //we got roll
                Serial.println("roll");
                float x = getFloatFromSerialMonitor();  //obtain 'x' as volts
                Serial.print(x);            //variable to get volts
                Serial.print("v");
                Serial.print(" Analog ");
                Serial.println(volts(x));
                analogWrite(roll, volts(x));     
                }
                if (incomingByte == 112) {  //we got pitch
                Serial.println("pitch"); 				
                float x = getFloatFromSerialMonitor();  //obtain 'x' as volts
                Serial.print(x);           //variable to get volts
                Serial.print("v");
                Serial.print(" Analog ");
                Serial.println(volts(x));        
                analogWrite(pitch, volts(x));            
                }
                
        }

} //end loop

