﻿package com.SocketsConnection{
	import flash.display.DisplayObject;
	import flash.events.*;
	import fl.controls.Slider;
	import fl.events.SliderEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import com.Red5Link.Red5SharedObject;
	import com.SocketsConnection.SocketModel;

	public class XMLSocketAppController extends XMLSocketController {
		private var _colaboratingModel:*;
		private var closeConnectionTimer:Timer;
		

		public function XMLSocketAppController() {
			closeConnectionTimer=new Timer(2000,1);
			closeConnectionTimer.addEventListener("timer", closeConnectionHandler);
		}

		public function set colaboratingModel(colabMod:*):void {
			_colaboratingModel=colabMod;
			_colaboratingModel.addEventListener(SocketModel.ARDUINO_SOCKET_INCOMING_DATA, arduinoIncomingData);
		}

		public function get colaboratingModel():* {
			return _colaboratingModel;
		}
		
		public function arduinoIncomingData(event:Event=null):void{
			var evalStr:String=colaboratingModel.data.toString().substr(0,3);
			
			if(evalStr=="WIN"){
				trace("==============");
				trace("WINNER");
				socketsModel.sendMessage("<arduino>WIN</arduino>");
				trace("==============");
			}
		}

		public function addSendArduinoButton(btn:DisplayObject):void {
			btn.addEventListener(MouseEvent.CLICK, sendArduinoMessage);
		}
		
		public function sendArduinoMessage(e:MouseEvent):void {
			trace("send to arduino="+parseArduinoCommand(inputText.text))
			colaboratingModel.sendCommand(parseArduinoCommand(inputText.text));
			inputText.text="";
		}

		override protected function messageRecived(messageXml:XML):void {
			/////////////////////////////////////////////
			// send message through colaboratingModel
			/////////////////////////////////////////////
			if (messageXml.child(0).name()=="arduino-command") {
				trace(parseArduinoCommand(messageXml.child(0).toString()));				
				//colaboratingModel.sendCommand(parseArduinoCommand(messageXml.child(0).toString()));
			}
		}

		override protected function resourceConnected(resourceXml:XML):void{
			//trace("resourceXml="+int(resourceXml.@resourcesCount));
			if(int(resourceXml.@resourcesCount)>1){
				if(int(resourceXml.@resourcesCount)==2){
					videoBroadcast.broadcastStream();
					objectsToShare=new Array(motorX,motorY,motorZ);
					sharedObject.startSharedObject(objectsToShare);
					sharedObject.addEventListener(Red5SharedObject.ON_SYNC,sharedObjectSync);
				}
				if(closeConnectionTimer.running){
					closeConnectionTimer.reset();
				}
				socketsModel.sendMessage("<broadcast>STARTED</broadcast>");
			}else{
				closeConnectionTimer.start();
				socketsModel.sendMessage("<broadcast>STOPED</broadcast>");
			}
		}
		
		protected function parseArduinoCommand(str:String):Array{
			var arrayPosition=0;
			var tempStr:String="";
			var tempInt:int;
			var commandArray:Array=new Array();
			for(var i=0;i<str.length;i++){
				if(str.charAt(i)!="," && str.charAt(i)!="!"){
					if(i<(str.length-1)){
						tempStr=tempStr+str.charAt(i);
					}else{
						tempStr=tempStr+str.charAt(i);
						commandArray.push(int(tempStr));
					}
				}else if(str.charAt(i)=="!"){					
					tempStr=tempStr+str.charAt(i);
					commandArray.push(tempStr);
					tempStr="";
				}else if(str.charAt(i)=="," && tempStr.length>0 && i<(str.length-1)){					
					commandArray.push(int(tempStr));
					tempStr="";
				}
			}
			return commandArray;
		}
		
		override protected function sliderRelease(e:SliderEvent):void {
			var commandArray:Array=new Array(6,6,6);
			e.target.value=6;
			sharedObject.pushSync();
			sliderPressed=false;
			//colaboratingModel.sendCommand(commandArray);
			//inputText.text="";
		}
		
		override protected function sliderPress(e:SliderEvent):void {
			sliderPressed=true;
			
			/*
			var commandArray:Array=new Array(6,6,6);
			if(e.target.name=="motorX"){
				commandArray[0]=e.target.value;
			}else if(e.target.name=="motorY"){
				commandArray[1]=e.target.value;
			}else if(e.target.name=="motorZ"){
				commandArray[2]=e.target.value;
			}
			//trace("commandArray="+commandArray)
			sharedObject.pushSync();
			//colaboratingModel.sendCommand(commandArray);
			//inputText.text="";*/
		}
		
		override protected function sliderChange(e:SliderEvent):void {
			var commandArray:Array=new Array(6,6,6);
			if(e.target.name=="motorX"){
				commandArray[0]=e.target.value;
			}else if(e.target.name=="motorY"){
				commandArray[1]=e.target.value;
			}else if(e.target.name=="motorZ"){
				commandArray[2]=e.target.value;
			}
			if(sliderPressed){
				sharedObject.pushSync();
			}
			//trace("<arduino-command>"+commandArray+"</arduino-command>")
			colaboratingModel.sendCommand(commandArray);
		}
		
		override public function sliderChangedBySharedObject():void{
			trace("SLIDER CHANGED BY SHARED OBJECT");
			var commandArray:Array=new Array(motorX.value,motorY.value,motorZ.value);
			colaboratingModel.sendCommand(commandArray);
		}
		
		private function closeConnectionHandler(event:TimerEvent):void {
			var commandArray:Array=new Array(6,6,6);
			colaboratingModel.sendCommand(commandArray);
            videoBroadcast.stopBroadcastingStream();
			sharedObject.stopSharedObject();
        }
	}
}