#include "WProgram.h"
/* Flare-Up Pumpkin Control Software V1.0
 * ---------------- 
 *
 *This program runs a program to read sensor input from a light sensor that turns
 *on a gas line when a shadow is cast on the sensor.
 *
 *The software also can activate an optional strobe light when the flame ignites
 *based on a second light(non optional) sensor. The second light sensor also
 *signals that the flame has lit, and to turn off the gas. 
 *
 * Created October 24, 2008
 * copyleft 2008 Jonathan Hodgins
 */

/*Declare Variables*/

void setup();
void loop();
int passSensorPin=0,passSensor=0,oldPassSensor=0;//the sensor to detect when somone passes
int flameSensorPin=1,flameSensor=0,oldFlameSensor=0;//the sensor used to detect when the gas ignites

/*determines how sensitive the sensors are. Lower is more sensitive, higher is less.
 *alter these to work with your sensors
 */
int flameTripValue=60,passTripValue=30;

/*I used 2 pins here rather than connect one to ground because the headers I used
 *to attach to the arduino were only 2 wide, and I wanted to easily remove the
 *individual components if needed, so the wire systems are separate
 */
int gasPins[2]={
  2,3};
bool gasOn=false;

int strobePins[2]={
  4,5};
bool strobeOn=false;


/*Setup - Code run once at the start, used to set outputs to starting values*/
void setup()//in this section outputs and arrays are initialized
{
  for(int i=0;i<2;i++)//activate outputs
  {
    pinMode(gasPins[i],OUTPUT);
    digitalWrite(gasPins[i],LOW);
    pinMode(strobePins[i],OUTPUT);
    digitalWrite(strobePins[i],LOW);
  }

  //initialized gas values
  passSensor = analogRead(passSensorPin);
  flameSensor = analogRead(flameSensorPin);
}

/*The main program loop*/
void loop()
{
  //read the sensor to detect people walking by
  if(!strobeOn)//no strobe because it interferes with the sensor
  {
    oldPassSensor = passSensor;
    passSensor = analogRead(passSensorPin);
  }

  //read the flame sensor
  oldFlameSensor=flameSensor;
  flameSensor = analogRead(flameSensorPin);

  if(passSensor-oldPassSensor>passTripValue)//turn on the gas value
  {
    gasOn=true;
  }
  if(strobeOn)//deactivate gas in code
  {
    gasOn=false;
  }

  if(flameSensor-oldFlameSensor>flameTripValue)//turn strobe value off
  {
    strobeOn=true;
  }
  else if(flameSensor-oldFlameSensor<-flameTripValue)//turn strobe value off
  {
    strobeOn=false;
  }

  if(gasOn)//turn the gas on
  {
    digitalWrite(gasPins[0],HIGH);
  }
  else//Turn gas off
  {
    digitalWrite(gasPins[0],LOW);
  }

  if(strobeOn)//turn the strobe light on
  {
    digitalWrite(strobePins[0],HIGH);
    delay(500);
  }
  else//turn off the strobe light
  {
    digitalWrite(strobePins[0],LOW);
    delay(300);//allow for any last flashes
  }

  delay(10);//delays the program so the changes in the sensor values are exaggerated
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

