
/*************************************************** 
  Wifi Notifaction Flag by Louis Elwood-Leach.
 
  Must use ESP8266 Arduino from:
    https://github.com/esp8266/Arduino

  Works great with Adafruit's Huzzah ESP board & Feather
  ----> https://www.adafruit.com/product/2471
  ----> https://www.adafruit.com/products/2821

  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Includes Code from Adafruit MQTT Library ESP8266 Example Written by Tony DiCola for Adafruit Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/

#include <ESP8266WiFi.h>
#include "Adafruit_MQTT.h"
#include "Adafruit_MQTT_Client.h"
#include <Servo.h>
#include <EEPROM.h>

Servo flagServo;

int angle;

const int buttonPin = 12;
int buttonState;

const int delayval = 1000;   // Increase delay to prolong battery life
  
/************************* WiFi Access Point *********************************/

#define WLAN_SSID       "...YOUR WI-FI NETWORK..."
#define WLAN_PASS       "...YOUR WI-FI PASSWORD..."

/************************* Adafruit.io Setup *********************************/

#define AIO_SERVER      "io.adafruit.com"
#define AIO_SERVERPORT  1883   // use 8883 for SSL
#define AIO_USERNAME    "...YOUR IO.ADAFRUIT USERNAME..."
#define AIO_KEY         "...YOUR IO.ADAFRUIT KEY..."

/************ Global State (you don't need to change this!) ******************/

// Create an ESP8266 WiFiClient class to connect to the MQTT server.
WiFiClient client;   // or... use WiFiFlientSecure client; for SSL

// Setup the MQTT client class by passing in the WiFi client and MQTT server and login details.
Adafruit_MQTT_Client mqtt(&client, AIO_SERVER, AIO_SERVERPORT, AIO_USERNAME, AIO_KEY);

/****************************** Feeds ***************************************/

// Setup a feed called 'flag' for publishing and receiveing.
// Note that MQTT paths for io.adafruit follow the form: <username>/feeds/<feedname>
Adafruit_MQTT_Publish turnoff = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/flag");
Adafruit_MQTT_Subscribe turnon = Adafruit_MQTT_Subscribe(&mqtt, AIO_USERNAME "/feeds/flag");

/*************************** Sketch Code ************************************/

void MQTT_connect();
void ledLight(char*);

void setup() {

  Serial.begin(115200);
  delay(10);
  
  flagServo.attach(14); 
  pinMode(LED_BUILTIN, OUTPUT);
  pinMode(buttonPin, INPUT);

/************************* Connect to WIFI *********************************/

  Serial.print("Connecting to");
  Serial.println(WLAN_SSID);

  WiFi.begin(WLAN_SSID, WLAN_PASS);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println();

  Serial.println("WiFi connected");
  Serial.println("IP address: "); Serial.println(WiFi.localIP());

  mqtt.subscribe(&turnon);   // Setup MQTT subscription for onoff feed.
}

uint32_t x=0;

/************************* Read Button *********************************/

void loop() {

int buttonState = digitalRead(buttonPin);
if (buttonState == HIGH) {
  Serial.println("CLICK");
}
  
/************************* Subscribe to AIO *********************************/

  Adafruit_MQTT_Subscribe *subscription;
  while ((subscription = mqtt.readSubscription(delayval))) {
    if (subscription == &turnon) {
      Serial.print(F("Got: "));
      Serial.println((char *)turnon.lastread);
      ledLight((char *)turnon.lastread);
    }
  }

/************************* Publish to AIO *********************************/
 
 if (buttonState == HIGH) {
  turnoff.publish("OFF");
  Serial.println("PUBLISH");
 }

/************************* Connection *********************************/

MQTT_connect();
}

void MQTT_connect() {
  int8_t ret;

  if (mqtt.connected()) {
    return;
  }

  Serial.print("Connecting to MQTT... ");

  uint8_t retries = 3;
  while ((ret = mqtt.connect()) != 0) { 
       Serial.println(mqtt.connectErrorString(ret));
       Serial.println("Retrying MQTT connection in 5 seconds...");
       mqtt.disconnect();
       delay(delayval);
       retries--;
       if (retries == 0) {
         while (1);
       }
  }
  Serial.println("MQTT Connected!");
}

/************************* Onboard LED indicator and Servo *********************************/

void ledLight(char* what){
  if (String(what) == "ON"){
    digitalWrite(LED_BUILTIN, LOW);
    flagServo.write(90);
  }
  else{
    digitalWrite(LED_BUILTIN, HIGH);
    flagServo.write(180);
  };
}
