//
//  EntertainmentCenterController.m
//  EntertainmentCenter
//
//  Created by Tony DeRose on 6/21/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import "EntertainmentCenterController.h"


// Command strings (same order as EcCommands)
//
// NOTE: These strings must match the symbol table entries
// on the Arduino side.
static char *commandStrings[] = {
    "mute",
    "unmute",
    "audioOn",
    "audioOff",
    "audioVolumeUp",
    "audioVolumeDown",
    "videoOn",
    "videoOff",
    "videoVolumeUp",
    "videoVolumeDown",
    "videoChannelUp",
    "videoChannelDown",
    "tv",
    "iTunes",
    "dvd",
    "cd",
    "audioAuxChannel",
    "audioVideoChannel",
    "audioCDChannel",
    "audioMute",
    "videoMute",
    "videoInput",
    "videoUpKey",
    "videoDownKey",
    "off",
    "videoIsOn",
    "videoIsOff",
    "appleTV",
    "appleLeft",
    "appleRight",
    "appleUp",
    "appleDown",
    "appleSelect",
    "appleMenu",
    "applePlay",
    "dvdPlay",
    "dvdPause",
    "dvdPrev",
    "dvdNext",
    "audioSpeakersA",
    "audioSpeakersB",
    "dvdLeft",
    "dvdRight",
    "dvdUp",
    "dvdDown",
    "dvdSelect",
    "videoGuide",
    "videoLeftKey",
    "videoRightKey",
    "videoSelectKey",
    "rainbow",
    "kqed",
    "video0",
    "video1",
    "video2",
    "video3",
    "video4",
    "video5",
    "video6",
    "video7",
    "video8",
    "video9",
    "videoPageUp",
    "videoPageDown",
    "nbc",
    "cbs",
    "cnn",
    "abc",
    "kqedTv",
    "fox",
    "arcOn",
    "arcOff",
    "arcThrob",
    "arcAny",
    "lightOff",
};

static EntertainmentCenterController *mainController = nil;

@implementation EntertainmentCenterController

+ (EntertainmentCenterController *) mainController
{
    if (!mainController) {
        mainController = [[EntertainmentCenterController alloc] init];
    }
    return mainController;
}

// Send a command string to the web server controlling the entertainment center
- (void) sendCommandString: (const char *) cmdString
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    NSString *ipAddress = [userDefaults objectForKey:@"ipAddress"];

    // If the ipaddress is the empty string, don't do anything. This is helpful for debugging
    // the interface without actually doing anything.
    if ([ipAddress isEqualToString:@""]) return;

    // Send a synchronous request
    NSString *urlString = [NSString stringWithFormat: @"http://%@/%s", ipAddress, cmdString];
    NSLog(@"Sending command: %@", urlString);
    NSURLRequest * urlRequest = [NSURLRequest requestWithURL:[NSURL URLWithString: urlString]];
    NSURLResponse * response = nil;
    NSError * error = nil;
    NSData * data = [NSURLConnection sendSynchronousRequest:urlRequest
                                          returningResponse:&response
                                                      error:&error];
    
    if (error == nil) {
        // Success
        NSString *reply = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
        NSLog(@"Reply = ");
        NSLog(@"%@", reply);
        
        // convert to JSON
        NSError *myError = nil;
        status = [NSJSONSerialization JSONObjectWithData: data options:NSJSONReadingMutableLeaves error:&myError];
        
        if (myError) {
            NSLog(@"Error: %@", [myError localizedDescription]);
        }
        
        // show all values
        for(id key in status) {
            
            id value = [status objectForKey:key];
            
            NSString *keyAsString = (NSString *)key;
            NSString *valueAsString = (NSString *)value;
            
            NSLog(@"key: %@", keyAsString);
            NSLog(@"value: %@", valueAsString);
        }

    } else {
        // Failure
        NSLog(@"Connection failed");
        NSLog(@"%@", [error localizedDescription]);
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Network error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil];
        [alertView show];
    }
}

// Send a command to the web server controlling the entertainment center
- (void) sendCommand: (EcCommand) cmd
{
    [self sendCommandString: commandStrings[cmd]];
}

- (NSString *) valueForKey: (NSString *) key
{
    NSString *value = (NSString *) [status objectForKey: key];
    return value;
}
@end
