#include "RGB_LED.h"

//
// Copied from www.cs.rit.edu/~ncs/color/t_convert.html
//
void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
    int i;
    float f, p, q, t;
    if( s == 0 ) {
        // achromatic (grey)
        *r = *g = *b = v;
        return;
    }
    h /= 60;// sector 0 to 5
    i = floor( h );
    f = h - i;// factorial part of h
    p = v * ( 1 - s );
    q = v * ( 1 - s * f );
    t = v * ( 1 - s * ( 1 - f ) );
    switch( i ) {
    case 0:
        *r = v;
        *g = t;
        *b = p;
        break;
    case 1:
        *r = q;
        *g = v;
        *b = p;
        break;
    case 2:
        *r = p;
        *g = v;
        *b = t;
        break;
    case 3:
        *r = p;
        *g = q;
        *b = v;
        break;
    case 4:
        *r = t;
        *g = p;
        *b = v;
        break;
    default:// case 5:
        *r = v;
        *g = p;
        *b = q;
        break;
    }
}


RGB_LED::RGB_LED( uint8_t redPin, uint8_t greenPin, uint8_t bluePin, bool isOnWhenHigh)
{
    pinMode( redPin, OUTPUT);
    red.Initialize( redPin);
    red.SetIsOnWhenHigh( isOnWhenHigh);     // false for common anode RGB LEDs
    
    pinMode( greenPin, OUTPUT);
    green.Initialize( greenPin);
    green.SetIsOnWhenHigh( isOnWhenHigh);

    pinMode( bluePin, OUTPUT);
    blue.Initialize( bluePin);
    blue.SetIsOnWhenHigh( isOnWhenHigh);
    ticks = 0;
    mode = MANUAL;
}

void RGB_LED::SetSmoothDelay( uint8_t delay)
{
    red.SetSmoothDelay( delay);
    green.SetSmoothDelay( delay);
    blue.SetSmoothDelay( delay);
}

void RGB_LED::SetRGB( uint8_t redIntensity, uint8_t greenIntensity, uint8_t blueIntensity)
{
    red.SetIntensity( redIntensity);
    green.SetIntensity( greenIntensity);
    blue.SetIntensity( blueIntensity);
}

void RGB_LED::SetHSV( float h, float s, float v)
{
    float r, g, b;
    HSVtoRGB( &r, &g, &b, h, s, v);
    
    // r, g, b are in [0,1], convert to {0..255}
    uint8_t redIntensity = uint8_t(r * 255);
    uint8_t greenIntensity = uint8_t( g * 255);
    uint8_t blueIntensity = uint8_t( b * 255);
    this->SetRGB( redIntensity, greenIntensity, blueIntensity);
}

void RGB_LED::SetMode( Mode newMode)
{
    mode = newMode;
    ticks = 0;
    switch (mode) {
    case RAINBOW:
        hue = 0.0;
        red.SetMode(LED::OFF);
        green.SetMode(LED::OFF);
        blue.SetMode(LED::OFF);
        this->SetHSV( 0, 1.0, 1.0);
        break;
    case FADE_OFF:
        red.SetMode( LED::SMOOTH_OFF);
        green.SetMode( LED::SMOOTH_OFF);
        blue.SetMode( LED::SMOOTH_OFF);
        break;
    case MANUAL:
        red.SetMode(LED::OFF);
        green.SetMode(LED::OFF);
        blue.SetMode(LED::OFF);
    default:
        break;
    }
}

void RGB_LED::Update()
{
    ticks ++;
    red.Update();
    green.Update();
    blue.Update();

    switch (mode) {
    case MANUAL:
        break;
    case RAINBOW:
        if (ticks == 200) {
            ticks = 0;
            hue += 1.0;
            if (hue > 359.0) hue = 0.0;
            this->SetHSV( hue, 1.0, 1.0);
        }
        break;
    }
}
