
// Firmware for Car Stereo Alexa Module v1.0 3/9/2017
// Allan Murray
// Subscribes to an MQTT server and sends messages to MP3 player via serial link

#include <PubSubClient.h>
#include <ESP8266WiFi.h>


#define MQTT_AUTH    //  Uncomment if using MQTT login with password

const char* ssid = "XXXXXX";    //  Wifi ssid
const char* password = "XXXXXX";   //  Wifi password

#ifdef MQTT_AUTH
const char* mqtt_user = "stereo_user";    //  MQTT login (if used)
const char* mqtt_password = "XXXXXX";    //  MQTT password (if used)
#endif

char* topic = "STEREO";     //  MQTT Topic
char* server = "ec2-XX-XXX-XXX-X.XXXXXX.amazonaws.com";  // Address of MQTT server


 
char message_buff[100];   

unsigned long thistime=0;
unsigned long lasttime=0;
 
void callback(char* topic, byte* payload, unsigned int length) {
    int i = 0;
  Serial.println("ppp");  //  Send command to pause MP3 (otherwise interferes with serial read)
  delay(200);
  for(i=0; i<length; i++) {
    message_buff[i] = payload[i];
  }
  message_buff[i] = '\0';
  String msgString = String(message_buff);
  Serial.println(msgString);
}

 
WiFiClient wifiClient;
PubSubClient client(server, 1883, callback, wifiClient);
 
 
String macToStr(const uint8_t* mac)
{
  String result;
  for (int i = 0; i < 6; ++i) {
    result += String(mac[i], 16);
    if (i < 5)
      result += ':';
  }
  return result;
}
 
void setup() {
  Serial.begin(9600);
  delay(10);

  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  
  WiFi.begin(ssid, password);
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected");  
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

}

void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
    
    #ifdef MQTT_AUTH
    if (client.connect("STEREOclient", mqtt_user, mqtt_password)) 
    #else
    if (client.connect("STEREOclient")) 
    #endif
    {
      client.subscribe(topic); 
      Serial.println("connected");
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}
 
void loop() {
  
  if (!client.connected()) {
    reconnect();
  }
  
  client.loop();

  thistime=millis();
  if ((thistime-lasttime)>4000) {
  lasttime=thistime;
  if (client.connected()) Serial.println("MQY");  //  Send connection status to MP3 player every 4 seconds
  else Serial.println("MQN");
  }
  delay(500);
}


