// ESP8266 Wi-FI uploads temperature from DS18B20 to Xively and sleeps.
// Battery operated. 30 uA measured current in sleep mode, 75 mA when running
// Programmed with Arduino IDE 1.6.5. Generic ESP8266, 115200. To enter program mode connect gpio0 to gnd with switch and cycle power.
// ON ESP-03 board is used having more pins. It has no onboard leds and no reset pin. Solder CH_PD to 3.3V. Solder GPIO15 to gnd. Solder a bridge for wakeup from deepsleep.
// Configuration via webpage If the attached button is pressed, led blinks a few times and access point "ESP8266" is created. 
// Browse 192.168.4.1 to enter connection and sensor details and store in flash

#include <ESP8266WiFi.h>
#include <WiFiClient.h> 
#include <ESP8266WebServer.h>
#include <EEPROM.h>
#include <OneWire.h>
OneWire  ds(14);  // DS18B20 data line a 4.7K resistor to 3.3V is necessary
int button=12; // have attached a button on GPIO to GND to enter AP mode on boot 
int led = 13; // have attached led to GPI0 to give feedback for user
String ssid, pass, feed, channel, key, sleep, st, content, line; // credentials and website string
long sleepTime;
ESP8266WebServer server(80);
WiFiClient client;


void setup() {
  pinMode(button, INPUT_PULLUP);  pinMode(led, OUTPUT);
  EEPROM.begin(512); Serial.begin(115200); Serial.println();

 
  

  if (digitalRead(button)==1){  // normal operation: wi-fi client, measure temperature, upload and sleep

  float value = ReadTemperature();

      ReadEEPROM();
      WiFi.begin(ssid.c_str(), pass.c_str()); 
  int c = 0;
  while ( c < 30 ) {  // give 15 seconds to connect, if no success deepsleep
    if (WiFi.status() == WL_CONNECTED)  break; 
    delay(500);  Serial.print(".");  c++;
  }
  
  if (WiFi.status() != WL_CONNECTED){ Serial.print(" \r\n Could not connect. Sleeping... \r\n");
    digitalWrite(led, HIGH); delay(1000); // blink led longer indicating error
    ESP.deepSleep(sleepTime, WAKE_RF_DEFAULT); delay(1000); //do nothing untill fall in sleep
  }
  
Serial.print("  \r\n WiFi connected IP address: "); Serial.println(WiFi.localIP()); 


  if (client.connect("api.xively.com", 80)) {  // "api.xively.com" ; Thingspeak:  "184.106.153.149" or "api.thingspeak.com"
    String postStr = "{\"version\":\"1.0.0\", \"datastreams\": [{\"id\": \""+channel+"\", \"current_value\": \"";
           postStr += String(value);
           postStr += "\"}]}\n";
      
     client.print("PUT /v2/feeds/"+feed+" HTTP/1.1\r\n"); 
     client.print("Host: api.xively.com\r\n"); 
     client.print("Content-Type: application/json\r\n"); 
     client.print("Content-Length: "); 
     client.print(postStr.length()); 
     client.print("\r\nX-ApiKey: ");
     client.print(key); 
     client.print("\r\n\r\n"); 
     client.print(postStr);

     Serial.print("PUT /v2/feeds/"+feed+" HTTP/1.1\r\n"); 
     Serial.print("Host: api.xively.com\r\n"); 
     Serial.print("Content-Type: application/json\r\n"); 
     Serial.print("Content-Length: "); 
     Serial.print(postStr.length()); 
     Serial.print("\r\nX-ApiKey: ");
     Serial.print(key); 
     Serial.print("\r\n\r\n"); 
     Serial.println (postStr);
     
  }
    delay(500);  line=""; while(client.available()){line += client.readStringUntil('\r'); } // wait a bit and read reply from server
    client.stop();
    Serial.println(line);
    if (line.substring(9,12) == "200") { Serial.println(" server responded 200 OK ..."); 
      digitalWrite(led, HIGH); delay(100);digitalWrite(led, LOW); delay(100);} //blink led a couple of times shortly 
    else  {Serial.println(" server gave 404 error ..."); digitalWrite(led, HIGH); delay(1000);} //blink led longer
  
  Serial.println(" \r\n sleeping..."); ESP.deepSleep(sleepTime, WAKE_RF_DEFAULT); delay(1000); //do nothing untill fall in sleep  
  
  } // end of part when button was not pressed
  
  
 



 
if (digitalRead(button)==0){  // Enter configuration AP mode if the button is pressed
  for (int i = 0; i < 10; ++i) { digitalWrite(led, LOW); delay(100);digitalWrite(led, HIGH); delay(100);} // blink LED and leave it on to see that we are in AP mode

  
	int n = WiFi.scanNetworks();  st = "<ol>";   // Scan networks around and collect SSID and RSSI for each network found
  for (int i = 0; i < n; ++i)
    {st += "<li>";  st += WiFi.SSID(i);  st += " (";  st += WiFi.RSSI(i);  st += ")"; st += (WiFi.encryptionType(i) == ENC_TYPE_NONE)?" ":"*";  st += "</li>";
    } st += "</ol>";
	
	
	Serial.print("Configuring access point..."); WiFi.softAP("ESP8266"); // Remove password parameter if you want the AP to be open
	IPAddress myIP = WiFi.softAPIP();  Serial.print("AP IP address: "); Serial.println(myIP);

  server.on("/", []() {
        content = "<!DOCTYPE HTML>\r\n<html><B><body>ESP8266 Wi-Fi + DS18B20 thermometer, upload to Xively and deepsleep</B><br><HR>";
        float value = ReadTemperature();
        ReadEEPROM();
        String volts=String(analogRead(A0)/10);
        content += "<B>Temperature: <FONT color=red>"+String(value)+" </font>degrees C. Battery voltage: "+volts+ " V. <br><hr>";
        content += "<B><font color=blue>Connect to a local access point:</B></font><br>";
        content += "<form method='get' action='ssid'><label>SSID: </label><input name='ssid' length=32 value='"+ssid+"'> <input type='submit'></form><BR>";
        content += "<form method='get' action='pass'><label>Password: </label><input name='pass' length=32 value='"+pass+"'> <input type='submit'></form><BR><hr>";
        content += "<B><font color=blue>Upload to Xively details:</B></font><br>";
        content += "<form method='get' action='feed'><label>Feed nr: </label><input name='feed' length=32 value='"+feed+"'> <input type='submit'></form><BR>";
        content += "<form method='get' action='channel'><label>Channel name: </label><input name='channel' length=32 value='"+channel+"'> <input type='submit'></form><BR>";
        content += "<form method='get' action='key'><label>API key: </label><input name='key' length=64 value='"+key+"'> <input type='submit'></form><BR>";
        content += "<form method='get' action='sleep'><label>Sleep seconds: </label><input name='sleep' length=32 value='"+sleep+"'> <input type='submit'></form><BR>";
        content += "<hr><font color=green><form method='get' action='reset'><label>Reset into wi-fi client mode: </label> </font><input type='submit'></form>";
        content += "<HR><font size=-1>Configuration via a webpage. If a button at GPIO12 is pressed on boot, led on GPIO2 blinks and access point ESP8266 is created.<br>";
        content += "Connect to it and browse http://192.168.4.1 to enter credentials that will be stored in flash. Reboot manually by power switch.<br>";
        content += "During normal operation led blinks briefly after upload to Xively and then board sleeps specified number of seconds. <hr>";
        content += "Networks found: <BR>" +st+"<hr></body></html>";
        server.send(200, "text/html", content);  });
 
  server.on("/ssid", []() {String data = server.arg("ssid");  int d=0;
          for (int i = 0; i < 32; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
          for (int i = 0; i < data.length(); ++i){ if (data[i]==43) data[i]=32; } // SSID consisting of several words are passed with spaces marked as "+"
          for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit();   server.send(200, "text/html", "Saved SSID name to eeprom...\"}");   });

  server.on("/pass", []() {String data = server.arg("pass");  int d=32;
         for (int i = 0; i < 32; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
         for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit(); server.send(200, "text/html", "Saved wi-fi password to eeprom...\"}");   });

  server.on("/feed", []() {String data = server.arg("feed");  int d=64;
          for (int i = 0; i < 32; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
          for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit(); server.send(200, "text/html", "Saved feed name to eeprom...\"}");    });

  server.on("/channel", []() {String data = server.arg("channel");  int d=96;
          for (int i = 0; i < 32; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
          for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit();  server.send(200, "text/html", "Saved channel name to eeprom...\"}");   });

  server.on("/key", []() {String data = server.arg("key");  int d=128;
          for (int i = 0; i < 64; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
          for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit();  server.send(200, "text/html", "Saved API key to eeprom...");   });

  server.on("/sleep", []() {String data = server.arg("sleep");  int d=192;
          for (int i = 0; i < 32; ++i) { EEPROM.write(d+i, 0); }  //clearing eeprom
          for (int i = 0; i < data.length(); ++i){ EEPROM.write(d+i, data[i]); Serial.print(data[i]);}
          EEPROM.commit();  server.send(200, "text/html", "Saved sleep time to eeprom...");   });

server.on("/reset", []() {server.send(200, "text/html", "resetting into wi-fi client mode...");ESP.deepSleep(100000, WAKE_RF_DEFAULT);   });

	server.begin();  Serial.println("HTTP server started");
 }
}



void loop() {
	server.handleClient();
}


void ReadEEPROM(){

  ssid="";
  for (int i = 0; i < 32; ++i)  {if (EEPROM.read(i)==0) break;ssid += char(EEPROM.read(i));}
  Serial.print("ssid: "); Serial.println(ssid);

  pass="";
  for (int i = 32; i < 64; ++i)  {if (EEPROM.read(i)==0) break; pass += char(EEPROM.read(i));}
  Serial.print("pass: "); Serial.println(pass);  

  feed="";
  for (int i = 64; i < 96; ++i)  {if (EEPROM.read(i)==0) break; feed += char(EEPROM.read(i));}
  Serial.print("feed: "); Serial.println(feed);

  channel="";
  for (int i = 96; i < 128; ++i)  {if (EEPROM.read(i)==0) break; channel += char(EEPROM.read(i));}
  Serial.print("channel: "); Serial.println(channel);
  
  key="";
  for (int i = 128; i < 192; ++i)  {if (EEPROM.read(i)==0) break; key += char(EEPROM.read(i));}
  Serial.print("APIkey: "); Serial.println(key);

  sleep="";
  for (int i = 192; i < 224; ++i)  {if (EEPROM.read(i)==0) break; sleep += char(EEPROM.read(i));}
  Serial.print("sleep time s: "); Serial.println(sleep);
  sleepTime=sleep.toInt()*1000000; // convert from seconds to microseconds 
}





float ReadTemperature(void){
  byte i, present = 0, type_s, data[12], addr[8]; float celsius; ds.reset_search(); ds.search(addr);
    
  if (OneWire::crc8(addr, 7) != addr[7]) {Serial.println("CRC is not valid!"); return(0.00);}
  
  switch (addr[0]) {   // the first ROM byte indicates which chip
    case 0x10: Serial.println("  Chip = DS18S20");  type_s = 1; break;
    case 0x28: Serial.println("  Chip = DS18B20"); type_s = 0; break;
    case 0x22: Serial.println("  Chip = DS1822");  type_s = 0; break;
    default: Serial.println("Device is not a DS18x20 family device."); return(0.00);
  } 
  ds.reset(); ds.select(addr); ds.write(0x44, 1);   // start conversion, with parasite power
  delay(750);     // maybe 750ms is enough
  present = ds.reset(); ds.select(addr); ds.write(0xBE);   // Read Scratchpad

  Serial.print("  Data = "); Serial.print(present, HEX); Serial.print(" ");
  for ( i = 0; i < 9; i++) {           // we need 9 bytes
    data[i] = ds.read(); Serial.print(data[i], HEX); Serial.print(" ");
  }
  
  int16_t raw = (data[1] << 8) | data[0];
  if (type_s) {   raw = raw << 3; // 9 bit resolution default
    if (data[7] == 0x10) { // "count remain" gives full 12 bit resolution
      raw = (raw & 0xFFF0) + 12 - data[6];
    }
  } else {byte cfg = (data[4] & 0x60);
    // at lower res, the low bits are undefined, so let's zero them
    if (cfg == 0x00) raw = raw & ~7;  // 9 bit resolution, 93.75 ms
    else if (cfg == 0x20) raw = raw & ~3; // 10 bit res, 187.5 ms
    else if (cfg == 0x40) raw = raw & ~1; // 11 bit res, 375 ms
  }
  celsius = (float)raw / 16.0; Serial.print("  T = "); Serial.println(celsius); return (celsius);
}
