// Create a WiFi access point and provide a web server on it.
// Go to http://192.168.4.1 in a web browser connected to this access point to see it.
// Control LED connected to  GPIO2

#include <ESP8266WiFi.h>
#include <WiFiClient.h> 
#include <ESP8266WebServer.h>

#define GPIO    2    // Digital IO pin connected to the LED. ESP GPIO2


// Set these to your desired AP credentials.
const char *ssid = "ESP8266";
//const char *password = "thereisnospoon";

ESP8266WebServer server(80);

void setup() {

  pinMode(GPIO, OUTPUT);

	delay(1000);
	Serial.begin(115200);
	Serial.println();
	Serial.print("Configuring access point...");
	WiFi.softAP(ssid); // Remove password parameter if you want the AP to be open

	IPAddress myIP = WiFi.softAPIP();
	Serial.print("AP IP address: ");
	Serial.println(myIP);

server.on("/", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<FONT SIZE=+4> ESP8266 Wi-Fi webserver<BR> LED on GPIO2 control<HR><BR> <B><A href=on> ON </A> &nbsp; &nbsp; <A href=off> OFF </A></font>";
    server.send(200, "text/html", webString);            // send to someones browser when asked
  });

server.on("/on", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"1; url=http://192.168.4.1\"/></head> <body><H1> ON </H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
digitalWrite(GPIO, HIGH); 
  });

server.on("/off", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"1; url=http://192.168.4.1\"/></head> <body><H1> OFF </H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
digitalWrite(GPIO, LOW); 
  });

  
	server.begin();
	Serial.println("HTTP server started");
}

void loop() {
	server.handleClient();
}

