/* Arduino 3D printed Digital Thermometer
   using nokia 5110 screen and DHT-22 sensor
   Ver. 1.0 / Date:21/5/2017 */

//Include libraries
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>      //for graphics
#include <Adafruit_PCD8544.h>  //for Nokia 5110 lcd 
#include <dht.h>
dht DHT;
//Constants
#define DHT22_PIN 10     // DHT 22  (AM2302) - what pin we're connected to



//Init Display (SCLK, DIN, D/C, CS, RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(7, 6, 5, 4, 3);

//Variables
int hum;  //Stores humidity value
int temp; //Stores temperature value
int maxTemp=0;
int minTemp=100;
int maxHum=00;
int minHum=100;

void setup() {

  Wire.begin();
  display.begin();
  display.setContrast(45);
  //Print a welcome message in startup for 6sec.//////////
  display.clearDisplay();   // clears the screen and buffer
  display.setTextColor(BLACK);
  display.setCursor(0,2);
  display.print("  ARDUMOTIVE  ");
  display.setCursor(0,13);
  display.print(" ArduinoBased ");
  display.setCursor(0,23);
  display.print("    Digital   ");
  display.setCursor(0,33);
  display.print("  Thermometer ");  
  display.display(); // show splashscreen
  delay(3000);
  /////////////////////////////////////////////////////////
  display.clearDisplay();   // clears the screen and buffer
}

void loop() {
  
  int chk = DHT.read22(DHT22_PIN);
  //Read data and store it to variables hum and temp
  hum = DHT.humidity;
  temp= DHT.temperature;

  if (temp>maxTemp){
    maxTemp=temp;
  }
  if (temp<minTemp){
    minTemp=temp;
  }
  if (hum>maxHum){
    if (hum==100){
      maxHum=99;
    }
    else{
      maxHum=hum; 
    }
  }
  if (hum<minHum){
    if (hum==100){
     minHum=99; 
    }
    else{
      minHum=hum;
    }
  }
  
  display.clearDisplay();   // clears the screen and buffer
  display.setCursor(0,0);
  display.setTextSize(1);
  display.println("   HUMIDITY  ");
  display.println("-------------");
  display.print("MAX ");
  display.print(maxHum);
  display.print(" MIN ");
  display.println(minHum);
  display.print("   ");
  display.setTextSize(3);
  display.print(hum);
  display.setTextSize(2);
  display.print("%");  
  display.display();
  
  delay(5000);
  display.clearDisplay();   // clears the screen and buffer
  display.setCursor(0,0);
   display.setTextSize(1);
  display.println(" TEMPERATURE ");
  display.println("-------------");
  display.print("MAX ");
  display.print(maxTemp);
  display.print(" MIN ");
  display.println(minTemp);
  display.print("  ");
  display.setTextSize(3);
  display.print(temp);
  display.setTextSize(2);
  display.print("oC");  
  display.display();
  delay(5000);
}

