/* This is the code for the Arduino Leonardo, it will not work on the Uno. */

/* These are constants: If you want to change the number of analog inputs, you can simply do it once on this line, instead of changing it everywhere in your code.*/
#define NUMBER_OF_ANALOG_INPUTS  12 // The Leonardo has 12 analog inputs, we'll use all of them in this example. If you only need 6, change this to 6, and you'll be able to use A6 to A11 as normal I/O pins.

#define CHANNEL  1 //Send all messages on channel 1

/* The list with the corresponding controller numbers: for example, the values of the potentiometer on A0 will be sent as the first controller number in this list, A1 as the second, etc... 
 Here's the list with all controller numbers:  http://midi.org/techspecs/midimessages.php#3  You can change them if you want.*/
int controllers[NUMBER_OF_ANALOG_INPUTS] = { 
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B
};  

int analogVal[NUMBER_OF_ANALOG_INPUTS];  // We declare an array for the values from the analog inputs

int analogOld[NUMBER_OF_ANALOG_INPUTS]; // We declare an array for the previous analog values. 

void setup() {
  for(int i = 0; i < NUMBER_OF_ANALOG_INPUTS; i++){  // We make the values of analogOld -1, so it will always be different from any possible analog reading.
    analogOld[i]=-1;
  }
  delay(1000);  // Wait 1 second before sending messages, to be sure everything is set up, and to make uploading new sketches easier.
}

void loop() {
  for(int i = 0; i < NUMBER_OF_ANALOG_INPUTS; i++){                         // Repeat this procedure for every analog input.
    analogVal[i] = analogRead(i+A0)/8;                                       // The resolution of the Arduino's ADC is 10 bit, and the MIDI message has only 7 bits, 10 - 7 = 3, so we divide by 2^3, or 8.
    if(analogVal[i] != analogOld[i]){                                     // Only send the value, if it is a different value than last time.
      usbMIDI.sendControlChange(controllers[i], analogVal[i], CHANNEL);   
      /* Send the MIDI control change message: choose the i'th controller in the array above, get the right value from the analogVal array, on the predefined channel.
      NOTE: the compiler will not recognize this command if you don't have TeeOnArdu installed, if the board type is not TeeOnArdu, or if the USB type is not set to MIDI.*/
      analogOld[i] = analogVal[i];                                        // Put the analog values in the array for old analog values, so we can compare the new values with the previous ones.
    }
  }

}
