#define F_CPU 1000000

#include <avr/io.h>
#include <util/delay.h>

void PWM() //Set up PWM
{

  GTCCR = 0b00000000;
  TCCR0A = 0b10000001;
  TCCR0B = 0b00000001;
  OCR0A = 0xFF;

  TCCR1 = 0b01010111;
  GTCCR = 0b01010000;
  OCR1B = 0x00;
  OCR1A = 0xFF;
}

#define blue OCR1B  //Connect the blue pin on the led to pin 3
#define green OCR0A  //Connect the green pin to pin 5
#define red OCR1A  //Connect the red pin to pin 6

void initADC() //Set up the ADC (analog to digital converter)
{
  ADMUX = 0b00100011;
  ADCSRA = 0b11000111;
  ADCSRB = 0x00;
}

char bright()   // Gets a value from the phototransistor that's hooked up to pin 2
{
  int adc;
  ADCSRA = 0b11000111;
  while(bit_is_clear(ADCSRA, ADIF));
  adc = ADCH;
  return (255 - adc);
}

int main()
{
  blue = 255;
  green = 0;
  red = 0;
  char y = 50; //This controls speed
  char c = 1;
  DDRB = 0b00110111;
  int x = 0;
  int loop = 0;  //Used to switch between off and on while loops
  int level = 5;  // Amount of light needed to turn it on
  PWM(); //This initiates PWM
  initADC();
  while(1)
    {
      while(loop == 0)
	{
	  if(blue < 255)
	    blue++;
	  if(green < 255)
	    green++;
	  if(red < 255)
	    red++;
	  _delay_ms((y)/2);
	  c = 0;
	  x = 0;
	  if(bright() <= level)
	    loop = 1;
	}
      while(loop == 1)
	{
	  while(c == 0)
	    {
	      x++;
	      blue = ~x;
	      _delay_ms((y)/2);
	      if(bright() > level)
		c = 5;
	      if(x == 255)
		{
		  c++;
		  x = 0;
		}
	    }
	  while(c == 1) //Blue to red
	    {
	      x++;
	      blue =  x;
	      red = ~x;
	      _delay_ms(y);
	      if(bright() > level)
		c = 5;
	      if(x == 255)
		c++;
	    }
	  while(c == 2) //Red to green
	    {
	      x--;
	      red = ~x;
	      green = x;
	      _delay_ms(y);
	      if(bright() > level)
		c = 5;
	      if(x == 0)
		c++;
	    }
	  while(c == 3) //Green to blue 
	    {
	      x++;
	      green = x;
	      blue = ~x;
	      _delay_ms(y);
	      if(bright() > level)
		c = 5;
	      if(x == 255)
		c++;
	    }
	  while(c == 4) //Restart code
	    {
	      x = 0;
	      c = 1;
	      }
	  if(c == 5)  //Gets us to the fade off step
	    loop = 0;
	}
    }
}
