/*
       A Digital meassuring tape with PIC16F819
       made from an old mouse and an old watch
                By Mohammad Yousefi
                  December 2010
              vahid_you2004@yahoo.com
                  www.dihav.com
*/

#define Sensor1 PORTA.B4
#define Sensor2 PORTB.B0
#define RButton PORTA.B2
#define UButton PORTA.B1
#define SS1 PORTA.B0
#define SS2 PORTA.B7
#define SS3 PORTA.B6
#define SSA PORTB.B1
#define SSB PORTB.B2
#define SSC PORTB.B3
#define SSD PORTB.B4
#define SSE PORTB.B5
#define SSF PORTB.B6
#define SSG PORTB.B7

#define CorrectROMValue 197
#define DigitChangeCycle 100
#define MaxOneMeterTicks 2000

signed long int Ticks = 0;
unsigned int OneMeterTicks = 700;

void interrupt(void)
{
  if (INTCON.INTF)
  {
    if (Sensor1)
    {
      if (RButton)
      {
        if (OneMeterTicks == MaxOneMeterTicks) OneMeterTicks = 0;
        OneMeterTicks++;
      }
     else
       Ticks++;
    }
    else
    {
      if (RButton)
      {
        OneMeterTicks--;
        if (OneMeterTicks == 0) OneMeterTicks = MaxOneMeterTicks;
      }
     else
       Ticks--;
    }
    if (abs(Ticks) >= OneMeterTicks * 10) Ticks = 0;
    INTCON.INTF = 0;
  }
}

void main()
{
  unsigned int LOneMeterTicks;
  unsigned short int Cycle = 0;
  bit LRButton;
  unsigned long int n;
  unsigned short int DigitIndex = 0;
  unsigned short int Digit[3];
  unsigned short int dig;

  OSCCON = 0b01110000;
  ADCON1 = 0b0000110;
  OPTION_REG = 0b11010000;
  PORTA = 0;
  PORTB = 255;
  TRISA = 0b00010110;
  TRISB = 0b00000001;
  INTCON = 0b10010000;
  LRButton = 0;
  if (EEPROM_Read(0) == CorrectROMValue)
  {
    unsigned short int k;
    OneMeterTicks = EEPROM_Read(1);
    k = EEPROM_Read(2);
    OneMeterTicks = (OneMeterTicks << 8) + k;
  }
  LOneMeterTicks = OneMeterTicks;
  while (1)
  {
    if ((!RButton) && LRButton)
    {
      Ticks = 0;
      if (OneMeterTicks != LOneMeterTicks)
      {
        EEPROM_Write(0, CorrectROMValue);
        EEPROM_Write(1, (unsigned short)(OneMeterTicks >> 8));
        EEPROM_Write(2, (unsigned short)OneMeterTicks);
        LOneMeterTicks = OneMeterTicks;
      }
    }
    LRButton = RButton;
    Cycle++;
    if (Cycle == DigitChangeCycle)
    {
      SS1 = 0;
      SS2 = 0;
      SS3 = 0;
      if (Ticks < 0)
        n = -Ticks;
      else
        n = Ticks;
      n *= 100;
      if (UButton == 1)
        n /= (unsigned long int)(OneMeterTicks * 2.54);
      else
        n /= (unsigned long int)OneMeterTicks;
      Digit[2] = n / 100;
      n = n % 100;
      Digit[1] = n / 10;
      Digit[0] = n % 10;
      dig = Digit[DigitIndex];
      SSA = ((dig == 1) || (dig == 4));
      SSB = ((dig == 5) || (dig == 6));
      SSC = (dig == 2);
      SSD = ((dig == 1) || (dig == 4) || (dig == 7));
      SSE = ((dig != 0) && (dig != 2) && (dig != 6) && (dig != 8));
      SSF = ((dig == 1) || (dig == 2) || (dig == 3));
      SSG = ((dig == 0) || (dig == 1) || (dig == 7));
      if (DigitIndex == 0) SS1 = 1;
      if (DigitIndex == 1) SS2 = 1;
      if (DigitIndex == 2) SS3 = 1;
      Cycle = 0;
      DigitIndex++;
      if (DigitIndex == 3) DigitIndex = 0;
      if ((DigitIndex == 2) && (Digit[2] == 0)) DigitIndex = 0;
      if ((DigitIndex == 1) && (Digit[2] == 0) && (Digit[1] == 0)) DigitIndex = 0;
    }
  }
}
