/************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


	For use with a 24 Channel High Current LED Controller and a DMX to Serial Adapter
	from Chromation Systems

	Find information and updates at www.ChromationSystems.com/24chan.html
	
	Connect Transmit pin from DMX to Serial adpater to RX on 24 channel
	And SendIO from DMX to Serial adapter to TX on the
*/

#include "HardwareProfile - ChromSys24ChanUSB.h"
#include <timers.h> //Interrupt Timers
#include <p18f4550.h>

	#define bsf(var,bitno) (var|=1<<bitno)
	#define bcf(var,bitno) (var&=~(1<<bitno)) 


//**VARIABLES***********************************

typedef union tag8FLAGS { 
    unsigned char asByte;        // allows access to the full 8 bits 
    struct tag8BITS { 
  unsigned b0:1;    
  unsigned b1:1;    
  unsigned b2:1;    
  unsigned b3:1;
  unsigned b4:1;  
  unsigned b5:1;    
  unsigned b6:1;
  unsigned b7:1;
    }; 
} T8_FLAGS; 

#pragma udata sect0

T8_FLAGS Flags;


unsigned char PWMPeriod;

unsigned char MonoVal[25];
unsigned char MonoHoldVal[25];
unsigned char BufferCount;
unsigned char TimeOut;

int x;
unsigned char i;
unsigned char c;

unsigned char ResponseTimeOut;

 	unsigned char SerialByte;

#define WaitingForBytes Flags.b0
#define RequestFlag Flags.b1
#define SendRequest Flags.b2

#define RequestPin LATAbits.LATA2



    #define mDataRdyUSART() PIR1bits.RCIF
    #define mTxRdyUSART()   TXSTAbits.TRMT


//**PROTOTYPES***********************************

void YourHighPriorityISRCode();
void YourLowPriorityISRCode(); 
unsigned char BitCheck(unsigned char var,unsigned char bitno);
void UserInit(void);
void set_timer(void);
void delay (int p);

void putcUSARTm(char c) ;
unsigned char getcUSARTm();


/** VECTOR REMAPPING ***********************************************/

	//On PIC18 devices, addresses 0x00, 0x08, and 0x18 are used for
	//the reset, high priority interrupt, and low priority interrupt
	//vectors.  However, the current Microchip USB bootloader 
	//examples are intended to occupy addresses 0x00-0x7FF or
	//0x00-0xFFF depending on which bootloader is used.  Therefore,
	//the bootloader code remaps these vectors to new locations
	//as indicated below.  This remapping is only necessary if you
	//wish to program the hex file generated from this project with
	//the USB bootloader.  If no bootloader is used, edit the
	//usb_config.h file and comment out the following defines:
	#define PROGRAMMABLE_WITH_USB_HID_BOOTLOADER
	//#define PROGRAMMABLE_WITH_USB_LEGACY_CUSTOM_CLASS_BOOTLOADER
	
	#if defined(PROGRAMMABLE_WITH_USB_HID_BOOTLOADER)
		#define REMAPPED_RESET_VECTOR_ADDRESS			0x1000
		#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x1008
		#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x1018
	#elif defined(PROGRAMMABLE_WITH_USB_MCHPUSB_BOOTLOADER)	
		#define REMAPPED_RESET_VECTOR_ADDRESS			0x800
		#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x808
		#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x818
	#else	
		#define REMAPPED_RESET_VECTOR_ADDRESS			0x00
		#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x08
		#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x18
	#endif
	
	#if defined(PROGRAMMABLE_WITH_USB_HID_BOOTLOADER)||defined(PROGRAMMABLE_WITH_USB_MCHPUSB_BOOTLOADER)
	extern void _startup (void);        // See c018i.c in your C18 compiler dir
	#pragma code REMAPPED_RESET_VECTOR = REMAPPED_RESET_VECTOR_ADDRESS
	void _reset (void)
	{
	    _asm goto _startup _endasm
	}
	#endif
	
	
	#pragma code REMAPPED_HIGH_INTERRUPT_VECTOR = REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS
	void Remapped_High_ISR (void)
	{
	     _asm goto YourHighPriorityISRCode _endasm
	}
	#pragma code REMAPPED_LOW_INTERRUPT_VECTOR = REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS
	void Remapped_Low_ISR (void)
	{
	     _asm goto YourLowPriorityISRCode _endasm
	}
	
	#if defined(PROGRAMMABLE_WITH_USB_HID_BOOTLOADER)||defined(PROGRAMMABLE_WITH_USB_MCHPUSB_BOOTLOADER)
	//Note: If this project is built while one of the bootloaders has
	//been defined, but then the output hex file is not programmed with
	//the bootloader, addresses 0x08 and 0x18 would end up programmed with 0xFFFF.
	//As a result, if an actual interrupt was enabled and occured, the PC would jump
	//to 0x08 (or 0x18) and would begin executing "0xFFFF" (unprogrammed space).  This
	//executes as nop instructions, but the PC would eventually reach the REMAPPED_RESET_VECTOR_ADDRESS
	//(0x1000 or 0x800, depending upon bootloader), and would execute the "goto _startup".  This
	//would effective reset the application.
	
	//To fix this situation, we should always deliberately place a 
	//"goto REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS" at address 0x08, and a
	//"goto REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS" at address 0x18.  When the output
	//hex file of this project is programmed with the bootloader, these sections do not
	//get bootloaded (as they overlap the bootloader space).  If the output hex file is not
	//programmed using the bootloader, then the below goto instructions do get programmed,
	//and the hex file still works like normal.  The below section is only required to fix this
	//scenario.
	#pragma code HIGH_INTERRUPT_VECTOR = 0x08
	void High_ISR (void)
	{
	     _asm goto REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS _endasm
	}
	#pragma code LOW_INTERRUPT_VECTOR = 0x18
	void Low_ISR (void)
	{
	     _asm goto REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS _endasm
	}
	#endif	//end of "#if defined(PROGRAMMABLE_WITH_USB_HID_BOOTLOADER)||defined(PROGRAMMABLE_WITH_USB_LEGACY_CUSTOM_CLASS_BOOTLOADER)"

	#pragma code

	
	//These are your actual interrupt handling routines.
#pragma interrupt YourHighPriorityISRCode

void YourHighPriorityISRCode()
	{
		//Check which interrupt flag caused the interrupt.
		//Service the interrupt
		//Clear the interrupt flag
		//Etc.

		PIR1bits.RCIF=0;
		INTCONbits.GIEH = 0;
		INTCONbits.GIEL = 0;
		}	//This return will be a "retfie fast", since this is in a #pragma interrupt section 




#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
	{
//software PWM sequence for all 24 channels		
	PWMPeriod++;
	
	if(PWMPeriod != 255)
	{
	
	if(MonoVal[24]>0) {
	MonoVal[24]--;
	T24=1;
	}
	else {
	T24=0;
	}	

	if(MonoVal[23]>0)
	{
	MonoVal[23]--;
	T23=1;
	}
	else {
	T23=0;
	}
	
	if(MonoVal[22]>0)
	{
	MonoVal[22]--;
	T22=1;
	}
	else {
	T22=0;
	}

	if(MonoVal[21]>0) {
	MonoVal[21]--;
	T21=1;
	}
	else {
	T21=0;
	}	
	
	if(MonoVal[20]>0)
	{
	MonoVal[20]--;
	T20=1;
	}
	else {
	T20=0;
	}	

	if(MonoVal[19]>0)
	{
	MonoVal[19]--;
	T19=1;
	}
	else {
	T19=0;
	}

	if(MonoVal[18]>0) {
	MonoVal[18]--;
	T18=1;
	}
	else {
	T18=0;
	}
	
	if(MonoVal[17]>0)
	{
	MonoVal[17]--;
	T17=1;
	}
	else {
	T17=0;
	}	

	if(MonoVal[16]>0)
	{
	MonoVal[16]--;
	T16=1;
	}
	else {
	T16=0;
	}

	if(MonoVal[15]>0) {
	MonoVal[15]--;
	T15=1;
	}
	else {
	T15=0;
	}

	if(MonoVal[14]>0)
	{
	MonoVal[14]--;
	T14=1;
	}
	else {
	T14=0;
	}

	if(MonoVal[13]>0)
	{
	MonoVal[13]--;
	T13=1;
	}
	else {
	T13=0;
	}
	
	if(MonoVal[12]>0) {
	MonoVal[12]--;
	T12=1;
	}
	else {
	T12=0;
	}
	
	if(MonoVal[11]>0)
	{
	MonoVal[11]--;
	T11=1;
	}
	else {
	T11=0;
	}		
	
	if(MonoVal[10]>0)
	{
	MonoVal[10]--;
	T10=1;
	}
	else {
	T10=0;
	}	
	
	if(MonoVal[9]>0) {
	MonoVal[9]--;
	T9=1;
	}
	else {
	T9=0;
	}
	
	if(MonoVal[8]>0)
	{
	MonoVal[8]--;
	T8=1;
	}
	else {
	T8=0;
	}		
	
	if(MonoVal[7]>0)
	{
	MonoVal[7]--;
	T7=1;
	}
	else {
	T7=0;
	}

	if(MonoVal[6]>0) {
	MonoVal[6]--;
	T6=1;
	}
	else {
	T6=0;
	}
	

	if(MonoVal[5]>0)
	{
	MonoVal[5]--;
	T5=1;
	}
	else {
	T5=0;
	}
	
	if(MonoVal[4]>0)
	{
	MonoVal[4]--;
	T4=1;
	}
	else {
	T4=0;
	}

	if(MonoVal[3]>0) {
	MonoVal[3]--;
	T3=1;
	}
	else {
	T3=0;
	}	

	if(MonoVal[2]>0)
	{
	MonoVal[2]--;
	T2=1;
	}
	else {
	T2=0;
	}	
	
	if(MonoVal[1]>0)
	{
	MonoVal[1]--;
	T1=1;
	}
	else {
	T1=0;
	}	
}
else {
	PWMPeriod=0;

//resets PWM variables, MonoVal[0] is not used, MonoVal[1] goes to Channel 1 ect.
	for(x=0;x != 25;x++)
	{
	MonoVal[x] = MonoHoldVal[x] ;
	}

	//In case the request was ignored or not received, this will resend it after a timeout
	ResponseTimeOut++;
	if(ResponseTimeOut>=20)
	{
	ResponseTimeOut=0;
	SendRequest=1;
	RequestFlag=0;
	}	
		

	if(RequestFlag==0) //if not waiting for data
	{
	TimeOut++;
	
	if(TimeOut >= 1 ) //requests data packets fast as it can
	{
	ResponseTimeOut=0;	
	RequestFlag=1;
	SendRequest=1;
	}
	}
} //end else
	INTCONbits.TMR0IF=0;
	TMR2=0;
	PIR1bits.TMR2IF=0;
	}	//This return will be a "retfie", since this is in a #pragma interruptlow section 



/** DECLARATIONS ***************************************************/
#pragma code

void MainLoop(void)
{

if(SendRequest==1)
{
	//using any GEN I/O could work
/*
	RequestPin =0;	
	Nop();
	Nop();
	Nop();
	Nop();
	RequestPin = 1;
*/
	//TX and RX are easily excessible on the 24 channel controller, sending 255 works well enough to
	//signal a DMX packet rquest.
	putcUSARTm(255); //can't control TX while CREN is set, so this works the same just need a quick pulse

	SerialByte=getcUSARTm(); //flush RCREG
	Nop();
	SerialByte=getcUSARTm();
		
	SendRequest=0;
	BufferCount=1;
}	




	if(mDataRdyUSART() && RequestFlag==1)
	{					
	SerialByte=getcUSARTm(); //get recieved byte
	
	MonoHoldVal[BufferCount]=SerialByte;	//put it into the Hold array
	
	BufferCount++;
	if(BufferCount>=25) //would be 24 but Mono arrays start at [1] for channel 1
	{			
	BufferCount=1;
	RequestFlag=0;
	}
	}	
	else if(mDataRdyUSART() && RequestFlag==0)
	{
	SerialByte=getcUSARTm(); //dump unwanted byte
	}

	_asm
	goto MainLoop
	_endasm  
}//end main
	


void delay (int p)
{
int y;
for (y = 0; y < p; y++);
}	


void main(void)
{   
	UserInit();

	for(x=0;x != 25;x++)
	{
		MonoHoldVal[x] = 255;
	}

	_asm
	goto MainLoop
	_endasm  
}//end main


unsigned char getcUSARTm()
{
	if (RCSTAbits.OERR)  // in case of overrun error
	{                    // we should never see an overrun error, but if we do, 
		RCSTAbits.CREN = 0;  // reset the port
		c = RCREG;
		RCSTAbits.CREN = 1;  // and keep going.
	}
	else
		c = RCREG;


	return c;
}


void putcUSARTm(char c)  
{
	    TXREG = c;
}


void UserInit(void)
	{
	Flags.asByte=0x00;

	ADCON0 = 0x00;
	ADCON1 = 0x0F; 
	ADCON2 = 0x00;
	CMCON=0x07;

	TRISA = 0x00;
	TRISB = 0x00;
	TRISC = 0x00;
	TRISD = 0x00;
	TRISE = 0x00;
	
	PORTA=0x00;
	PORTB=0x00;
	PORTC=0x00;
	LATA = 0x00;
	LATB = 0x00;
	LATC = 0x00;

	TRISCbits.RC7=1;
	TRISCbits.RC6=0;
		
	set_timer();		

	RequestPin=1;


//WORKS AT 19200 BAUD
/*
        TXSTA = 0x24;       	// TX enable BRGH=1
        RCSTA = 0x90;       	// Single Character RX
        SPBRG = 0x71; //should be 0x70?? according to calculator
        SPBRGH = 0x02;      	// 0x0271 for 48MHz -> 19200 baud
        BAUDCON = 0x08;     	// BRG16 = 1
        c = RCREG;				// read 
*/

//works for 57600
        TXSTA = 0b00100100;       	// TX disabled -  BRGH=1
        RCSTA = 0x90;       	// Single Character RX
        SPBRGH = 0x00;      
        SPBRG = 207;
        BAUDCON = 0x08;     	// BRG16 = 1
        c = RCREG;	

	TRISCbits.RC6=0;

	PIR1bits.CCP1IF=0; //clear CCP int
	PIR2bits.CCP2IF=0; //clear CCP int

	INTCONbits.PEIE = 1; // Enable Peripheral interrupt 
	INTCONbits.GIE = 1;	// Enble Global interrupt, REQUIRED FOR LOW PRIORITY

}//end UserInit


void set_timer(void)
{
	OpenTimer2( TIMER_INT_ON &T2_PS_1_1 & T2_POST_1_1 ); //was post 1:8
	PR2=20;//was 10

	PIR1bits.TMR2IF=0;

	RCONbits.IPEN=1;

       INTCONbits.GIEH =1; //enable High priority
	INTCONbits.GIEL = 1; //enable low priority
	INTCONbits.PEIE = 1; // Enable Peripheral interrupt 
	INTCONbits.GIE = 1;	// Enble Global interrupt, REQUIRED FOR LOW PRIORITY
	IPR1bits.TMR2IP = 0; //set TMR2 int priority, to LOW
}
