/* Color Changing Christmas Star

Controls an RGB LED Christmas Star  

On Instructables.com Qtechknow's Page

made by Quin (Qtechknow)

inspired by James Harton (https://gist.github.com/jamesotron)
*/

const int redPin = 10;
const int greenPin = 9;
const int bluePin = 11;

int value = 1;
 
void setup() {
  // Start off with the LED off.
  setColorRgb(0,0,0);
}
 
void loop() {
  int buttonValue = analogRead(0);
  
  if(buttonValue >= 1000 && value == 1) {
  unsigned int rgbColor[3];
 
  // Start off with red.
  rgbColor[0] = 255;
  rgbColor[1] = 0;
  rgbColor[2] = 0;  
 
  // Choose the colours to increment and decrement.
  for (int decColor = 0; decColor < 3; decColor += 1) {
    int incColor = decColor == 2 ? 0 : decColor + 1;
 
    // cross-fade the two colours.
    for(int i = 0; i < 255; i += 1) {
      rgbColor[decColor] -= 1;
      rgbColor[incColor] += 1;
      
      setColorRgb(rgbColor[0], rgbColor[1], rgbColor[2]);
      delay(10);
    }
    }
    value = 2;
  }
  if(buttonValue >= 1000 && value == 2) {
   setColorRgb(0, 0, 0);
   value = 1;
  }
}
 
void setColorRgb(unsigned int red, unsigned int green, unsigned int blue) {
  analogWrite(redPin, red);
  analogWrite(greenPin, green);
  analogWrite(bluePin, blue);
 }
