////////////////////////////////
/* CarPC Controller V1.1


06/09/2015 Allan Murray*/



//Define status modes

#define STATUS_POWER_OFF  0 
#define STATUS_ASLEEP     1
#define STATUS_COLD_BOOT  2
#define STATUS_BOOT       3
#define STATUS_ON         4
#define STATUS_SHUTDOWN   5
#define STATUS_UNKNOWN    6


//Define pins

#define IN_BUTTON_POWER  14
#define IN_BUTTON_P1     16
#define IN_BUTTON_P2     10
#define IN_BUTTON_P3     7
#define IN_BUTTON_P4     8
#define IN_BUTTON_P5     9
#define OUT_BUTTON_LED   15

#define IN_ACC_POWER     4
#define OUT_MASTER_POWER 5
#define OUT_AUX_POWER    6

#define IN_PIPO_LED      2
#define OUT_PIPO_BUTTON  3


#define BOOT_PRESS_TIME 3000//ms
#define SHUTDOWN_PRESS_TIME 600//ms

#define SHUTDOWN_TIMEOUT 180//s
#define SLEEP_TIMEOUT 14//hrs

#define BOOT_TIME 20//s
#define COLD_BOOT_TIME 30//s

int STATUS  = STATUS_POWER_OFF;
int LAST_STATUS = STATUS_UNKNOWN;

unsigned long time_current=0;
unsigned long time_last_loop=0;
unsigned long time_last_second=0;
unsigned long time_last_half_second=0;

unsigned long timer=0;
unsigned long timerwait=0;
unsigned long timerboot=0;

bool flash =false;
bool pipo_awake  =false;
bool acc_on    =false;
bool power_button =false;


void setup()
{
  pinMode(IN_BUTTON_P1 , INPUT);  
  digitalWrite(IN_BUTTON_P1 , HIGH);  
  pinMode(IN_BUTTON_P2 , INPUT);  
  digitalWrite(IN_BUTTON_P2 , HIGH);    
  pinMode(IN_BUTTON_P3 , INPUT);  
  digitalWrite(IN_BUTTON_P3 , HIGH);  
  pinMode(IN_BUTTON_P4 , INPUT);  
  digitalWrite(IN_BUTTON_P4 , HIGH);  
  pinMode(IN_BUTTON_P5 , INPUT);  
  digitalWrite(IN_BUTTON_P5 , HIGH);   
  pinMode(IN_BUTTON_POWER , INPUT);  
  digitalWrite(IN_BUTTON_POWER , HIGH);  
  pinMode(IN_ACC_POWER  , INPUT);  
  digitalWrite(IN_ACC_POWER , HIGH);   
  pinMode(IN_PIPO_LED , INPUT);  
  digitalWrite(IN_PIPO_LED , HIGH);    
  
  pinMode(OUT_BUTTON_LED  , OUTPUT);
  digitalWrite(OUT_BUTTON_LED , LOW);  

  pinMode(OUT_PIPO_BUTTON , OUTPUT);
  digitalWrite(OUT_PIPO_BUTTON , LOW); 
  
  pinMode(OUT_AUX_POWER, OUTPUT);  
  digitalWrite(OUT_AUX_POWER , LOW);   //aux off[
  pinMode(OUT_MASTER_POWER , OUTPUT);
 digitalWrite(OUT_MASTER_POWER , LOW); //master off
 
 
  digitalWrite(OUT_BUTTON_LED , HIGH);  
  delay(100);
  digitalWrite(OUT_BUTTON_LED , LOW);  
  
  delay(1000);
  
 
}


void loop()

{
  
  if (STATUS!=LAST_STATUS)  doStatusChange(); 
  time_current=millis();

  if ((time_current-time_last_loop)>100) { //EVERY 100ms
  
  acc_on=!digitalRead(IN_ACC_POWER);
  power_button = !digitalRead(IN_BUTTON_POWER);
  pipo_awake=!digitalRead(IN_PIPO_LED);
  
  if ((STATUS==STATUS_ASLEEP) && (acc_on)) timer=  SLEEP_TIMEOUT*(60*60);//hrs
  
  if ((STATUS==STATUS_ASLEEP) && (!acc_on) && (timer==0) && (power_button)) STATUS=STATUS_POWER_OFF; //sleep timout > power off

  
  if ((STATUS==STATUS_BOOT) || (STATUS==STATUS_SHUTDOWN)) digitalWrite(OUT_BUTTON_LED , flash);  
  else digitalWrite(OUT_BUTTON_LED , pipo_awake);  
  

   
  if ((STATUS==STATUS_SHUTDOWN) && (pipo_awake) && (timer==0)) STATUS=STATUS_POWER_OFF; //shutdown timout > power off
  
if ((STATUS==STATUS_BOOT) && (pipo_awake)) STATUS=STATUS_ON;

  if ((STATUS==STATUS_POWER_OFF) && (power_button) && (acc_on)&& (timerwait==0)) STATUS=STATUS_COLD_BOOT;
  if ((STATUS==STATUS_ASLEEP) && (power_button) && (acc_on)&& (timerwait==0)) STATUS=STATUS_BOOT;
  
  

  if ((STATUS==STATUS_SHUTDOWN) && (!pipo_awake)&& (timerwait==0)) STATUS=STATUS_ASLEEP;

 
  if ((STATUS==STATUS_ON) && (!power_button)&& (timerwait==0)) STATUS=STATUS_SHUTDOWN; 
  if ((STATUS==STATUS_ON) && (!acc_on)&& (timerwait==0)) STATUS=STATUS_SHUTDOWN;    
  
  if ((STATUS==STATUS_ASLEEP) && (!power_button) && (!acc_on)&& (timerwait==0)) STATUS=STATUS_POWER_OFF;    

  if (STATUS==STATUS_ON) {
    
  if (digitalRead(IN_BUTTON_P1) == 0)  // if the button goes low
  {   
    
    Keyboard.write(KEY_DOWN_ARROW);//Can put your own key sequence here - Next track
    delay(200);  
    Keyboard.write(KEY_RETURN);
  
  while (digitalRead(IN_BUTTON_P1) == 0) {}
  }  
  
  if (digitalRead(IN_BUTTON_P2) == 0)  // if the button goes low
  {
     Keyboard.write(KEY_ESC);  //Can put your own key sequence here - Next album
     delay(500);  
     Keyboard.write(KEY_DOWN_ARROW);
     delay(500); 
     Keyboard.write(KEY_RETURN);
     delay(1000);  
     Keyboard.write(KEY_DOWN_ARROW);
     delay(500); 
     Keyboard.write(KEY_RETURN);
    
  while (digitalRead(IN_BUTTON_P2) == 0) {}
  }
  
  
  if (digitalRead(IN_BUTTON_P3) == 0)  // if the button goes low
  {
    
     Keyboard.write(KEY_ESC); //Can put your own key sequence here - Previous album
     delay(500);  
     Keyboard.write(KEY_UP_ARROW);
     delay(500); 
     Keyboard.write(KEY_RETURN);
     delay(1000);  
     Keyboard.write(KEY_DOWN_ARROW);
     delay(500); 
     Keyboard.write(KEY_RETURN);
     
  while (digitalRead(IN_BUTTON_P3) == 0) {}
  }  
  
  if (digitalRead(IN_BUTTON_P4) == 0)  // if the button goes low
  {
    
    Keyboard.write(KEY_UP_ARROW);//Can put your own key sequence here - Previous track
    delay(200);  
    Keyboard.write(KEY_RETURN);
     
  while (digitalRead(IN_BUTTON_P4) == 0) {}
  }  
  
  
 
  if (digitalRead(IN_BUTTON_P5) == 0)  // if the button goes low
  {
                //Can put your own key sequence here - Not used on my system
  while (digitalRead(IN_BUTTON_P5) == 0) {}
  }
  
  }
  
  time_last_loop=time_current;
  }//EVERY 100ms
  
  

  if ((time_current-time_last_second)>1000) { //EVERY SECOND
  if (timer>0) timer=timer-1;
  if (timerwait>0) timerwait=timerwait-1;
  time_last_second=time_current;
  } //EVERY SECOND
  
  
  if ((time_current-time_last_half_second)>500) { //EVERY HALF SECOND
  flash=!flash;
  time_last_half_second=time_current;
  } //EVERY HALF SECOND
  
  
}



void doStatusChange(void)
{
timer=0; 

if (STATUS==STATUS_BOOT) {
  delay(500); 
  digitalWrite(OUT_PIPO_BUTTON , HIGH); 
  delay(BOOT_PRESS_TIME);
  digitalWrite(OUT_PIPO_BUTTON , LOW); 
  digitalWrite(OUT_MASTER_POWER , HIGH);//master on  
  digitalWrite(OUT_AUX_POWER , HIGH); //aux on
  timerboot=BOOT_TIME;
}  

if (STATUS==STATUS_COLD_BOOT) {
  delay(3000); 
  digitalWrite(OUT_PIPO_BUTTON , HIGH); 
  delay(BOOT_PRESS_TIME);
  digitalWrite(OUT_PIPO_BUTTON , LOW); 
  digitalWrite(OUT_MASTER_POWER , HIGH);//master on  
  digitalWrite(OUT_AUX_POWER , HIGH); //aux on
  STATUS=STATUS_BOOT;
  timerboot=COLD_BOOT_TIME;
}  
 
  
if (STATUS==STATUS_SHUTDOWN) {
  digitalWrite(OUT_AUX_POWER , LOW); //aux off
  delay(1000);
  digitalWrite(OUT_PIPO_BUTTON , HIGH); 
  delay(SHUTDOWN_PRESS_TIME);
  digitalWrite(OUT_PIPO_BUTTON , LOW); 
  timer=SHUTDOWN_TIMEOUT;
  digitalWrite(OUT_MASTER_POWER , HIGH);//mast
  digitalWrite(OUT_AUX_POWER , LOW); //aux off
  timerwait=20;
}    
  
if (STATUS== STATUS_POWER_OFF) {
  digitalWrite(OUT_MASTER_POWER , LOW); //master off   
  digitalWrite(OUT_AUX_POWER , LOW); //aux off
  timerwait=3;
}  

if (STATUS== STATUS_ASLEEP) {
  digitalWrite(OUT_MASTER_POWER , HIGH); //master on   
  digitalWrite(OUT_AUX_POWER , LOW); //aux off
  timer=  SLEEP_TIMEOUT*(60*60);//hrs
  timerwait=3;
}  
 
if (STATUS== STATUS_ON) {
  digitalWrite(OUT_MASTER_POWER , HIGH);//master on  
  digitalWrite(OUT_AUX_POWER , HIGH); //aux on
  timerwait=timerboot;
}   
  
LAST_STATUS=STATUS;   
}
