﻿/*=========================================================================
   This file is part of the Cardboard Robot SDK.
   
   Copyright (C) 2012 Ken Ihara.
  
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

namespace CBRobot {

    /** Stores information about a specific motor on the robot */
    public class MotorParameters {

        private double stepsPerRadian;

        /** Creates a new MotorParameters structure using the given number of
         *  steps per radian.
         */
        public MotorParameters(double stepsPerRadian) {
            this.stepsPerRadian = stepsPerRadian;
        }

        /** Gets or sets the number of motor steps per radian for this motor.
         *  You should only need to change this value if you replace one of
         *  the robot's motors with a custom one.
         */
        public double StepsPerRadian {
            get { return stepsPerRadian; }
            set { stepsPerRadian = value; }
        }
    }
}
