/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>
#import "hidapi/hidapi.h"
#import "CBRobot.h"
#import "CBDeviceDelegate.h"

#define CBR_VENDOR_ID   0x04d8  /* Vendor ID of the USB device */
#define CBR_PRODUCT_ID  0xfc8b  /* Product ID of the USB device */

enum dataConditions { CB_NO_DATA, CB_HAS_DATA };
enum connectionConditions { CB_NOT_SENT, CB_SENT };

/* Data sent to the device */
typedef struct {
    short m1Target, m2Target, m3Target, m4Target;
    short m1Speed, m2Speed, m3Speed, m4Speed;
    BOOL paused;
} CBRDataOut;

/* Data read from the device */
typedef struct {
    short m1Current, m2Current, m3Current, m4Current;
} CBRDataIn;

@class CBRobot;

/* A low-level connection to the USB device. */
@interface CBDeviceConnection : NSObject {
    
    hid_device *deviceHandle;           /* Device handle, NULL if not connected */
    
    NSThread *thread;                   /* Read / write thread */
    
    CBRDataOut dataOut;                 /* Data to write / last written */
    CBRDataIn dataIn;                   /* Data last read */
    BOOL resetHomePositionFlag;         /* Should the home position be set on the next write? */

    NSConditionLock *dataMutex;         /* Data mutex with NO_DATA / HAS_DATA flag */
    NSConditionLock *connectionMutex;   /* Connection state mutex with NOT_WRITTEN / WRITTEN flag */
}

/** Gets whether the device is currently connected. */
@property (readonly, nonatomic) BOOL connected;

- (id)init;
- (void)cancel;

- (void)tryConnect;
- (void)disconnect;
- (void)testConnection;

- (void)updateRobot:(CBRobot *)robot;

@end
