/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

@class CBDeviceConnection;
@class CBRobot;
@protocol CBDeviceDelegate;

/* A high-level connection to the Cardboard Robot USB device. */
@interface CBDevice : NSObject {
    CBDeviceConnection *connection;         /* Low-level connection */
    IONotificationPortRef notificationPort; /* Notification port for device connection / disconnection */
    io_iterator_t deviceAddedIterator;      /* Iterator for added devices */
    io_iterator_t deviceRemovedIterator;    /* Iterator for removed devices */
    NSTimer *autoConnectTimer;              /* Auto-connect timer, in case detection fails */
}

/** Gets whether the device is currently connected. */
@property (readonly, nonatomic) BOOL connected;

/** Gets or sets the delegate which receives notifications about the device. */
@property (assign, nonatomic) id <CBDeviceDelegate> delegate;

- (id)init;

- (void)startAutoConnect;
- (void)stopAutoConnect;

- (void)tryConnect;
- (void)disconnect;

- (void)updateRobot:(CBRobot *)robot;

@end
