/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

/** Stores information about a specific motor on the robot. */
@interface CBMotorParameters : NSObject

/** Gets or sets the number of motor steps per radian for this motor.  You
 *  should only need to change this value if you replace one of the robot's
 *  motors with a custom one.
 */
@property (assign, nonatomic) double stepsPerRadian;

- (id)initWithStepsPerRaidan:(double)steps;

+ (CBMotorParameters *)motorParametersWithStepsPerRadian:(double)steps;


@end
