/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>
#import "CBVector.h"

/** Represents a vector composed of motor positions (M1, M2, M3), measured in
 *  RADIANS, that defines the position or change in position of the robot arm's
 *  tip.
 *
 *  When interpreted as a point, the vector (0, 0, 0) generally represents the
 *  "home position" of the arm.
 */
@interface CBDofVector : NSObject <CBVector>

@property (readonly, nonatomic) double m1;  /**< Gets motor #1's position, in radians */
@property (readonly, nonatomic) double m2;  /**< Gets motor #2's position, in radians */
@property (readonly, nonatomic) double m3;  /**< Gets motor #3's position, in radians */

- (id)initWithM1:(double)m1Pos andM2:(double)m2Pos andM3:(double)m3Pos;

+ (CBDofVector *)vectorWithM1:(double)m1Pos andM2:(double)m2Pos andM3:(double)m3Pos;
+ (CBDofVector *)zero;

- (double)componentWithIndex:(int)component;
- (CBDofVector *)setComponentWithIndex:(int)component toValue:(double)value;

- (CBDofVector *)pointAsDofVectorForRobot:(CBRobot *)robot;

- (NSString *)description;

@end
