/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

/** Represents the speed of the robot arm.
 */
@interface CBArmSpeed : NSObject

/** Gets the speed of motor #1, in radians per second */
@property (readonly, nonatomic) double m1Speed;

/** Gets the speed of motor #2, in radians per second */
@property (readonly, nonatomic) double m2Speed;

/** Gets the speed of motor #3, in radians per second */
@property (readonly, nonatomic) double m3Speed;

/** Gets the speed of motor #4, in radians per second */
@property (readonly, nonatomic) double m4Speed;

- (id)initWithM1Speed:(double)m1 andM2Speed:(double)m2 andM3Speed:(double)m3 andM4Speed:(double)m4;

+ (CBArmSpeed *)armSpeedWithM1Speed:(double)m1 andM2Speed:(double)m2 andM3Speed:(double)m3 andM4Speed:(double)m4;
+ (CBArmSpeed *)zero;

- (NSString *)description;

- (double)componentWithIndex:(int)component;
- (CBArmSpeed *)setComponentWithIndex:(int)component toValue:(double)value;

@end
