/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

@class CBRobot;
@protocol CBVector;

/** Represents a position of the robot arm, which is composed of a tip
 *  position plus the position of motor #4.
 */
@interface CBArmPosition : NSObject

/** Gets the position of the arm's tip (first 3 motor positions) */
@property (readonly, nonatomic) id <CBVector> tipPosition;

/** Gets the position of the fourth motor (crane, camera swivel), in radians */
@property (readonly, nonatomic) double m4;

- (id)initWithTipPosition:(id <CBVector>)tipPos andM4:(double)m4Pos;
- (id)initWithM1:(double)m1Pos andM2:(double)m2Pos andM3:(double)m3Pos andM4:(double)m4Pos;

+ (CBArmPosition *)armPositionWithTipPosition:(id <CBVector>)tipPos andM4:(double)m4Pos;
+ (CBArmPosition *)armPositionWithM1:(double)m1Pos andM2:(double)m2Pos andM3:(double)m3Pos andM4:(double)m4Pos;
+ (CBArmPosition *)zero;

- (NSString *)description;

@end
