/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Cocoa/Cocoa.h>
#import "CBStatusViewDelegate.h"

/** Creates and manages a robot status view */
@interface CBStatusViewController : NSViewController {
    IBOutlet NSButton *button;
    IBOutlet NSTextField *largeText;
    IBOutlet NSTextField *smallText;
}

/** Gets or sets the delegate that receieves events for the status button */
@property (assign, nonatomic) id <CBStatusViewDelegate> delegate;

/** Gets or sets whether the button indicates that the robot is in a connected state */
@property (assign, nonatomic) BOOL connected;

/** Gets or sets whether the button indicates that the robot is in a paused state */
@property (assign, nonatomic) BOOL paused;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

@end
