/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>
#import "CBUnit.h"

@class CBPositionTransformer;
@class CBScalarSpeedTransformer;

/** Represents a single entry / row within a "saved program" */
@interface CBProgramEntry : NSObject

/** Contains the position value for this entry */
@property (readonly, nonatomic) CBPositionTransformer *positionTransformer;

/** Overall speed value (not per-motor), in radians per second */
@property (assign, nonatomic) CBScalarSpeedTransformer *speedTransformer;

/** Number of seconds to pause after this entry */
@property (assign, nonatomic) double pause;

/** DOF unit applied to the position / speed transformers */
@property (assign, nonatomic) CBUnit dofUnit;

- (id)init;

@end
