/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Cocoa/Cocoa.h>
#import "CBPositionTransformer.h"
#import "CBSpeedTransformer.h"
#import "CBStatusViewDelegate.h"

@class CBStatusViewController;
@class CBJoystickTranslator;

@interface CBMainWindowController : NSWindowController <NSWindowDelegate, CBStatusViewDelegate> {
    NSTimer *updateTimer;
    CBStatusViewController *statusViewController;
    CBUnit dofUnit;     // Current Dof unit
    CBArmSpeed *speedBeforeRunningProgram;  // Arm speed before running the program
    NSWindowController *joystickSetupWindowController;  // Controller for the "Joystick Setup" window
    CBJoystickTranslator *joystickTranslator;     // Translates joystick commands into robot input
    
    IBOutlet NSView *mainView;
    IBOutlet NSView *statusViewPlaceholder;       // Placeholder to be replaced by status view
    IBOutlet NSScrollView *programScrollView;     // Scroll view for the program table
    IBOutlet NSSegmentedControl *programSegmentedControl;     // Segmented control for the program table
    IBOutlet NSSegmentedControl *dofUnitControl;  // Unit semgneted control (DOF)
    IBOutlet NSArrayController *arrayController;  // Array controller for the program entries
    IBOutlet NSNumberFormatter *speedNumberFormatter;   // Number formatter for speed values in the program
    IBOutlet NSButton *runProgramButton;          // "Run Program" / "Stop Program" button
}

/** Gets the robot instance associated with this window controller */
@property (readonly, nonatomic) CBRobot *robot;

/** Gets the position transformer storing the current position */
@property (readonly, retain, nonatomic) CBPositionTransformer *currentPositionTransformer;

/** Gets the position transformer storing the target position */
@property (readonly, retain, nonatomic) CBPositionTransformer *targetPositionTransformer;

/** Gets the speed transformer storing the speed */
@property (readonly, retain, nonatomic) CBSpeedTransformer *speedTransformer;

/** Gets whether the position and speed controls are enabled */
@property (readonly, nonatomic) BOOL controlsEnabled;

+ (CBMainWindowController *)sharedInstance;

@end
