/************************************************************
// Simple and lightweight library for RDA5807M FM RADIO
 ************************************************************/
 
#include <Wire.h>
 
void fm_init() {
// Initialize the RDA5807M chip
Wire.beginTransmission(0x11);
Wire.write(0x02); 
Wire.write(0xC0); Wire.write(0x03); 
Wire.endTransmission(); 
delay(500); 
Wire.beginTransmission(0x11); 
Wire.write(0x02); 
Wire.write(0xC0); Wire.write(0x0D); 
Wire.endTransmission();
delay(500);
}
 
void fm_setFreq(int freq) {
int freqB;
byte freqH, freqL;
freqB = freq - 870; 
freqH = freqB>>2; 
freqL = (freqB&3)<<6; 
Wire.beginTransmission(0x11);
Wire.write(0x03);
Wire.write(freqH); 
Wire.write(freqL + 0x10); 
Wire.endTransmission();
Serial.print("Freq:");
Serial.println(freq);
}

unsigned short fm_readFreq(){
delay(200);
unsigned short reg; 
Wire.requestFrom (0x10, 2);
reg = (Wire.read() << 8) + Wire.read();
Wire.endTransmission();
unsigned short freq =  870+ (reg & 0x03FF);
return freq;
}

void fm_setVolume(byte vol) {
if (vol>15) vol=15;
Wire.beginTransmission(0x11);
Wire.write(0x05);
Wire.write(0x84); 
Wire.write(0xD0+vol);
Wire.endTransmission();
}

void fm_mute(boolean mute) {
Wire.beginTransmission(0x11); 
Wire.write(0x02);
if (mute) Wire.write(0x80); 
else  Wire.write(0xC0); 
Wire.write(0x0D); 
Wire.endTransmission();
delay(500);
}

void fm_off() {
Wire.beginTransmission(0x11); 
Wire.write(0x02); 
Wire.write(0x00); 
Wire.write(0x00);
Wire.endTransmission();
delay(500);
}

void fm_on() {
Wire.beginTransmission(0x11);
Wire.write(0x02); 
Wire.write(0xC0); Wire.write(0x0D); 
Wire.endTransmission();
delay(500);
}


void fm_seek() {
Wire.beginTransmission(0x11); 
Wire.write(0x02); 
Wire.write(0xC3); 
Wire.write(0x0D); 
Wire.endTransmission();
delay(500);
}


 
 
