

/*************************************************** 
// Firmware for Car Stereo Main Board v1.02 8/10/2017
// Allan Murray 
 ****************************************************/

#define RADIOON

#include <avr/pgmspace.h>


//Place Frequencies and Names of Stations in your area here
//Below were taken from: http://worldradiomap.com/nz/auckland
//Set station_table and NUM_STATIONS accordingly

const char station_1[] PROGMEM = " 876 West Coast Radio";
const char station_2[] PROGMEM = " 878 Waves of the Pacific";
const char station_3[] PROGMEM = " 879 The Flat";
const char station_4[] PROGMEM = " 880 Radio Spice";
const char station_5[] PROGMEM = " 877 Rush FM";
const char station_6[] PROGMEM = " 882 The Flea";
const char station_7[] PROGMEM = " 884 Christian Radio";
const char station_8[] PROGMEM = " 886 Mai FM";
const char station_9[] PROGMEM = " 889 More FM";
const char station_10[] PROGMEM = " 894 Newstalk ZB";
const char station_11[] PROGMEM = " 902 The Rock";
const char station_12[] PROGMEM = " 910 ZM";
const char station_13[] PROGMEM = " 914 Radio NZ Concert";
const char station_14[] PROGMEM = " 918 More FM";
const char station_15[] PROGMEM = " 926 Radio NZ Concert";
const char station_16[] PROGMEM = " 934 The Breeze";
const char station_17[] PROGMEM = " 938 The Sound";
const char station_18[] PROGMEM = " 942 The Edge";
const char station_19[] PROGMEM = " 946 Life FM";
const char station_20[] PROGMEM = " 950 bFM";
const char station_21[] PROGMEM = " 958 Flava";
const char station_22[] PROGMEM = " 966 George FM";
const char station_23[] PROGMEM = " 974 The Hits";
const char station_24[] PROGMEM = " 982 Mix";
const char station_25[] PROGMEM = " 986 The Hits";
const char station_26[] PROGMEM = " 990 Radio Hauraki";
const char station_27[] PROGMEM = " 998 Life FM";
const char station_28[] PROGMEM = "1001 The Rock";
const char station_29[] PROGMEM = "1006 Radio Live";
const char station_30[] PROGMEM = "1038 Niu FM";
const char station_31[] PROGMEM = "1046 Planet FM";
const char station_32[] PROGMEM = "1049 Magic";
const char station_33[] PROGMEM = "1054 Coast";
const char station_34[] PROGMEM = "1062 Humm FM";
const char station_35[] PROGMEM = "1068 MAD FM";
const char station_36[] PROGMEM = "1070 Radio Virsa NZ";
const char station_37[] PROGMEM = "1073 Unforgettable Music";
const char station_38[] PROGMEM = "1074 The Brew";

const char* const station_table[] PROGMEM = {station_1, station_2, station_3, station_4, station_5, station_6, station_7, station_8, station_9, station_10, 
station_11, station_12, station_13, station_14, station_15, station_16, station_17, station_18, station_19, station_20, 
station_21, station_22, station_23, station_24, station_25, station_26, station_27, station_28, station_29, station_30, 
station_31, station_32, station_33, station_34, station_35, station_36, station_37, station_38};

#define NUM_STATIONS 38


#include <EEPROM.h>

#include <SPI.h>
#include <Adafruit_VS1053.h>
#include <SdFat.h>          // SD library with long filenames
SdFat SD;


boolean hasSD=false;

#include <Arduino.h>
#include "FM_Radio.h"
 
#include <avr/pgmspace.h>

#include <Wire.h>

//#define DISPLAY_16x2 //Uncomment for 16x2 LCD display
#define DISPLAY_20x4 //Uncomment for 20x4 LCD display

#include <LiquidCrystal_I2C.h> // Using version 1.2.1 
#ifdef DISPLAY_16x2
LiquidCrystal_I2C lcd(0x3F,16,2);  // i2c address 0x3F
#endif
#ifdef DISPLAY_20x4
LiquidCrystal_I2C lcd(0x3F,20,4);  // i2c address 0x3F
#endif

// ----- Fixed settings here. -----

//EPROM ADDRESSES
#define EP_ADDR_ALBUM  0
#define EP_ADDR_TRACK  1 
#define EP_ADDR_MODE  2
#define EP_ADDR_RAND  3
#define EP_ADDR_LAST  4
#define EP_ADDR_FREQ  5
#define EP_ADDR_CHAN  100  //start address of fm channel data
#define EP_CHAN_LEN   40  //length of each channel entry
#define EP_CHAN_NUM   10   //max number of channels
 
#define BTPIN 2
#define MP3_VOLUME   20              
#define FM_VOLUME    3
#define MP3_VOLUME_LOW   50      
#define FM_VOLUME_LOW    1
#define RESUME_VOL_DELAY  1000

// These are the pins used for the breakout example
#define BREAKOUT_RESET 7// 8//9      // VS1053 reset pin (output)
#define BREAKOUT_CS    8// 6//10     // VS1053 chip select pin (output)
#define BREAKOUT_DCS   6// 7//8      // VS1053 Data/command select pin (output)
// These are the pins used for the music maker shield
#define SHIELD_RESET  -1      // VS1053 reset pin (unused!)
#define SHIELD_CS     9//7    // VS1053 chip select pin (output)
#define SHIELD_DCS    6      // VS1053 Data/command select pin (output)
// These are common pins between breakout and shield
#define CARDCS 9//4     // Card chip select pin
// DREQ should be an Int pin, see http://arduino.cc/en/Reference/attachInterrupt
#define DREQ 3//2      // VS1053 Data request, ideally an Interrupt pin

Adafruit_VS1053_FilePlayer musicPlayer = Adafruit_VS1053_FilePlayer(BREAKOUT_RESET, BREAKOUT_CS, BREAKOUT_DCS, DREQ, CARDCS);


 #define MAX_NO_TRACKS  20 //50 tracks maximum per album
 #define MAX_NAME_LEN  30 //50 tracks maximum per album
 char filebuffer[MAX_NAME_LEN +MAX_NAME_LEN +2];
 char currentSong[MAX_NAME_LEN +1]; //79 char max length for filename (including .mp3)
 char currentAlbum[MAX_NAME_LEN +1];//79 char max length for directory (album) name
 FatPos_t tracks[MAX_NO_TRACKS]; 
 byte serialPos=0;
 byte numberAlbums=0;
 byte numberTracks=0;
 byte totalTracks=0;
 
//PERSISTANT VARIABLES
 byte playmode =1;  //0=alloff 1=mp3 2=bluetooth 3=fm radio
 byte lastplaymode =1; 
 bool randomPlay=false;
 byte albumNumber =1;
 byte trackNumber = 1;
 unsigned short fm_frequency=918;

 byte  low_vol =0;
 byte currentchannel=0;
 boolean wifi=false;
 unsigned long wifitime=0;
 unsigned long EPROMdelay=0;
 File dir;

byte lastkeypress=0;
unsigned long press_ms=0;
 

void createChars()
{
byte v[8] = {
  B00000,
  B11111,
  B00000,
  B01110,
  B00000,
  B00100,
  B00000,
  B00000
};
lcd.createChar(0, v);//WIFI

v[0]=B00100;
v[1]=B10110;
v[2]=B01101;
v[3]=B00110;
v[4]=B01101;
v[5]=B10110;
v[6]=B00100;
v[7]=B00000;
lcd.createChar(2, v); //BT

v[0]=B00111;
v[1]=B01001;
v[2]=B10001;
v[3]=B10001;
v[4]=B10001;
v[5]=B10001;
v[6]=B11111;
v[7]=B00000;
lcd.createChar(1, v); //SD


v[0]=B11111;
v[1]=B10000;
v[2]=B11110;
v[3]=B10000;
v[4]=B00000;
v[5]=B11111;
v[6]=B10101;
v[7]=B10101;
lcd.createChar(3, v); //FM

v[0]=B00111;
v[1]=B01001;
v[2]=B10111;
v[3]=B10101;
v[4]=B10101;
v[5]=B10001;
v[6]=B11111;
v[7]=B00000;
lcd.createChar(4, v); //SD random

}



void saveCurrentInEPROM()
{
  Serial.println("UPDATE");
  EEPROM.update(EP_ADDR_ALBUM,albumNumber);
  EEPROM.update(EP_ADDR_TRACK, trackNumber);
  EEPROM.update(EP_ADDR_MODE ,playmode);
  EEPROM.update(EP_ADDR_RAND,  randomPlay);
  EEPROM.update(EP_ADDR_LAST,  lastplaymode);
  byte bl=fm_frequency;
  byte bh=fm_frequency>>8;
  EEPROM.update(EP_ADDR_FREQ,bl);
  EEPROM.update(EP_ADDR_FREQ+1,bh);
}

void loadCurrentFromEPROM()
{
  albumNumber=EEPROM.read(EP_ADDR_ALBUM);
  trackNumber=EEPROM.read(EP_ADDR_TRACK);
  playmode=EEPROM.read(EP_ADDR_MODE);
  randomPlay=EEPROM.read(EP_ADDR_RAND);
  lastplaymode=EEPROM.read(EP_ADDR_LAST);
  fm_frequency=(EEPROM.read(EP_ADDR_FREQ+1)<<8)+EEPROM.read(EP_ADDR_FREQ);
}

byte isChannel( unsigned short freq)//returns channel number that has freq, otherwise 0
{
 getStationName(freq); 
 int eadd=EP_ADDR_CHAN;
 for (byte ct = 1; ct <= EP_CHAN_NUM; ct++) {
 byte t_val=EEPROM.read(eadd); 
 unsigned short t_freq=(EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
 if ((t_val==1) && (t_freq==freq)) {
  return ct;
 }
 eadd=eadd+EP_CHAN_LEN;
 }
 return 0;
}



byte removeChannel( unsigned short freq)// 
{
 int eadd=EP_ADDR_CHAN;
 for (byte ct = 1; ct <= EP_CHAN_NUM; ct++) {
 byte t_val=EEPROM.read(eadd); 
 unsigned short t_freq=(EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
 if ((t_val==1) && (t_freq==freq)) {
  EEPROM.update(eadd, 0);
  return ct;
 }
 eadd=eadd+EP_CHAN_LEN;
 }
 return 0;
}

void getStationName( unsigned short freq)
{
  Serial.print("F:");
  Serial.println(freq);
  
  for (int i = 0; i < NUM_STATIONS; i++)
  {
    //repurpose filebuffer
    strcpy_P( &filebuffer[MAX_NAME_LEN], (char*)pgm_read_word(&(station_table[i]))); // Necessary casts and dereferencing, just copy. 
    filebuffer[MAX_NAME_LEN+4]=0;
    unsigned short  f = atoi(&filebuffer[MAX_NAME_LEN]);
    Serial.println(f);
    if (f==freq) return;
  }
   memset(&filebuffer[MAX_NAME_LEN],0,MAX_NAME_LEN);
}


byte setChannel( unsigned short freq)//set an empty channel to freq
{
 int eadd=EP_ADDR_CHAN;
 for (byte ct = 1; ct <= EP_CHAN_NUM; ct++) {
 byte t_val=EEPROM.read(eadd); 
 if (t_val!=1) {
  EEPROM.update(eadd, 1);
  byte bl=freq;
  byte bh=freq>>8;
  EEPROM.update(eadd+1,bl);
  EEPROM.update(eadd+2,bh);
  return ct;
 }
 eadd=eadd+EP_CHAN_LEN;
 }
 return 0;
}

unsigned short getNextChannel( unsigned short freq)//returns freq channel with next largest freq, otherwise 0
{
 int difference=999999; 
 unsigned short currentfreq=0;
 int eadd=EP_ADDR_CHAN;
 for (byte ct = 1; ct <= EP_CHAN_NUM; ct++) {
 byte t_val=EEPROM.read(eadd); 
 if (t_val==1) {
  unsigned short t_freq=(EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
  int d=t_freq-freq;
  if ((d>0) && (d<difference)){
    currentfreq=t_freq;
    difference=d;
  }
 }
 eadd=eadd+EP_CHAN_LEN;
 }
 return currentfreq;
}

unsigned short incrementChannel(byte chan)//returns freq of next used channel
{
int eadd=EP_ADDR_CHAN+((chan-1)*EP_CHAN_LEN);
 while (chan<EP_CHAN_NUM) {
 eadd=eadd+EP_CHAN_LEN;
 chan++;
   byte t_val=EEPROM.read(eadd); 
   if (t_val==1) return (EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
 }
  return 0;
 }

unsigned short decrementChannel(byte chan)//returns freq of next used channel
{
int eadd=EP_ADDR_CHAN+((chan-1)*EP_CHAN_LEN);
 while (chan>1) {
 eadd=eadd-EP_CHAN_LEN;
 chan++;
   byte t_val=EEPROM.read(eadd); 
   if (t_val==1) return (EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
 }
  return 0;
 } 



unsigned short getPreviousChannel( unsigned short freq)//returns freq channel with next largest freq, otherwise 0
{
 int difference=999999; 
 unsigned short currentfreq=0;
 int eadd=EP_ADDR_CHAN;
 for (byte ct = 1; ct <= EP_CHAN_NUM; ct++) {
 byte t_val=EEPROM.read(eadd); 
 if (t_val==1) {
  unsigned short t_freq=(EEPROM.read(eadd+2)<<8)+EEPROM.read(eadd+1);
  int d=freq-t_freq;
  if ((d>0) && (d<difference)){
    currentfreq=t_freq;
    difference=d;
  }
 }
 eadd=eadd+EP_CHAN_LEN;
 }
 return currentfreq;
}



byte getkeypress()
{
 if (digitalRead(A0)==LOW) return A0;
 if (digitalRead(A1)==LOW) return A1;
 if (digitalRead(A2)==LOW) return A2;
 if (digitalRead(A3)==LOW) return A3;
 if (analogRead(A7)>1000) return A7; //ANALOG ONLY PIN - SENSE HIGH - SPARE NOT USED
 if (analogRead(A6)>1000) return A6; //ANALOG ONLY PIN - SENSE HIGH - LOW VOLUME
 return 0;
}


void updateDisplay(boolean track)
{

//-----------------------------20x4 DISPLAY BEGIN--------------------------------
#ifdef DISPLAY_20x4
   if (playmode==1) { 
    
       char *p= strchr ( currentAlbum, '-' );  
       if (p) *p=0;  
       p++;
       lcd.setCursor(0,1);
       lcd.print(p);
       int i=20-strlen(p);
       while (i>=1) {
       lcd.print(F(" "));
       i=i-1;
       }
       p--;


       lcd.setCursor(0,0);
       if (p) {
       lcd.print(currentAlbum);
       i=18-strlen(currentAlbum);
       while (i>=1) {
       lcd.print(F(" "));
       i=i-1;
       }
       }
       else  lcd.print(F("                    "));
       
       if (p) *p='-';


       
       int b= strlen(currentSong);
       if (b>4) currentSong[b-4]=0;


       
       if (track) {
        char a=currentSong[2];
        currentSong[2]='.';
        
      if ((b-4)<=20) {
      lcd.setCursor(0,3);
      lcd.print(currentSong);
         i=20-strlen(currentSong);
         while (i>=1) {
         lcd.print(F(" "));
         i=i-1;
         }
      lcd.setCursor(0,2);
      lcd.print(F("                    "));
      }else
      { 
        lcd.setCursor(0,2);
        byte p=20;
        byte cnt=0;
        while ((cnt<=10) && (p==20) && ((b-4)>20))
        {
          if (currentSong[p-cnt]==' ') p=p-cnt;
          cnt++;
        }
        
        char c=currentSong[p];
        currentSong[p]=0;
 
        lcd.print(currentSong);
         i=20-strlen(currentSong);
         while (i>=1) {
         lcd.print(F(" "));
         i=i-1;
         }
        currentSong[p]=c;
       lcd.setCursor(0,3);
        if (((b-4)>20) && (p<(b-4))) {
        byte p2=p;
        if (currentSong[p2]==' ') p2++;  
        lcd.print(&currentSong[p2]);
         i=20-strlen(&currentSong[p2]);
         while (i>=1) {
         lcd.print(F(" "));
         i=i-1;
         }
       }
       else
       {
       lcd.print(F("                    "));
       }
       } 
         currentSong[2]=a;
       }
       else  
       {
       lcd.setCursor(0,2);
       lcd.print(F("                    "));
       lcd.setCursor(0,3);
       lcd.print(F("                    ")); 
       }
       if (b>4) currentSong[b-4]='.';
       
   }

   if (playmode==2) {  
       lcd.setCursor(0,0);
       lcd.print(F("BLUETOOTH         "));
       lcd.setCursor(0,1);
       lcd.print(F("                    "));
       lcd.setCursor(0,2);
       lcd.print(F("                    "));
       lcd.setCursor(0,3);
       lcd.print(F("                    ")); 
   }     

   if (playmode==3) {  
      memset(filebuffer, 0, 21); 
      int fd=fm_frequency/10;

      lcd.setCursor(0,0);
      memset(filebuffer, 0, 21);
      snprintf(filebuffer,20,"%d.%dMHz  ",fd,fm_frequency-(fd*10));
      lcd.print(filebuffer);
      lcd.setCursor(9,0);
      memset(filebuffer, 0, 21);
      snprintf(filebuffer,20," CH%02d   ",currentchannel);
      if (currentchannel==0) lcd.print(F("         "));
      else lcd.print(filebuffer);
         
      lcd.setCursor(0,2); 
      lcd.print(&filebuffer[MAX_NAME_LEN+5]);
    //  lcd.setCursor(strlen(&filebuffer[MAX_NAME_LEN+5]),1);
      lcd.print(F("                    "));
       lcd.setCursor(0,1);
       lcd.print(F("                    "));
       lcd.setCursor(0,3);
       lcd.print(F("                    ")); 
   }        

  if (wifi) {
   lcd.setCursor(17,0);
   lcd.print(F(" "));
   lcd.setCursor(18,0);
   lcd.write(byte(0));
  }
  else
  {
   lcd.setCursor(18,0);
   lcd.print(F(" "));
  }
  
  lcd.setCursor(19,0);
  if ((playmode==1) && !randomPlay) lcd.write(byte(1));
  if ((playmode==1) && randomPlay) lcd.write(byte(4));
  if (playmode==2) lcd.write(byte(2));
  if (playmode==3) lcd.write(byte(3));
#endif
//-----------------------------20x4 DISPLAY END--------------------------------

//-----------------------------16x2 DISPLAY BEGIN--------------------------------
#ifdef DISPLAY_16x2
   if (playmode==1) { 
    
       char *p= strchr ( currentAlbum, '-' );  
       if (p) *p=0;  
       if ((strcmp(currentAlbum, "Billy Joel")  == 0) 
       |(strcmp(currentAlbum, "U2")  == 0) 
       |(strcmp(currentAlbum, "Various")  == 0) 
       |(strcmp(currentAlbum, "Eagles")  == 0))
       {
       p++;
       lcd.setCursor(0,0);
       lcd.print(p);
       int i=14-strlen(p);
       while (i>=1) {
       lcd.print(F(" "));
       i=i-1;
       }
       p--;
       if (p) *p='-';
       }
       else
       {
       lcd.setCursor(0,0);
       lcd.print(currentAlbum);
       int i=14-strlen(currentAlbum);
       while (i>=1) {
       lcd.print(F(" "));
       i=i-1;
       }
       }
       if (p) *p='-';
       
       int b= strlen(currentSong);
       if (b>4) currentSong[b-4]=0;
       lcd.setCursor(0,1);
       if (track) {
        lcd.print(&currentSong[3]);
       // lcd.setCursor(strlen(&currentSong[3]),1);
        lcd.print(F("                "));
       } 
       else  lcd.print(F("                "));
       
       if (b>4) currentSong[b-4]='.';
   }

   if (playmode==2) {  
       lcd.setCursor(0,0);
       lcd.print(F("BLUETOOTH     "));
       lcd.setCursor(0,1);
       lcd.print(F("                "));
   }     

   if (playmode==3) {  
      memset(filebuffer, 0, 20); 
      int fd=fm_frequency/10;

      lcd.setCursor(0,0);
      memset(filebuffer, 0, 20);
      snprintf(filebuffer,20,"%d.%dMHz ",fd,fm_frequency-(fd*10));
      lcd.print(filebuffer);
      lcd.setCursor(8,0);
      memset(filebuffer, 0, 20);
      snprintf(filebuffer,20," CH%02d",currentchannel);
      if (currentchannel==0) lcd.print(F("      "));
      else lcd.print(filebuffer);
         
      lcd.setCursor(0,1); 
      lcd.print(&filebuffer[MAX_NAME_LEN+5]);
    //  lcd.setCursor(strlen(&filebuffer[MAX_NAME_LEN+5]),1);
      lcd.print(F("                "));
   }        

  if (wifi) {
   lcd.setCursor(13,0);
   lcd.print(F(" "));
   lcd.setCursor(14,0);
   lcd.write(byte(0));
  }
  else
  {
   lcd.setCursor(14,0);
   lcd.print(F(" "));
  }
  
  lcd.setCursor(15,0);
  if ((playmode==1) && !randomPlay) lcd.write(byte(1));
  if ((playmode==1) && randomPlay) lcd.write(byte(4));
  if (playmode==2) lcd.write(byte(2));
  if (playmode==3) lcd.write(byte(3));
#endif
//-----------------------------16x2 DISPLAY END-------------------------------- 
}



void setmode(byte newmode)
{
  if ((newmode<0) || (newmode>3)) newmode=1;
  
  playmode=newmode;
  saveCurrentInEPROM();
  

  
 if (playmode==1) {
  musicPlayer.setVolume(MP3_VOLUME,MP3_VOLUME);
  sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
  musicPlayer.startPlayingFile(filebuffer);
  Serial.println(">MP3");
 }

 if (playmode==2) {
  digitalWrite(BTPIN,HIGH); //BT on
 }

 if (playmode==3) {
  fm_init();
   fm_setVolume(FM_VOLUME);
   fm_setFreq(fm_frequency);
   currentchannel=isChannel(fm_frequency);
  Serial.println(">RFM");
 } 

 if (playmode==0) {
  Serial.println(">OFF");
 }

  delay(200); 
 if (playmode!=2) {
  digitalWrite(BTPIN,LOW); //BT off
 }
  
 if (playmode!=3) fm_off();

 if (playmode!=1) {
  musicPlayer.setVolume(255,255);
  musicPlayer.stopPlaying();
 }

 
 updateDisplay(true); 
}
 
void setup() {
 
  pinMode(A0, INPUT_PULLUP);
  pinMode(A1, INPUT_PULLUP);
  pinMode(A2, INPUT_PULLUP);
  pinMode(A3, INPUT_PULLUP);
  pinMode(A6, INPUT_PULLUP);
  pinMode(A7, INPUT_PULLUP);
  
  pinMode(BTPIN, OUTPUT);
  digitalWrite(BTPIN,LOW); //BT off
 

  Wire.begin();
  Serial.begin(9600);

   fm_init();
   fm_off();

  Serial.println(F(">OK."));
  
  if (! musicPlayer.begin()) { // initialise the music player
     Serial.println(F(">ER1"));//Couldn't find VS1053, do you have the right pins defined?
     while (1);
  }

  // Set volume for left, right channels. lower numbers == louder volume!
  musicPlayer.setVolume(255,255);

   musicPlayer.useInterrupt(VS1053_FILEPLAYER_PIN_INT);  // DREQ int

   
   if (!SD.begin(CARDCS)) {
    Serial.println(F(">SD!")); //SD failed, or not present
    hasSD=false;  // don't do anything more
  }
  else 
  {
    hasSD=true;
    Serial.println(F("SDok"));
  }

    lcd.init(); 
    lcd.backlight();
    createChars();
    lcd.noAutoscroll();
    lcd.setCursor(0,0);
    lcd.print(F("Welcome...       "));
    lcd.setCursor(0,1);
    lcd.print(F("Car Stereo V1.0"));


    numberAlbums=0;
    loadCurrentFromEPROM();
    if ((!hasSD) && (playmode==1)) playmode=3;

  if (hasSD) {
    numberAlbums=listAlbums();
        getAlbum(albumNumber);
        totalTracks=listTracks();
        getSong(trackNumber);
       Serial.println(F("CURRENT ALBUM"));
       Serial.println(currentAlbum);
       Serial.println(F("CURRENT SONG"));
       Serial.println(currentSong);

       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
       Serial.println(F("CURRENT TRACK"));
       Serial.println(filebuffer);
               
  }
  setmode(playmode);
  updateDisplay(true); 
}

void nextalbum(byte inc)
{
  musicPlayer.stopPlaying();
      albumNumber=albumNumber+inc;
      if (albumNumber >numberAlbums) albumNumber=1;
      getAlbum(albumNumber);
      totalTracks=listTracks();
      trackNumber = 1;
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
      //  Serial.println(albumNumber);
     //  Serial.println(trackNumber);
       Serial.println(F("CURRENT TRACK"));
       Serial.println(filebuffer);
         //saveCurrentInEPROM();
       EPROMdelay=millis();
       musicPlayer.startPlayingFile(filebuffer);
}

void previousalbum(byte dec)
{
     musicPlayer.stopPlaying();
      albumNumber=albumNumber-dec;
      if (albumNumber <1) albumNumber=numberAlbums;
      getAlbum(albumNumber);
      totalTracks=listTracks();
      trackNumber = 1;
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
     //   Serial.println(albumNumber);
     //  Serial.println(trackNumber);
       Serial.println("CURRENT TRACK");
       Serial.println(filebuffer);
         //saveCurrentInEPROM();
       EPROMdelay=millis();
       musicPlayer.startPlayingFile(filebuffer);
}


void loop() {

  byte ccount=0;
  while ((Serial.available()>0) && (ccount<50)){
    char c = Serial.read();
    Serial.print(c);
     ccount++;
    filebuffer[serialPos]=c;
    serialPos++;

    if ((c==13) || (c==10) ||(serialPos>=MAX_NAME_LEN+8)){
    filebuffer[serialPos-1]=0;
    c=0;

  c=filebuffer[0];
    serialPos=0;

    Serial.println("");
    Serial.println(filebuffer);

     if ((filebuffer[0] == 'M') &&(filebuffer[1] == 'Q') &&(filebuffer[2] == 'Y'))    { 
       wifitime=millis();
      if (!wifi) { 
      wifi=true;
      updateDisplay(true);
      }
     }

      if ((filebuffer[0] == 'M') &&(filebuffer[1] == 'Q') &&(filebuffer[2] == 'N')&& wifi)    {  
      wifi=false;
       updateDisplay(true);
     }    

    if ((filebuffer[0] == 'B') &&(filebuffer[1] == 'T') &&(filebuffer[2] == 'H')&& (filebuffer[3] == ':'))    {
    if (playmode!=2) {
      lastplaymode=playmode;
      playmode=2;
    }
    else 
    {
      playmode=lastplaymode;
      if ((!hasSD) && (playmode==1)) playmode=3;
    }
    setmode(playmode);
    delay(100);
     }    
    if ((filebuffer[0] == 'F') &&(filebuffer[1] == 'R') &&(filebuffer[2] == 'Q')&& (filebuffer[3] == ':'))    {
      
      int  freq = atoi(&filebuffer[4]);
      if ((freq>=760) && (freq<=1080)){
      if (playmode!=3) setmode(3);
        fm_frequency=freq;
        fm_setFreq(fm_frequency);
        EPROMdelay=millis();
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
      }
    }
      
    if ((filebuffer[0] == 'A') &&(filebuffer[1] == 'L') &&(filebuffer[2] == 'B')&& (filebuffer[3] == ':'))    {
      byte a=getAlbumName(&filebuffer[4]);
      if (a>0) {
      musicPlayer.stopPlaying();
      albumNumber=a;
      getAlbum(albumNumber);
      totalTracks=listTracks();
      trackNumber = 1;
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
      //  Serial.println(albumNumber);
     //  Serial.println(trackNumber);
       Serial.println("CURRENT TRACK");
       Serial.println(filebuffer);
       //saveCurrentInEPROM();
       EPROMdelay=millis();
       if (musicPlayer.paused()) musicPlayer.pausePlaying(false); 
       if (playmode!=1) setmode(1);
       else musicPlayer.startPlayingFile(filebuffer);
      }
    }
    
      
    // if we get an 'p' on the serial console, pause/unpause!
    if (c == 'p') {
      if (! musicPlayer.paused()) {
        Serial.println(F("Paused"));
        musicPlayer.pausePlaying(true);
      } 
    }
  }

  }

  byte key=getkeypress();
  if ((key!=0) && (lastkeypress==0)) {//KEY PRESSED
   lastkeypress=key;
   press_ms=millis(); 
     if ((key==A6) && (playmode!=2)) {//REDUCE VOLUME SIGNAL DETECTED
        low_vol=1;
        if (playmode==1)  musicPlayer.setVolume(MP3_VOLUME_LOW,MP3_VOLUME_LOW);
        if (playmode==3) fm_setVolume(FM_VOLUME_LOW);
      }
  }

   if ((key==0) && (lastkeypress!=0)) {// KEY RELEASED
   press_ms=millis()-press_ms; //# ms pressed


   if  (low_vol==1) {//REDUCE VOLUME SIGNAL FINISHED
      low_vol=3;
      press_ms=millis();
     }
 
  if ((lastkeypress==A3) && (press_ms>40)&& (press_ms<1000)&&(playmode==1))
  {
        if (randomPlay) playRandomTrack();
        else playNextTrack();
        delay(100);
  }

  if ((lastkeypress==A3) && (press_ms>1000)&&(playmode==1))
  {
         randomPlay=!randomPlay;
        if (randomPlay) Serial.println(F(">RND"));
        else  Serial.println(F(">SEQ"));
         //saveCurrentInEPROM();
       EPROMdelay=millis();
        updateDisplay(true);
        delay(100);
  }
  
  if ((lastkeypress==A3) && (press_ms>40)&& (press_ms<1000)&&(playmode==3))
  {
    Serial.println(">SEK");
        fm_seek();
        delay(100);
        fm_frequency=fm_readFreq();
               //saveCurrentInEPROM();
       EPROMdelay=millis();
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
  }

  if ((lastkeypress==A0) && (press_ms>40) && (press_ms<1000) &&(playmode!=0))
  {
    if (playmode==2) {
    //  playmode=lastplaymode;
    }
    else 
    {
      if (playmode==1) playmode=3;
      else playmode=1;
      if ((!hasSD) && (playmode==1)) playmode=3;
      setmode(playmode);
      delay(100);
    }

  }

  if ((lastkeypress==A0) && ((press_ms>1000) || (playmode==0)))
  {
    if (playmode!=2) {
      lastplaymode=playmode;
      playmode=2;
    }
    else 
    {
      playmode=lastplaymode;
      if ((!hasSD) && (playmode==1)) playmode=3;
    }
    setmode(playmode);
    delay(100);
  }
  
   
  
  if ((lastkeypress==A2) && (press_ms>40)&& (press_ms<1000)&&(playmode==1))
  {
      nextalbum(1);
        delay(100);
  }
  if ((lastkeypress==A2) && (press_ms>1000)&&(playmode==1))
  {
      nextalbum(8);
        delay(100);
  }


  
 if ((lastkeypress==A2) && (press_ms>40)&& (press_ms<1000)&&(playmode==3))
  {
    unsigned short freq;
    if (currentchannel==0)  freq=getNextChannel(fm_frequency);
    else freq=incrementChannel(currentchannel);
    if (freq>0) {
        fm_frequency=freq;
        fm_setFreq(fm_frequency);
               //saveCurrentInEPROM();
       EPROMdelay=millis();
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
    }
  }

 if ((lastkeypress==A2) && (press_ms>1000)&&(playmode==3))
  {
    setChannel(fm_frequency);
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
  }


 if ((lastkeypress==A1) && (press_ms>40)&& (press_ms<1000)&&(playmode==3))
  {
    unsigned short freq;
    if (currentchannel==0)  freq=getPreviousChannel(fm_frequency);
    else freq=decrementChannel(currentchannel);
    if (freq>0) {
        fm_frequency=freq;
        fm_setFreq(fm_frequency);
               //saveCurrentInEPROM();
       EPROMdelay=millis();
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
    }
  }
  
  if ((lastkeypress==A1) && (press_ms>1000)&&(playmode==3))
  {
    removeChannel(fm_frequency);
        currentchannel=isChannel(fm_frequency);
        updateDisplay(false);
  } 

  if ((lastkeypress==A1) && (press_ms>40)&& (press_ms<1000)&&(playmode==1))
  {
      previousalbum(1);
        delay(100);
  }

  if ((lastkeypress==A1) && (press_ms>1000)&&(playmode==1))
  {
      previousalbum(8);
        delay(100);
  }
  
  lastkeypress=0;
   }

      if (((millis()-wifitime)>5000) && wifi)  {  
      wifi=false;
       updateDisplay(true);
     }   
  
  if ((musicPlayer.stopped()) &&(playmode==1)) {
    Serial.println(F("Stopped"));
    if (randomPlay) playRandomTrack();
     else playNextTrack();
  }

  //Save to Eprom after a 5 second delay so that Eprom memory not used up when flicking tracks
  if ((EPROMdelay>0) && ((millis()-EPROMdelay)>5000)) {
    EPROMdelay=0;
    saveCurrentInEPROM(); 
  }

  if ((low_vol==3) &&( (millis()-press_ms)>RESUME_VOL_DELAY)) low_vol=2;

  if (low_vol==2) {//RESUME NORMAL VOLUME
    low_vol=0;
    if (playmode==1)  musicPlayer.setVolume(MP3_VOLUME,MP3_VOLUME);
    if (playmode==3) fm_setVolume(FM_VOLUME);
    
  }  
}




void playRandomTrack()
{
      musicPlayer.stopPlaying();
      randomSeed(millis());
      albumNumber = random(numberAlbums)+1;
      getAlbum(albumNumber);
      totalTracks=listTracks();
      trackNumber = getValidTrack(random(totalTracks)+1);
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
      //  Serial.println(albumNumber);
     //  Serial.println(trackNumber);
       Serial.println(F("CURRENT TRACK"));
       Serial.println(filebuffer);
              //saveCurrentInEPROM();
       EPROMdelay=millis();
       if (musicPlayer.paused()) musicPlayer.pausePlaying(false); 
       musicPlayer.startPlayingFile(filebuffer);
}

void playNextTrack()
{
      musicPlayer.stopPlaying();
      trackNumber++;
      while ((trackNumber<=numberTracks) && (tracks[trackNumber-1].position==-1)) trackNumber++;
     //   Serial.println(trackNumber);
      if (trackNumber >numberTracks){
      albumNumber++;
      if (albumNumber >numberAlbums) albumNumber=1;
      getAlbum(albumNumber);
      totalTracks=listTracks();
      trackNumber = 1;
      }
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
      //  Serial.println(albumNumber);
     //  Serial.println(trackNumber);
       Serial.println(F("CURRENT TRACK"));
       Serial.println(filebuffer);
                //saveCurrentInEPROM();
       EPROMdelay=millis();
         if (musicPlayer.paused()) musicPlayer.pausePlaying(false); 
       musicPlayer.startPlayingFile(filebuffer);

}

void playPreviousTrack()
{
      musicPlayer.stopPlaying();
      trackNumber--;
      while ((trackNumber>0) && (tracks[trackNumber-1].position==-1)) trackNumber--;
    //  Serial.println(trackNumber);
      if (trackNumber <1){
      albumNumber--;
      if (albumNumber<1) albumNumber=numberAlbums;
      getAlbum(albumNumber);
      numberTracks=listTracks();
      trackNumber = numberTracks;
      }
      getSong(trackNumber);
       sprintf(filebuffer,"%s/%s",currentAlbum,currentSong);
     //   Serial.println(albumNumber);
    //   Serial.println(trackNumber);
       Serial.println(F("CURRENT TRACK"));
       Serial.println(filebuffer);
                //saveCurrentInEPROM();
       EPROMdelay=millis();
         if (musicPlayer.paused()) musicPlayer.pausePlaying(false); 
       musicPlayer.startPlayingFile(filebuffer);

}


int listTracks() {
   memset(tracks,-1,sizeof(tracks));
   byte count=0;
   numberTracks=0;
   FatPos_t t;
   Serial.println(F("CURRENT ALBUM"));
   Serial.println(currentAlbum);
   File entry =  SD.open(currentAlbum);
   while(true) {

   entry.getpos(&t); 
   File entry2 =  entry.openNextFile();
     if (! entry2) break;
   
        entry2.getName(filebuffer,80);
        byte tnum=getTrackNumber(filebuffer);
        if ((isMP3(filebuffer)) && (tnum>0) && (tnum<=MAX_NO_TRACKS) && (tracks[tnum-1].position==-1)
        )
        {
          if (tnum>numberTracks) numberTracks=tnum;
           tracks[tnum-1]=t;
           Serial.print(tnum);
           Serial.print(" ");
       //   Serial.print(t.position);
       // Serial.print(" ");
        Serial.println(filebuffer);
        count++;
        }
        entry2.close();
   }
   entry.close();
   Serial.println("*");
   return count;
}



int listAlbums() {
  byte count=0;
  File dir=SD.open("/");
   while(true) {
     
     File entry =  dir.openNextFile();
     if (! entry)  break;

     if (entry.isDirectory()) {
        entry.getName(filebuffer,MAX_NAME_LEN+1);
        if ((strcmp(filebuffer, "System Volume Information")  != 0) && (filebuffer[0]!='$') && (currentAlbum[0]!='.')){
        Serial.println(filebuffer);
        count++;
       }
     } 
     entry.close();
   }
   dir.close();
   Serial.println("*");
   return count;
}


void getAlbum(int number){
    SD.vwd()->rewind();
  byte count=0;
  File dir=SD.open("/");
   while(true) {
   File entry =  dir.openNextFile();

     if (! entry) break;
     
     if (entry.isDirectory()) {
        entry.getName(currentAlbum,MAX_NAME_LEN+1);
        if ((strcmp(currentAlbum, "System Volume Information")  != 0)  && (currentAlbum[0]!='$') && (currentAlbum[0]!='.')){
          count++;
          if (count>=number) {
            entry.close();  
            break;
          }
        }
     } 
    entry.close(); 
   }
   dir.close();
   updateDisplay(false); 
}


byte getAlbumName(char *albumname){
    SD.vwd()->rewind();
  byte count=0;
  File dir=SD.open("/");
   while(true) {
   File entry =  dir.openNextFile();

     if (! entry) break;
     
     if (entry.isDirectory()) {
        entry.getName(currentAlbum,MAX_NAME_LEN+1);
        if ((strcmp(currentAlbum, "System Volume Information")  != 0)  && (currentAlbum[0]!='$') && (currentAlbum[0]!='.')){
          count++;
          if (strcmp (currentAlbum,albumname) == 0)  {
            entry.close();  
            dir.close();
             updateDisplay(false); 
            return count;
          }
        }
     } 
    entry.close(); 
   }
   dir.close();
  return 0;
}

void getNextAlbum(){
  SD.vwd()->rewind();
     File dir=SD.open("/");
    // File entry =  SD.open(currentAlbum);
   //  entry.close();
     
   while(true) {
   File entry =  dir.openNextFile();

     if (! entry) break;
     
     if (entry.isDirectory()) {
        entry.getName(currentAlbum,MAX_NAME_LEN+1);
        if ((strcmp(currentAlbum, "System Volume Information")  != 0) && (currentAlbum[0]!='$') && (currentAlbum[0]!='.')){
          entry.close();
          break;
        }
     } 
    entry.close(); 
   }
   dir.close();
}


void getSong(byte number){
  SD.vwd()->rewind();
   currentSong[0]=0;
   if (tracks[number-1].position==-1) {
    Serial.println(F("empty"));
    return;
   }
   
   byte count=0;
   File entry =  SD.open(currentAlbum);
   File entry2;// =  entry.openNextFile();
 //  while(true) {
// Serial.print("pos: ");
  //  Serial.println(tracks[number-1].position);
    
    entry.setpos(&tracks[number-1]);
    entry2 =  entry.openNextFile();
     if (! entry2)  {
      Serial.println(F("no open"));
       entry.close();
      return;
     }
   
        entry2.getName(filebuffer,MAX_NAME_LEN+1);
        if (isMP3(filebuffer))  strcpy(currentSong,filebuffer);
        entry2.close();

   entry.close();

   updateDisplay(true); 
}


bool isMP3(char *buff){
int len=strlen(buff);
if (buff[len-1]=='3') return true;
return false;
}

byte getTrackNumber(char *buff){
byte n1=buff[0];
byte n2=buff[1];
if ((n1>=48) && (n1<=57) && (n2>=48) && (n2<=57) ) return  (n1-48)*10+(n2-48);
else return 0;
}


byte getValidTrack(byte n){
byte count=0;
byte index=0;
while (index<numberTracks) {
   if (tracks[index].position!=-1) count++;
   if (count==n) return count+1;
   index++;
}
return numberTracks;
}



