"""
CAR STEREO LAMBDA FUNCTION
Allan Murray 2017

Uses ask-alexa-pykit framework Copyright Anjishnu Kumar 2015
https://github.com/anjishnu/ask-alexa-pykit 
"""

from ask import alexa
import json
import paho.mqtt.client as mqtt
from random import randint

#YOUR MQTT BROKER DETAILS HERE:
broker_address="ec2-XX-XXX-XXX-X.compute-1.amazonaws.com"
MQTT_user="username"
MQTT_password="password"

myArtists = {
"billy joel": "Billy Joel-52nd Street,Billy Joel-An Innocent Man,Billy Joel-Cold Spring Harbour",
"meat loaf": "Meat Loaf-Bat Out of Hell"
#MORE ARTISTS HERE......
#(Can paste from myArtists.txt generated by RenameMusic_1.0.py - Note: remove final ',')
# Note: Keys (first column) must be lowercase
	}

myAlbums = {
"52nd street": "Billy Joel-52nd Street",
"an innocent man": "Billy Joel-An Innocent Man",
"cold spring harbour": "Billy Joel-Cold Spring Harbour",
"bat out of hell": "Meat Loaf-Bat Out of Hell"
#MORE ALBUMS HERE....
#(Can paste from myAlbums.txt generated by RenameMusic_1.0.py - Note: remove final ',')
# Note: Keys (first column) must be lowercase
    }
	
myStations = {
"the hits": "97.4",
"mix": "98.2",
"radio hauraki": "99.0"
#MORE STATIONS HERE....
#(Station list as per listed in Arduino sketch - Note: different format for frequency)
# Note: Keys (first column) must be lowercase
    }
	
	
def lambda_handler(request_obj, context=None):
    '''
    This is the main function to enter to enter into this code.
    If you are hosting this code on AWS Lambda, this should be the entry point.
    Otherwise your server can hit this code as long as you remember that the
    input 'request_obj' is JSON request converted into a nested python object.
    '''

    metadata = {'user_name' : 'SomeRandomDude'} # add your own metadata to the request using key value pairs
    
    ''' inject user relevant metadata into the request if you want to, here.    
    e.g. Something like : 
    ... metadata = {'user_name' : some_database.query_user_name(request.get_user_id())}

    Then in the handler function you can do something like -
    ... return alexa.create_response('Hello there {}!'.format(request.metadata['user_name']))
    '''
    return alexa.route_request(request_obj, metadata)


@alexa.default()
def default_handler(request):
    """ The default handler gets invoked if no handler is set for a request type """ 
    return alexa.create_response(message="Car Stereo")

@alexa.request("LaunchRequest")
def launch_request_handler(request):
    ''' Handler for LaunchRequest '''
    return alexa.create_response(message="What would you like to listen to?")


@alexa.request("SessionEndedRequest")
def session_ended_request_handler(request):
    return alexa.create_response(message="OK")
					
								 
@alexa.intent('BluetoothToggleIntent')
def bluetooth_toggle_intent_handler(request):

    client = mqtt.Client("P1") #create new instance
    client.username_pw_set(MQTT_user, MQTT_password)
    client.connect(broker_address) #connect to broker
    client.publish("STEREO","BTH:")

    card = alexa.create_card(title="Toggle bluetooth", subtitle=None,content="asked alexa toggle bluetooth")
    
    return alexa.create_response("Bluetooth",end_session=True, card_obj=card)


@alexa.intent('PlayRadioIntent')
def play_radio_intent_handler(request):

    station = request.slots["StationName"].lower() 
    
    if station == None:
        return alexa.create_response("Could not find an station!")

    if station not in myStations:
        card = alexa.create_card(title="Tuning to station", subtitle=None,
                             content="Could not find station: {}".format(station))
        return alexa.create_response("Could not find station: {}".format(station), end_session=True, card_obj=card) 
    else:
        stationFreq= myStations[station]
    print(stationFreq)
    client = mqtt.Client("P1") #create new instance
    client.username_pw_set(MQTT_user, MQTT_password)
    client.connect(broker_address) #connect to broker
    client.publish("STEREO","FRQ:"+stationFreq)

    card = alexa.create_card(title="Tuning to station", subtitle=None,content="asked alexa tune station {}".format(station))
    
    return alexa.create_response("Tuning to {}".format(station),end_session=True, card_obj=card)


@alexa.intent('PlayAlbumIntent')
def play_album_intent_handler(request):

    album = request.slots["AlbumName"].lower()  
    
    if album == None:
        return alexa.create_response("Could not find an album!")

    if album not in myAlbums:
        if album in myArtists:
            albumNameList= myArtists[album].split(',')
            albumName=albumNameList[randint(0, len(albumNameList)-1)]
        else:
            card = alexa.create_card(title="Tuning to station", subtitle=None,
                         content="Could not find album: {}".format(album))
            return alexa.create_response("Could not find album: {}".format(album), end_session=True, card_obj=card) 
    else:
        albumName= myAlbums[album]
		
    client = mqtt.Client("P1") #create new instance
    client.username_pw_set(MQTT_user, MQTT_password)    
    client.connect(broker_address) #connect to broker
    client.publish("STEREO","ALB:"+albumName)

    card = alexa.create_card(title="Playing Album", subtitle=None,content="asked alexa play album {}".format(albumName))
    
    return alexa.create_response("Playing {}".format(albumName.replace("-",", ")), end_session=True, card_obj=card)

	
@alexa.intent('PlayArtistIntent')
def play_artist_intent_handler(request):

    artist = request.slots["ArtistName"].lower() 
	
    if artist == None:
        return alexa.create_response("Could not find an artist!")

    if artist not in myArtists:
        if artist in myAlbums:
            albumName= myAlbums[artist]
        else:
            card = alexa.create_card(title="Tuning to station", subtitle=None,
                         content="Could not find artist: {}".format(artist))
            return alexa.create_response("Could not find artist: {}".format(artist), end_session=True, card_obj=card) 
    else:
        albumNameList= myArtists[artist].split(',')
        albumName=albumNameList[randint(0, len(albumNameList)-1)]

    client = mqtt.Client("P1") #create new instance
    client.username_pw_set(MQTT_user, MQTT_password)    
    client.connect(broker_address) #connect to broker
    client.publish("STEREO","ALB:"+albumName)

    card = alexa.create_card(title="Playing Album", subtitle=None,content="asked alexa play album {}".format(albumName))
    
    return alexa.create_response("Playing {}".format(albumName.replace("-",", ")),end_session=True, card_obj=card)




