﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;


/*
 * Made by: Bram van Deventer (2013)
 * Info: Bram2202@gmail.com
 * 
 * Explanation: 
 * 
 *  BackEnd.SendData("R" + clr.R.ToString("D3"));
 *  
 *  BackEnd = Class
 *  SendData = Function in class
 *  clr =  Color
 *  R = Red color in CLR
 *  ToString("D3") =  convert a int to String, D3 = 3 digits (example 001)
 * 
 * 
 */



namespace ColorSender
{
    public partial class MainForm : Form
    {
        //variables
        private Color LastColor;
        private bool Connected, AUWhite, AUColor, Extra = false;

        public MainForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Load event
        /// </summary>
        private void Form1_Load(object sender, EventArgs e)
        {
            //Get list of all available  comports
            string[] COMports = SerialPort.GetPortNames();

            //Set list to ComboBox
            cbComPorts.DataSource = COMports;

            //Set default state
            AUWhite = false;
            AUColor = false;
        }

        /// <summary>
        /// If clicked on the Picturebox
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pbColors_Click(object sender, EventArgs e)
        {
            //Set last color
            LastColor = pbBefore.BackColor;
            pbAfter.BackColor = LastColor;

            //Get selected Color
            Color clr = ColorSender.BackEnd.Win32APICall.GetDesktop().GetPixel(MousePosition.X, MousePosition.Y);

            //Set Textfield text with color value
            lblRed.Text = clr.R.ToString();
            lblGreen.Text = clr.G.ToString();
            lblBlue.Text = clr.B.ToString();

            //Set color
            pbBefore.BackColor = clr;

            //if AUcolor (automactic send) then send colors
            if (AUColor)
            {
                BackEnd.SendData("R" + clr.R.ToString("D3")); //send Red
                BackEnd.SendData("G" + clr.G.ToString("D3")); //send Green
                BackEnd.SendData("B" + clr.B.ToString("D3")); //send Blue
                BackEnd.SendData("F001"); //send F001, this funcion wil SET the color on te lamp
            }

        }

        /// <summary>
        /// Set previous color
        /// </summary>
        private void pbAfter_Click(object sender, EventArgs e)
        {
            pbBefore.BackColor = pbAfter.BackColor;
        }

        /// <summary>
        /// On trackBar scroll event
        /// </summary>
        private void tBarWhite_Scroll(object sender, EventArgs e)
        {
            lblWhite.Text = tBarWhite.Value.ToString() + "%"; //Set text

            if (AUWhite) //IF AUWhite (auto white update) Send White value
                BackEnd.SendData("W" + tBarWhite.Value.ToString("D3")); //send White
        }


        /// <summary>
        /// Send ALL data
        /// </summary>
        private void btnSend_Click(object sender, EventArgs e)
        {
            Color clr = pbBefore.BackColor; //Get Color

            BackEnd.SendData("R" + clr.R.ToString("D3")); //Send Red
            BackEnd.SendData("G" + clr.G.ToString("D3")); //Send Green
            BackEnd.SendData("B" + clr.B.ToString("D3")); //Send Blue
            BackEnd.SendData("W" + tBarWhite.Value.ToString("D3")); //Send White
        }

        /// <summary>
        /// Connect Bluetooth  
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnComState_Click(object sender, EventArgs e)
        {
            string ComName = cbComPorts.SelectedItem.ToString(); //Get name out of Combobox

            if (Connected)
            { //if Connected, disconnect!
                lblConStat.Text = "Try to disconnected...";

                if (BackEnd.DisConnect()) //Disconnect 
                {
                    btnComState.Text = "Connect";
                    lblConStat.Text = "Disconnected...";
                    Connected = false;
                }

            }
            else
            {//if Disconnected, connect!
                lblConStat.Text = "Try to connect...";
                if (BackEnd.Connect(ComName)) //connect to 
                {
                    btnComState.Text = "Disconnect";
                    lblConStat.Text = "connected...";
                    Connected = true;
                }

            }
        }


        /// <summary>
        /// Send data
        /// </summary>
        /// <param name="Data">String of 4 digits</param>
        private void SendData(string Data)
        {
            pbSendStatus.Image = Properties.Resources.Help_icon; //change Image on try to send

            if (BackEnd.SendData(Data)) //SEND DATA
                pbSendStatus.Image = Properties.Resources.accept_icon; //if succeeded. Image is Green
            else
                pbSendStatus.Image = Properties.Resources.delete_icon; //if failed. Image is RED

        }

        /// <summary>
        /// if Checkbox value changed
        /// </summary>
        private void cbWhite_CheckedChanged(object sender, EventArgs e)
        {
            AUWhite = !AUWhite;
        }

        /// <summary>
        /// if Checkbox value changed
        /// </summary>
        private void cbColors_CheckedChanged(object sender, EventArgs e)
        {
            AUColor = !AUColor;
        }

        /// <summary>
        /// Get new list of Comports
        /// </summary>
        private void pbRefrech_Click(object sender, EventArgs e)
        {
            string[] COMports = SerialPort.GetPortNames();
            cbComPorts.DataSource = COMports;
        }

        /// <summary>
        /// Show Extra Opties
        /// </summary>
        private void btnExtra_Click(object sender, EventArgs e)
        {
            if (Extra)
            {
                this.Height = 505;
                Extra = !Extra;
            }
            else
            {
                this.Height = 630;
                Extra = !Extra;
            }

        }

        /// <summary>
        /// Send function FAST Strobe (F002)
        /// </summary>
        private void btnStrope_Click(object sender, EventArgs e)
        {
            BackEnd.SendData("F002");
        }

        /// <summary>
        /// Send function SLOW Strobe (F003)
        /// </summary>
        private void btnStropeSlow_Click(object sender, EventArgs e)
        {
            BackEnd.SendData("F003");
        }

        /// <summary>
        /// Send function Rainbow (F004)
        /// </summary>
        private void btnRainbow_Click(object sender, EventArgs e)
        {
            BackEnd.SendData("F004");
        }


        /// <summary>
        /// Send Command to STOP everything
        /// </summary>
        private void btnStop_Click(object sender, EventArgs e)
        {
            BackEnd.SendData("x000");
        }









    }
}
