﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing;
using System.IO.Ports;
using System.Threading;

namespace ColorSender
{
    class BackEnd
    {
        #region DLL Inports

        public static class Win32APICall
        {
            [DllImport("gdi32.dll", EntryPoint = "DeleteDC")]
            public static extern IntPtr DeleteDC(IntPtr hdc);

            [DllImport("gdi32.dll", EntryPoint = "DeleteObject")]
            public static extern IntPtr DeleteObject(IntPtr hObject);

            [DllImport("gdi32.dll", EntryPoint = "BitBlt")]
            public static extern bool BitBlt(IntPtr hdcDest, int nXDest,
                int nYDest, int nWidth, int nHeight, IntPtr hdcSrc,
                int nXSrc, int nYSrc, int dwRop);

            [DllImport("gdi32.dll", EntryPoint = "CreateCompatibleBitmap")]
            public static extern IntPtr CreateCompatibleBitmap(IntPtr hdc,
                int nWidth, int nHeight);

            [DllImport("gdi32.dll", EntryPoint = "CreateCompatibleDC")]
            public static extern IntPtr CreateCompatibleDC(IntPtr hdc);

            [DllImport("gdi32.dll", EntryPoint = "SelectObject")]
            public static extern IntPtr SelectObject(IntPtr hdc, IntPtr hgdiobjBmp);

            [DllImport("user32.dll", EntryPoint = "GetDesktopWindow")]
            public static extern IntPtr GetDesktopWindow();

            [DllImport("user32.dll", EntryPoint = "GetDC")]
            public static extern IntPtr GetDC(IntPtr hWnd);

            [DllImport("user32.dll", EntryPoint = "GetSystemMetrics")]
            public static extern int GetSystemMetrics(int nIndex);

            [DllImport("user32.dll", EntryPoint = "ReleaseDC")]
            public static extern IntPtr ReleaseDC(IntPtr hWnd, IntPtr hDC);

            public static Bitmap GetDesktop()
            {
                int screenX;
                int screenY;
                IntPtr hBmp;
                IntPtr hdcScreen = GetDC(GetDesktopWindow());
                IntPtr hdcCompatible = CreateCompatibleDC(hdcScreen);

                screenX = GetSystemMetrics(0);
                screenY = GetSystemMetrics(1);
                hBmp = CreateCompatibleBitmap(hdcScreen, screenX, screenY);

                if (hBmp != IntPtr.Zero)
                {
                    IntPtr hOldBmp = (IntPtr)SelectObject(hdcCompatible, hBmp);
                    BitBlt(hdcCompatible, 0, 0, screenX, screenY, hdcScreen, 0, 0, 13369376);

                    SelectObject(hdcCompatible, hOldBmp);
                    DeleteDC(hdcCompatible);
                    ReleaseDC(GetDesktopWindow(), hdcScreen);

                    Bitmap bmp = System.Drawing.Image.FromHbitmap(hBmp);

                    DeleteObject(hBmp);
                    GC.Collect();

                    return bmp;
                }

                return null;
            }
        }
        #endregion

        //Bluetooth Conection
        public static SerialPort BluetoothConnection;

        /// <summary>
        /// Open Conection
        /// </summary>
        /// <param name="ComName">Name of COMport</param>
        /// <returns>True = Connected, False  = Disconnected</returns>
        public static bool Connect(string ComName)
        {
            try
            {
                BluetoothConnection = new SerialPort(); 
                BluetoothConnection.PortName = ComName;  //Set name of Comport

                BluetoothConnection.BaudRate = 9600; //Set Baudrate, this is the Default value
                BluetoothConnection.Open();  //OPEN the conection
                BluetoothConnection.ReadTimeout = 1500; //set Read Timeout

                return true;
            }
            catch (Exception) { return false; }
        }

        /// <summary>
        /// Close Conection
        /// </summary>
        /// <returns>True = Disconnected, false = error</returns>
        internal static bool DisConnect()
        {
            try
            {
                BluetoothConnection.Close(); //Close the Connection
                return true;
            }
            catch (Exception) { return false; }
        }

        /// <summary>
        /// Send data
        /// </summary>
        /// <param name="Data">String to be send</param>
        /// <returns>if seding has worked wintout error</returns>
        public static bool SendData(string Data)
        {
            try
            {
                //Thread.Sleep(100);
                BluetoothConnection.Write(Data);  //Send the Data
                return true;
            }
            catch (Exception) { return false; }
        }


    }
}
