;**************************************************************************
; FILE:      bcard.asm                                                    *
; CONTENTS:  Auto dialling business card!                                 *
; COPYRIGHT: Public Domain                                                *
; AUTHOR:    Tom Ward                                                     *
; UPDATED:   10 Dec 2007                                                  *
;**************************************************************************

;     list p=10F202

     include "p10f202.inc"

     __config _WDT_OFF & _MCLRE_OFF & _CP_OFF

     __idlocs h'FFFF'

     errorlevel -305

;**************************************************************************
;                                                                         *
; Port assignments                                                        *
;                                                                         *
;**************************************************************************

GPIO_OUT  equ  b'0000'             ; I/O Directions when dialling
GPIO_IN   equ  b'0001'             ; I/O Directions when waiting for piezo signal
BUTTON    equ  3                   ; pushbutton
PIEZOPOS  equ  0
PIEZONEG  equ  2 
LED       equ  2

;**************************************************************************
;                                                                         *
; Constants and timings                                                   *
;                                                                         *
;**************************************************************************

F1H       equ  2				   ; 852Hz
F2H       equ  1                   ; 1209Hz
HI1OK	  equ  1
HI2OK     equ  2

;**************************************************************************
;                                                                         *
; File register usage                                                     *
;                                                                         *
;**************************************************************************

RAM  set  h'10'

     cblock RAM
     count1
	 counta
	 countb
     t0h
     t0l
     f1l
     f2l
     nxt1h
     nxt1l
     nxt2h
     nxt2l
     stat
	 lastt
     digitno
     RAM_
     endc

     if RAM_ > h'20'
     error "File register usage overflow"
     endif


;--------------------------------------------------------------------------
; reset vector (after wrapping around from 1ff
;--------------------------------------------------------------------------

           org 0

	       andlw ~1
           movwf OSCCAL

	       goto main_entry

;--------------------------------------------------------------------------
; Table for number to dial
;--------------------------------------------------------------------------

dialno		addwf PCL
			retlw 0
			retlw 7
			retlw 5
			retlw 1
			retlw 2
			retlw 1
			retlw 9
			retlw 1
			retlw 0
			retlw 1
			retlw 9
			retlw h'ff'
			return

;--------------------------------------------------------------------------
; Table for DTMF Tones
;--------------------------------------------------------------------------

freq1		addwf PCL
			retlw d'19'
			retlw d'205'
			retlw d'205'
			retlw d'205'
			retlw d'137'
			retlw d'137'
			retlw d'137'
			retlw d'75'
			retlw d'75'
			retlw d'75'
			return

freq2		addwf PCL
			retlw d'118'
			retlw d'158'
			retlw d'118'
			retlw d'83'
			retlw d'158'
			retlw d'118'
			retlw d'83'
			retlw d'158'
			retlw d'118'
			retlw d'83'
			return

;--------------------------------------------------------------------------
; main entry point
;--------------------------------------------------------------------------

main_entry

          	clrf GPIO                     ; initialise port

          	movlw b'01001111'             ; weak pull-ups disabled
          	option

            movlw GPIO_OUT
			tris GPIO          

			; Initial 250ms Deay
 			movlw d'250'
			call Delay

            movlw 0
            movwf digitno
            
dialloop    movf digitno,w
            call dialno
            xorlw h'ff' ; Test if end of no
            btfsc STATUS,Z
            goto gotosleep
            xorlw h'ff' ; Restore digit by xoring again

			call freq1
			movwf f1l
			movf digitno,w
            call dialno ; Restore digit again
			call freq2
			movwf f2l

        	call dialdigit

          	clrf GPIO ; turn all outputs off
			movlw d'65' ; 65ms inter-digit delay
			call Delay
            incf digitno,f
			goto dialloop

gotosleep   ; Quick and dirty way of pausing for 1 second before sleep to let ringing on piezo stop
            movlw d'250' 
			call Delay
 			movlw d'250'
			call Delay
 			movlw d'250'
			call Delay
 			movlw d'250'
			call Delay
        	movlw GPIO_IN
			tris GPIO
			sleep

dialdigit
			clrf TMR0
			clrf t0h
			clrf t0l
        	movlw F1H
        	movwf nxt1h
			movf  f1l,w
        	movwf nxt1l
        	movlw F2H
        	movwf nxt2h
			movf f2l,w
        	movwf nxt2l
            clrf lastt
			bcf stat,HI1OK
			bcf stat,HI2OK

loop		;t0l = tmr0
        	movf TMR0,w
			movwf t0l

			;if lastt>t0l then ( inc t0h | if t0h>=nxt1h then hi1ok=true (& same for hi2) )
			movf lastt,w
			subwf t0l,w
        	btfsc STATUS,C
        	goto step1a
        	;
            incf t0h,f
            btfsc STATUS,Z
            return
        	;
			movf t0h,w
			subwf nxt1h,w
			btfss STATUS,C
			goto overdue1        ; actually t0h>nxt1h so jump directly to piezo toggling ... possible bug if t0h rolls over?
			btfsc STATUS,Z
			bsf stat,HI1OK
            ;
			movf t0h,w
			subwf nxt2h,w
			btfss STATUS,C
			goto overdue2        ; actually t0h>nxt1h so jump directly to piezo toggling ... possible bug if t0h rolls over?
			btfsc STATUS,Z
			bsf stat,HI2OK

step1a		;if hi1ok and t0l>nxt1l then ( hi1ok = false  | nxt1+=period | toggle piezopos )
			btfss stat,HI1OK
        	goto step1b
        	movf t0l,w
        	subwf nxt1l,w
        	btfsc STATUS,C
        	goto step1b
overdue1   	bcf stat,HI1OK
        	movf f1l,w
        	addwf nxt1l,f
        	btfsc STATUS,C
        	incf nxt1h,f
        	movlw F1H
        	addwf nxt1h,f
        	btfss GPIO,PIEZOPOS
        	goto step2a
        	bcf GPIO,PIEZOPOS
        	goto step1b
step2a   	bsf GPIO,PIEZOPOS

step1b		;if hi2ok and t0l>nxt2l then ( hi2ok = false  | nxt2+=period | toggle piezoneg )
			btfss stat,HI2OK
        	goto step3
        	movf t0l,w
        	subwf nxt2l,w
        	btfsc STATUS,C
        	goto step3
overdue2   	bcf stat,HI2OK
        	movf f2l,w
        	addwf nxt2l,f
        	btfsc STATUS,C
        	incf nxt2h,f
        	movlw F2H
        	addwf nxt2h,f
        	btfss GPIO,PIEZONEG
        	goto step2b
        	bcf GPIO,PIEZONEG
        	goto step3
step2b   	bsf GPIO,PIEZONEG
		  
step3		;lastt = t01
        	movf t0l,w
        	movwf lastt

 		    goto loop
 
Delay		movwf count1
d1			movlw 0xc7
			movwf counta
			movlw 0x01
			movwf countb
Delay_0		decfsz counta,f
			goto $+2
			decfsz countb,f
			goto Delay_0
			decfsz count1,f
			goto d1
			retlw 0

            end
