

void draw() {
  if (!finished) {
    background(255);
     outerHexEdgeLength=4*hexTileEdgeLength;
    xPoints[0]=0;
  yPoints[0]=0;
    hexInset=roadWidth/(2*sin(hexHexAngle/2));
    if (panelWallsInside) {
      hexEdgeLength = (hexTileEdgeLength*sqrt(3)+4*borderWidth+2*stockThickness+2*tileHoleGap)/sqrt(3);
    }
    else {
      hexEdgeLength = (hexTileEdgeLength*sqrt(3)+2*borderWidth+2*stockThickness+2*tileHoleGap)/sqrt(3);
    }
    originalEdgeLength=((hexEdgeLength/tan(PI/6))+2*hexInset)/sqrt(3);
    pentRoadAngle=asin(hexInset*sin(hexPentAngle)/roadWidth);
    hexRoadAngle=PI-pentRoadAngle-hexPentAngle;
    pentInset=roadWidth*sin(hexRoadAngle)/sin(hexPentAngle);
    pentEdgeLength=originalEdgeLength-2*pentInset*tan(PI/5);
    originalHexGreaterRadius=originalEdgeLength;
    originalHexLesserRadius=originalEdgeLength*sqrt(3)/2;
    originalPentLesserRadius=originalEdgeLength/(2*tan(PI/5));
    originalPentGreaterRadius=originalEdgeLength/(2*sin(PI/5));
    pentRatio=pentEdgeLength/originalEdgeLength;
    hexRatio=hexEdgeLength/originalEdgeLength;
    newHexLesserRadius=originalHexLesserRadius*hexRatio;
    newHexGreaterRadius=originalHexGreaterRadius*hexRatio;
    newPentLesserRadius=originalPentLesserRadius*pentRatio;
    newPentGreaterRadius=originalPentGreaterRadius*pentRatio;
    cutHexRadius=(newHexLesserRadius-borderWidth)/cos(PI/6);
    tileHexRadius=(newHexLesserRadius-borderWidth-stockThickness-tileHoleGap)/cos(PI/6);
    cutPentRadius=(newPentLesserRadius-borderWidth)/cos(PI/5);
    tilePentRadius = (newPentLesserRadius-borderWidth-stockThickness-tileHoleGap)/cos(PI/5);
    interHexDist=2*newHexLesserRadius+roadWidth;
    trapSideLength=sqrt(pow(roadWidth, 2)+pow((hexEdgeLength-pentEdgeLength)/2, 2) );
    //println("Road width = " + roadWidth + ". Trap side length = " + trapSideLength + ".");
    trapSideRoadWidthAngle=acos(roadWidth/(2*trapSideLength));
    roadOverWidth=roadWidth*1;
    margin=roadWidth*2;
    netWidth=ceil((newHexGreaterRadius*2+roadOverWidth*2+hexEdgeLength)*5+newHexGreaterRadius-hexEdgeLength/2+2*margin);
    if (splitHalves) {
      netWidth+=splitDist;
    }
    netHeight=ceil(margin+ 9*newHexLesserRadius+4.5*roadWidth+2*newPentGreaterRadius+2*newPentLesserRadius+2*roadOverWidth+4*newHexLesserRadius+2*poleHolderHeight);
    output = createWriter("BuckyBallNet" + parseInt(hexEdgeLength) + "mm.svg");

    //output.println("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"  version=\"1.1\">");
    float expandedNetWidth = netWidth + hexTileEdgeLength*10;
    output.println("<svg height=\""+netHeight+"\" width=\""+expandedNetWidth+"\" xmlns=\"http://www.w3.org/2000/svg\">");


    //println(180*trapSideRoadWidthAngle/PI);
    //innerCutHexRadius=(cutHexRadius-holeDepth)/cos(PI/6);
    // innerCutPentRadius=(cutPentRadius-holeDepth)/cos(PI/5);
    println("New hexagon edge length = " + hexEdgeLength);
    println("New pentagon edge length = " + pentEdgeLength);
    println("Remember that tiles will need to be smaller than these sizes because of the " + borderWidth + "mm borders.");
    pushMatrix();

    metaTranslate(originalHexGreaterRadius+margin, margin+6*newHexLesserRadius+newPentLesserRadius+newPentGreaterRadius+4*roadOverWidth+4*roadWidth+2*holeDepth);
    toggleA[0]=1;
    toggleA[2]=1;
    toggleA[3]=1;
    toggleA[4]=1;
    toggleA[1]=2;
    toggleB[1]=1;
    toggleB[3]=1;
    toggleB[4]=1;
    drawStrip(1);
    metaTranslate(0, 0-interHexDist); //shift up and right
    metaTranslate(interHexDist*cos(PI/6), 0-interHexDist*sin(PI/6));
    toggleA[2]=0;
    toggleA[3]=0;
    toggleA[1]=0;
    toggleB[0]=2;
    drawStrip(3);
    metaTranslate(0, interHexDist);
    metaTranslate(interHexDist*cos(PI/6), interHexDist*sin(PI/6));
    toggleA[3]=1;
    toggleA[1]=2;
    toggleB[4]=0;
    toggleB[0]=0;
    drawStrip(3);
    metaTranslate(0, 0-interHexDist); //shift up and right
    metaTranslate(interHexDist*cos(PI/6), 0-interHexDist*sin(PI/6));
    toggleA[3]=0;
    toggleA[1]=0;
    toggleB[4]=1;
    toggleB[5]=1;
    toggleB[0]=2;
    if (splitHalves) {
      toggleA[1]=2;
    }
    drawStrip(2);
    if (splitHalves) {
      metaTranslate(splitDist, 0);
    }
    for (int p =0;p<3;p++) {
      metaTranslate(0, interHexDist);
      metaTranslate(interHexDist*cos(PI/6), interHexDist*sin(PI/6));
      toggleA[2]=1;
      toggleA[3]=1;
      toggleA[1]=2;
      toggleB[4]=1;
      toggleB[0]=0;
      toggleB[5]=0;
      drawStrip(1);
      metaTranslate(0, 0-interHexDist); //shift up and right
      metaTranslate(interHexDist*cos(PI/6), 0-interHexDist*sin(PI/6));
      toggleB[4]=0;
      toggleA[2]=0;
      toggleA[3]=0;
      if (p!=2) {
        toggleA[1]=0;
      }
      toggleB[4]=1;
      toggleB[5]=1;
      toggleB[0]=2;
      drawStrip(2);
    }
    popMatrix();
    xShift=0;
    yShift=0;
    pushMatrix();
    metaTranslate(6*newHexGreaterRadius, newHexLesserRadius-borderWidth+holeDepth+margin);
    drawPanel(5);
    metaTranslate(newPentGreaterRadius + newHexGreaterRadius+2*holeDepth+margin, 0);
    drawPanel(6);
    metaTranslate(2*newHexGreaterRadius+2*holeDepth, 0);
    setInk(cut);
    drawHex(tileHexRadius, cut);
    metaEllipse(cut, poleRadius, poleRadius);
    metaTranslate(2*newHexGreaterRadius, 0);
    drawHex(tileHexRadius, cut);
    metaEllipse(cut, poleRadius, poleRadius);
    metaTranslate(newPentGreaterRadius + newHexGreaterRadius, 0);
    drawSimplePolygon(cut, 5, tilePentRadius, 0);
    metaEllipse(cut, poleRadius, poleRadius);
    metaTranslate(2*newPentGreaterRadius, 0);
    drawSimplePolygon(cut, 5, tilePentRadius, 0);
    metaEllipse(cut, poleRadius, poleRadius);
    metaTranslate(2*newPentGreaterRadius, 0);
    drawSimplePolygon(cut, 5, tilePentRadius, 0);
    popMatrix();
    xShift=0;
    yShift=0;
    pushMatrix();
    metaTranslate(margin+2*newHexLesserRadius+poleHolderHeight, netHeight-(margin+2*newHexLesserRadius+poleHolderHeight));
    drawPoleHolder(6);
    metaTranslate(margin+4*newHexLesserRadius+2*poleHolderHeight, 0);
    drawPoleHolder(6);
    metaTranslate(margin+4*newHexLesserRadius+2*poleHolderHeight, 0);
    drawPoleHolder(5);
    metaTranslate(margin+4*newHexLesserRadius+2*poleHolderHeight, 0);
    drawPoleHolder(5);
    popMatrix();
    xShift=0;
    yShift=0;

    drawConnectors(1, 1);
    drawConnectors(18, 3);
    drawConnectors(40, 3);
    drawConnectors(62, 2);
    for (int p = 79;p<148;p+=34) {
      drawConnectors(p, 1);
      drawConnectors(p+17, 2);
    }
    setInk(cut);
    metaLine(currentInk, xPoints[7], yPoints[7], xPoints[22], yPoints[22]);
    metaLine(currentInk, xPoints[8], yPoints[8], xPoints[21], yPoints[21]);
    metaLine(currentInk, xPoints[19], yPoints[19], xPoints[51], yPoints[51]);
    metaLine(currentInk, xPoints[20], yPoints[20], xPoints[50], yPoints[50]);
    metaLine(currentInk, xPoints[46], yPoints[46], xPoints[66], yPoints[66]);
    metaLine(currentInk, xPoints[47], yPoints[47], xPoints[65], yPoints[65]);
    for (int p = 63;p<132;p+=34) {
      if (p!=63||!splitHalves) {
        metaLine(currentInk, xPoints[p], yPoints[p], xPoints[p+27], yPoints[p+27]);
        metaLine(currentInk, xPoints[p+1], yPoints[p+1], xPoints[p+26], yPoints[p+26]);
      }
      metaLine(currentInk, xPoints[p+22], yPoints[p+22], xPoints[p+37], yPoints[p+37]);
      metaLine(currentInk, xPoints[p+23], yPoints[p+23], xPoints[p+36], yPoints[p+36]);
    }
    noFill();
    rect(2, 2, expandedNetWidth, netHeight);
    makeBase();
    float textx=expandedNetWidth-margin;
    float texty=netHeight-margin;
    output.println("<text x=\""+textx+"\" y=\""+texty+"\" fill=\"black\" text-anchor=\"end\" font-size=\""+int(roadWidth*4)+"\">"+expandedNetWidth+" by "+ netHeight+"</text>");
    output.println("<rect x=\"0\" y=\"0\" width=\""+expandedNetWidth+"\" height=\""+netHeight+"\"  fill=\"none\" stroke=\"black\" stroke-width=\""+strokeWidth+"\" />");

    output.println("</svg>");
    output.flush();
    output.close();


    finished=true;
  }
}

void makeBase() {
  float[] x = new float[4];
  float[] y = new float[4];
  pushMatrix();
  metaTranslate(netWidth+margin, margin);
  setInk(cut);
  metaLine(currentInk, 0, 0, 0, baseHeight);


  setInk(score);
  metaLine(currentInk, 0, 0, outerHexEdgeLength, 0);
  metaLine(currentInk, outerHexEdgeLength, 0, outerHexEdgeLength, baseHeight);
  setInk(cut);
  metaLine(currentInk, 0+tabWidth/tan(PI/3), 0-tabWidth, outerHexEdgeLength-tabWidth/tan(PI/3), 0-tabWidth);
  metaLine(currentInk, 0+tabWidth/tan(PI/3), 0-tabWidth, 0, 0);
  metaLine(currentInk, outerHexEdgeLength, 0, outerHexEdgeLength-tabWidth/tan(PI/3), 0-tabWidth);

  metaLine(currentInk, outerHexEdgeLength, 0, outerHexEdgeLength+tabWidth, 0);
  metaLine(currentInk, outerHexEdgeLength, baseHeight, outerHexEdgeLength+tabWidth, baseHeight);
  metaLine(currentInk, outerHexEdgeLength+tabWidth, 0, outerHexEdgeLength+tabWidth, baseHeight);
  metaTranslate(0, baseHeight);

  float baseTriangleHeight = outerHexEdgeLength*sqrt(3)/2;
  float baseTrapHeight=baseTriangleHeight-hexTileEdgeLength*sqrt(3)/2;
  float pieceHeight=baseTrapHeight/cos(slantAngle);
  x[0]=0;
  y[0]=0;
  x[1]=outerHexEdgeLength;
  y[1]=0;
  x[2]=(outerHexEdgeLength+hexTileEdgeLength)/2;
  y[2]=pieceHeight;
  x[3]=(outerHexEdgeLength-hexTileEdgeLength)/2;
  y[3]=pieceHeight;
  setInk(score);
  for (int n = 0;n<x.length;n++) {
    if (n==3) {
      setInk(cut);
    }
    metaLine(currentInk, x[n], y[n], x[(n+1)%x.length], y[(n+1)%x.length]);
  }

  metaLine(currentInk, x[3]+tabWidth/tan(PI/3), y[3]+tabWidth, x[2]-tabWidth/tan(PI/3), y[2]+tabWidth);
  metaLine(currentInk, x[3]+tabWidth/tan(PI/3), y[3]+tabWidth, x[3], y[3]);
  metaLine(currentInk, x[2]-tabWidth/tan(PI/3), y[2]+tabWidth, x[2], y[2]);

  baseCornerAngle=atan2(y[3], x[3]);

  float xd1=x[1]-tabWidth*cos(baseCornerAngle+PI/3);
  float yd1=y[1]+tabWidth*sin(baseCornerAngle+PI/3);
  float xd2=x[2]-tabWidth*cos(baseCornerAngle+2*PI/3);
  float yd2=y[2]+tabWidth*sin(baseCornerAngle+2*PI/3);

  metaLine(currentInk, xd1, yd1, xd2, yd2);
  metaLine(currentInk, xd1, yd1, x[1], y[1]);
  metaLine(currentInk, xd2, yd2, x[2], y[2]);

  x[0]=baseBorderWidth/tan(baseCornerAngle)+baseBorderWidth/sin(baseCornerAngle);
  y[0]=baseBorderWidth;
  x[1]=outerHexEdgeLength-baseBorderWidth/tan(baseCornerAngle)-baseBorderWidth/sin(baseCornerAngle);
  y[1]=baseBorderWidth;
  x[2]=(outerHexEdgeLength+hexTileEdgeLength)/2+baseBorderWidth/tan(baseCornerAngle)-baseBorderWidth/sin(baseCornerAngle);
  y[2]=pieceHeight-baseBorderWidth;
  x[3]=(outerHexEdgeLength-hexTileEdgeLength)/2-baseBorderWidth/tan(baseCornerAngle)+baseBorderWidth/sin(baseCornerAngle);
  y[3]=pieceHeight-baseBorderWidth;
  setInk(score);
  for (int n = 0;n<x.length;n++) {
    metaLine(currentInk, x[n], y[n], x[(n+1)%x.length], y[(n+1)%x.length]);
  }
  float[] xb=new float[4];
  float[] yb=new float[4];
  xb[0]=x[0]+baseHoleDepth/tan(baseCornerAngle)+baseHoleDepth/sin(baseCornerAngle);
  yb[0]=y[0]+baseHoleDepth;
  xb[1]=x[1]-(baseHoleDepth/tan(baseCornerAngle)+baseHoleDepth/sin(baseCornerAngle));
  yb[1]=y[1]+baseHoleDepth;
  xb[2]=x[2]-(baseHoleDepth/sin(baseCornerAngle)-baseHoleDepth/tan(baseCornerAngle));
  yb[2]=y[2]-baseHoleDepth;
  xb[3]=x[3]+baseHoleDepth/sin(baseCornerAngle)-baseHoleDepth/tan(baseCornerAngle);
  yb[3]=y[3]-baseHoleDepth;
  setInk(cut);
  for (int n = 0;n<x.length;n++) {
    metaLine(currentInk, xb[n], yb[n], xb[(n+1)%x.length], yb[(n+1)%x.length]);
    metaLine(currentInk, x[n], y[n], xb[n], yb[n]);
  } 
  metaTranslate(outerHexEdgeLength+baseHoleDepth*3, 0);  
  setInk(score);
  for (int n = 0;n<x.length;n++) {
    metaLine(currentInk, x[n], y[n], x[(n+1)%x.length], y[(n+1)%x.length]);
  }
  float[] xc=new float[8];
  float[] yc=new float[8];
  xc[0]=x[0];
  yc[0]=y[0]-baseHoleDepth;
  xc[1]=x[1];
  yc[1]=y[1]-baseHoleDepth;
  xc[2]=x[1]-baseHoleDepth*cos(baseCornerAngle+PI/2);
  yc[2]=y[1]+baseHoleDepth*sin(baseCornerAngle+PI/2);
  xc[3]=x[2]-baseHoleDepth*cos(baseCornerAngle+PI/2);
  yc[3]=y[2]+baseHoleDepth*sin(baseCornerAngle+PI/2);
  xc[4]=x[2];
  yc[4]=y[2]+baseHoleDepth;
  xc[5]=x[3];
  yc[5]=y[3]+baseHoleDepth;
  xc[6]=x[3]+baseHoleDepth*cos(baseCornerAngle+PI/2);
  yc[6]=y[3]+baseHoleDepth*sin(baseCornerAngle+PI/2);
  xc[7]=x[0]+baseHoleDepth*cos(baseCornerAngle+PI/2);
  yc[7]=y[0]+baseHoleDepth*sin(baseCornerAngle+PI/2);
  setInk(cut);
  for (int n = 0;n<xc.length;n+=2) {
    metaLine(currentInk, xc[n], yc[n], xc[(n+1)%xc.length], yc[(n+1)%xc.length]);
    metaLine(currentInk, xc[n], yc[n], x[n/2], y[n/2]);
    metaLine(currentInk, xc[n+1], yc[n+1], x[(n/2+1)%4], y[(n/2+1)%4]);
  }
  metaTranslate(margin+outerHexEdgeLength-outerHexEdgeLength-baseHoleDepth*3-margin, pieceHeight+outerHexEdgeLength*sqrt(3)/2+2*baseHoleDepth+2*tabWidth+margin);  
  setInk(cut);
  drawHex(outerHexEdgeLength, cut);
  setInk(score);
  metaEllipse(currentInk, poleRadius, poleRadius);

  drawHex(cutHexRadius, score);
  //drawPoleHolder(6);
  popMatrix();
}

void metaLine(color pen, float xa, float ya, float xb, float yb) {
  setInk(pen);
  strokeWeight(strokeWidth);
  line(xa, ya, xb, yb);
  xa+=xShift;
  xb+=xShift;
  ya+=yShift;
  yb+=yShift;
  int r = parseInt(red(currentInk));
  int g = parseInt(green(currentInk));
  int b = parseInt(blue(currentInk));
  output.println("<line x1=\""+xa+"\" y1=\""+ya+"\" x2=\""+xb+"\" y2=\""+yb+"\" style=\"stroke:rgb("+r+","+g+","+b+");stroke-width:"+strokeWidth+"\" /> ");
}
void drawConnectors(int n, int pentSettings) {
  setInk(cut);
  metaLine(currentInk, xPoints[n+5], yPoints[n+5], xPoints[n+9], yPoints[n+9]);
  metaLine(currentInk, xPoints[n], yPoints[n], xPoints[n+8], yPoints[n+8]);
  /*
  if (pentSettings==1) {
   metaLine(currentInk,xPoints[n+11], yPoints[n+11], xPoints[n+15], yPoints[n+15]);
   metaLine(currentInk,xPoints[n+6], yPoints[n+6], xPoints[n+14], yPoints[n+14]);
   }
   else if (pentSettings==2) {
   metaLine(currentInk,xPoints[n+2], yPoints[n+2], xPoints[n+15], yPoints[n+15]);
   metaLine(currentInk,xPoints[n+3], yPoints[n+3], xPoints[n+14], yPoints[n+14]);
   }
   else if (pentSettings==3) {
   metaLine(currentInk,xPoints[n+11], yPoints[n+11], xPoints[n+15], yPoints[n+15]);
   metaLine(currentInk,xPoints[n+6], yPoints[n+6], xPoints[n+14], yPoints[n+14]);
   metaLine(currentInk,xPoints[n+2], yPoints[n+2], xPoints[n+20], yPoints[n+20]);
   metaLine(currentInk,xPoints[n+3], yPoints[n+3], xPoints[n+19], yPoints[n+19]);
   }*/
}
void metaTranslate(float xin, float yin) {
  translate(xin, yin);
  xShift+=xin;
  yShift+=yin;
}

void metaEllipse(color pen, float rada, float radb) {
  setInk(pen);
  ellipse(0, 0, rada*2, radb*2); 
  int r = parseInt(red(currentInk));
  int g = parseInt(green(currentInk));
  int b = parseInt(blue(currentInk));
  output.println("<ellipse cx=\""+xShift+"\" cy=\""+yShift+"\" rx=\""+rada+"\" ry=\""+radb+"\" style=\"fill:none;stroke:rgb("+r+","+g+","+b+");stroke-width:"+strokeWidth+"\" />");
}
void drawStrip(int pentSettings) { //0 = no pents, 1 = top pent, 2 = bottom pent, 3 = both pents.
  if (showOriginals) {
    drawRegularPolygon(6, originalHexGreaterRadius, sketch, PI/6);
  }
  drawModdedHex(newHexGreaterRadius, toggleA);
  drawHolePolygon(6, cutHexRadius, PI/6);
  metaTranslate(0, 0-2*newHexLesserRadius-roadWidth);
  if (showOriginals) {
    drawRegularPolygon(6, originalHexGreaterRadius, sketch, PI/6);
  }
  drawModdedHex(newHexGreaterRadius, toggleB);
  drawHolePolygon(6, cutHexRadius, PI/6);
  if (pentSettings==1) {
    metaTranslate(0, 0-newHexLesserRadius-newPentLesserRadius-roadWidth);
    if (showOriginals) { 
      drawRegularPolygon(5, originalPentGreaterRadius, sketch, 0);
    }
    drawRegularPolygon(5, newPentGreaterRadius, score, 0);
    if (firstPentagon) {
      drawSimplePolygon(cut, 5, cutPentRadius, 0);
      //drawRegularPolygon(5, cutPentRadius, cut, 0);
      firstPentagon=false;
    }
    else {
      drawHolePolygon(5, cutPentRadius, 0);
    }
    metaTranslate(0, 3*newHexLesserRadius+newPentLesserRadius+2*roadWidth);
  }
  else if (pentSettings==2) {
    metaTranslate(0, 3*newHexLesserRadius+newPentLesserRadius+2*roadWidth);
    if (showOriginals) {
      drawRegularPolygon(5, originalPentGreaterRadius, sketch, PI);
    }
    drawRegularPolygon(5, newPentGreaterRadius, score, PI);
    drawHolePolygon(5, cutPentRadius, PI);
    metaTranslate(0, 0-newHexLesserRadius-newPentLesserRadius-roadWidth);
  } 
  else if (pentSettings==3) {
    metaTranslate(0, 0-newHexLesserRadius-newPentLesserRadius-roadWidth);
    if (showOriginals) {
      drawRegularPolygon(5, originalPentGreaterRadius, sketch, 0);
    }
    drawRegularPolygon(5, newPentGreaterRadius, score, 0);
    drawHolePolygon(5, cutPentRadius, 0);
    metaTranslate(0, 3*newHexLesserRadius+newPentLesserRadius+2*roadWidth);
    metaTranslate(0, newHexLesserRadius+newPentLesserRadius+roadWidth);
    if (showOriginals) {
      drawRegularPolygon(5, originalPentGreaterRadius, sketch, PI);
    }
    drawRegularPolygon(5, newPentGreaterRadius, score, PI);
    drawHolePolygon(5, cutPentRadius, PI);
    metaTranslate(0, 0-newHexLesserRadius-newPentLesserRadius-roadWidth);
  }
}

void drawHex(float greaterRadius, color ink) {
  float[] x=new float[6];
  float[] y=new float[6];
  x[0]=0-greaterRadius/2;
  x[1]=greaterRadius/2;
  x[2]=greaterRadius;
  x[3]=x[1];
  x[4]=x[0];
  x[5]=0-greaterRadius;
  y[0]=0-greaterRadius*cos(PI/6);
  y[1]=y[0];
  y[2]=0;
  y[3]=0-y[0];
  y[4]=y[3];
  y[5]=0;

  setInk(ink);
  for (int n = 0;n<6;n++) {
    metaLine(currentInk, x[n], y[n], x[(n+1)%6], y[(n+1)%6]);
  }
}
void drawPanel(int sides) {
  setInk(score);
  line(0,5,0,-5);
  line(-5,0,5,0);
  float radShift=0;
  float greaterRadius=0;
  if (sides==6) {
    if (panelWallsInside) {
      radShift=(borderWidth+2*stockThickness)*newHexGreaterRadius/newHexLesserRadius;
    }
    else {
      radShift=(borderWidth)*newHexGreaterRadius/newHexLesserRadius;
    }
    greaterRadius = newHexGreaterRadius-radShift;
  } 
  else if (sides==5) {
    if (panelWallsInside) {
      radShift=(borderWidth+2*stockThickness)*newPentGreaterRadius/newPentLesserRadius;
    } 
    else {
      radShift=(borderWidth)*newPentGreaterRadius/newPentLesserRadius;
    }
    greaterRadius = newPentGreaterRadius-radShift;
  }

  float[] x=new float[sides];
  float[] y=new float[sides];
  for (int n= 0;n<sides;n++) {
    x[n]=greaterRadius*sin(2*PI*n/sides+PI/sides);
    y[n]=0-greaterRadius*cos(2*PI*n/sides+PI/sides);
  }
  for (int n = 0;n<sides;n++) {

    setInk(cut);
    float xPointA, xPointB, yPointA, yPointB;
    float edgeAngle = atan2(y[(n+1)%sides]-y[n], x[(n+1)%sides]-x[n])-PI/2;

    xPointA=x[n]+holeDepth*cos(edgeAngle);
    xPointB=x[(n+1)%sides]+holeDepth*cos(edgeAngle);
    yPointA=y[n]+holeDepth*sin(edgeAngle);
    yPointB=y[(n+1)%sides]+holeDepth*sin(edgeAngle);
    metaLine(currentInk, xPointA, yPointA, xPointB, yPointB);
    metaLine(currentInk, xPointA, yPointA, x[n], y[n]);
    metaLine(currentInk, x[(n+1)%sides], y[(n+1)%sides], xPointB, yPointB);

    setInk(score);

    metaLine(currentInk, x[n], y[n], x[(n+1)%sides], y[(n+1)%sides]);
  }
}

void drawPoleHolder(int sides) {
  metaEllipse(cut, poleRadius, poleRadius);
  float radShift=0;
  float greaterRadius=0;
   float lesserRadius=0;
  if (sides==6) {
    if (panelWallsInside) {
      radShift=(borderWidth+2*stockThickness)*newHexGreaterRadius/newHexLesserRadius;
    }
    else {
      radShift=(borderWidth)*newHexGreaterRadius/newHexLesserRadius;
    }
    greaterRadius = newHexGreaterRadius-radShift;
    lesserRadius = greaterRadius * newHexLesserRadius/newHexGreaterRadius;
  } 
  else if (sides==5) {
    
    if (panelWallsInside) {
      radShift=(borderWidth+2*stockThickness)*newPentGreaterRadius/newPentLesserRadius;
    } 
    else {
      radShift=(borderWidth)*newPentGreaterRadius/newPentLesserRadius;
    }
    greaterRadius = newPentGreaterRadius-radShift;
    lesserRadius = greaterRadius * newPentLesserRadius/newPentGreaterRadius;
  }

  float[] x=new float[sides];
  float[] y=new float[sides];
  for (int n= 0;n<sides;n++) {
    x[n]=greaterRadius*sin(2*PI*n/sides+PI/sides);
    y[n]=0-greaterRadius*cos(2*PI*n/sides+PI/sides);
  }
  for (int n = 0;n<sides;n++) {
   

      float xPointA, xPointB, yPointA, yPointB;
      float xPointC, yPointC;
      xPointC=(lesserRadius+poleHolderHeight+ greaterRadius*cos(PI/sides))*sin(2*PI*n/sides+(2*PI/sides));
      yPointC=0-(lesserRadius+poleHolderHeight+ greaterRadius*cos(PI/sides))*cos(2*PI*n/sides+(2*PI/sides));
      float edgeAngle = atan2(y[(n+1)%sides]-y[n], x[(n+1)%sides]-x[n])-PI/2;

      xPointA=x[n]+poleHolderHeight*cos(edgeAngle);
      xPointB=x[(n+1)%sides]+poleHolderHeight*cos(edgeAngle);
      yPointA=y[n]+poleHolderHeight*sin(edgeAngle);
      yPointB=y[(n+1)%sides]+poleHolderHeight*sin(edgeAngle);
      float xPointD, yPointD, xPointE, yPointE;
      float slideFraction =1-( poleRadius / (greaterRadius*cos(PI/sides)));
      xPointD=xPointA+slideFraction*(xPointC-xPointA);
      yPointD=yPointA+slideFraction*(yPointC-yPointA);
      xPointE=xPointB+slideFraction*(xPointC-xPointB);
      yPointE=yPointB+slideFraction*(yPointC-yPointB);
      setInk(score);
      metaLine(currentInk, xPointA, yPointA, xPointB, yPointB);
      metaLine(currentInk, xPointD, yPointD, xPointE, yPointE);
      setInk(cut);
      metaLine(currentInk, xPointA, yPointA, x[n], y[n]);
      metaLine(currentInk, x[(n+1)%sides], y[(n+1)%sides], xPointB, yPointB);
      metaLine(currentInk, xPointA, yPointA, xPointC, yPointC);
      metaLine(currentInk, xPointC, yPointC, xPointB, yPointB);

      setInk(score);

      metaLine(currentInk, x[n], y[n], x[(n+1)%sides], y[(n+1)%sides]);
    }
  }

  void drawModdedHex(float greaterRadius, int[] edgeType) {
    float[] x=new float[6];
    float[] y=new float[6];
    for (int n= 0;n<6;n++) {
      x[n]=greaterRadius*sin(2*PI*n/6+PI/6);
      float[] tempPoints = (float[]) append( xPoints, xShift+ x[n]);
      xPoints=tempPoints;
      y[n]=0-greaterRadius*cos(2*PI*n/6+PI/6);
      float[] tempPoints2 = (float[]) append( yPoints, yShift+ y[n]);
      yPoints=tempPoints2;
    }
    for (int n = 0;n<6;n++) {
      if (edgeType[n]==1) {
        setInk(cut);
      }
      else if (edgeType[n]==0) {
        setInk(score);
      }
      else if (edgeType[n]==2) {
        setInk(cut);
        float xPointA, xPointB, yPointA, yPointB;
        if (n==0) {
          xPointA=x[0]+roadWidth*cos(PI/6);
          xPointB=x[1]+roadWidth*cos(PI/6);
          yPointA=y[0]-roadWidth*sin(PI/6);
          yPointB=y[1]-roadWidth*sin(PI/6);
          metaLine(currentInk, xPointA, yPointA, xPointB, yPointB);
          metaLine(currentInk, xPointA, yPointA, x[0], y[0]);
          metaLine(currentInk, x[1], y[1], xPointB, yPointB);
        } 
        else if (n==1) {
          xPointA=x[1]+roadWidth*cos(PI/6);
          xPointB=x[2]+roadWidth*cos(PI/6);
          yPointA=y[1]+roadWidth*sin(PI/6);
          yPointB=y[2]+roadWidth*sin(PI/6);
          metaLine(currentInk, xPointA, yPointA, xPointB, yPointB);
          metaLine(currentInk, xPointA, yPointA, x[1], y[1]);
          metaLine(currentInk, x[2], y[2], xPointB, yPointB);
        }
        setInk(score);
      }
      metaLine(currentInk, x[n], y[n], x[(n+1)%6], y[(n+1)%6]);
    }
  }

  void drawOverlappingHex(float greaterRadius, color ink) {
    float[] x=new float[6];
    float[] y=new float[6];
    x[0]=0-greaterRadius/2;
    x[1]=greaterRadius/2;
    x[2]=greaterRadius;
    x[3]=x[1];
    x[4]=x[0];
    x[5]=0-greaterRadius;
    y[0]=0-greaterRadius*cos(PI/6);
    y[1]=y[0];
    y[2]=0;
    y[3]=0-y[0];
    y[4]=y[3];
    y[5]=0;

    setInk(ink);
    for (int n = 0;n<6;n++) {
      if (n!=2&&n!=4) {
        metaLine(currentInk, x[n], y[n], x[(n+1)%6], y[(n+1)%6]);
      }
    }
  }
  void drawSimplePentagon(float greaterRadius) {
    float[] x=new float[5];
    float[] y=new float[5];
    for (int n= 0;n<5;n++) {

      x[n]=greaterRadius*sin(2*PI*n/5); 
      y[n]=0-greaterRadius*cos(2*PI*n/5);
    }
    for (int n= 0;n<5;n++) {
      metaLine(currentInk, x[n], y[n], x[(n+1)%5], y[(n+1)%5]);
    }
  }
  void drawRegularPolygon(int sides, float greaterRadius, color ink, float rotation) {
    float[] x=new float[sides];
    float[] y=new float[sides];
    boolean skip = false;
    boolean skipTriangle = false;
    for (int n= 0;n<sides;n++) {

      x[n]=greaterRadius*sin(2*PI*n/sides+rotation);
      if (ink!=sketch) {
        float[] tempPoints = (float[]) append( xPoints, xShift+ x[n]);
        xPoints=tempPoints;
      }

      y[n]=0-greaterRadius*cos(2*PI*n/sides+rotation);
      if (ink!=sketch) {
        float[] tempPoints2 = (float[]) append( yPoints, yShift+ y[n]);
        yPoints=tempPoints2;
      }
    }

    if (ink!=sketch&&sides==5) {

      for (int n= 0;n<sides;n++) {
        skip = false;
        skipTriangle=false;

        if (n==0 && x[0]==0) {
          skip=true;
        }
        if (n==1 && x[0]==0) {
          skipTriangle=true;
        }
        if (n==2&&x[0]!=0) {
          skip=true;
        }
        if (n==3 && x[0]!=0) {
          skipTriangle=true;
        }

        float tempAngle=PI/5+n*PI/2.5;
        if (x[0]==0) {
          tempAngle=n*PI/2.5;
        }

        float xMidPoint = (newPentLesserRadius+roadWidth)*sin(tempAngle);
        float yMidPoint = (newPentLesserRadius+roadWidth)*cos(tempAngle);
        float xPointA= xMidPoint + cos(tempAngle)*hexEdgeLength/2;
        float yPointA= yMidPoint - sin(tempAngle)*hexEdgeLength/2;
        float xPointB= xMidPoint - cos(tempAngle)*hexEdgeLength/2;
        float yPointB= yMidPoint + sin(tempAngle)*hexEdgeLength/2;
        setInk(cut);
        if (!skip) {
          metaLine(currentInk, xPointA, yPointA, xPointB, yPointB);
        }
        if (x[0]==0) {
          if (!skip) {
            setInk(cut);
            metaLine(currentInk, xPointA, yPointA, x[(7-n)%5], y[(7-n)%5]);
            if (!skipTriangle) {
              setInk(score);
            }
            metaLine(currentInk, xPointB, yPointB, x[(8-n)%5], y[(8-n)%5]);
          } 
          else {
            setInk(score);
            metaLine(currentInk, xPointA, yPointA, x[(7-n)%5], y[(7-n)%5]);
            metaLine(currentInk, xPointB, yPointB, x[(8-n)%5], y[(8-n)%5]);
          }
          if (!skipTriangle) {
            float xPointC=x[(8-n)%5];
            float yPointC=y[(8-n)%5];
            float gamma = atan2(yPointC-yPointB, xPointC-xPointB);
            //gamma=gamma-trapSideRoadWidthAngle;
            gamma=gamma+PI/2-trapSideRoadWidthAngle;
            float xPointD=xPointB+roadWidth*sin(gamma);
            float yPointD=yPointB-roadWidth*cos(gamma);
            setInk(cut);
            metaLine(currentInk, xPointB, yPointB, xPointD, yPointD);
            setInk(cut);
            metaLine(currentInk, xPointC, yPointC, xPointD, yPointD);
          }
          if (skip) {
            float xPointC=x[(7-n)%5];
            float yPointC=y[(7-n)%5];
            float gamma = atan2(yPointC-yPointA, xPointC-xPointA);
            //gamma=gamma-trapSideRoadWidthAngle;
            gamma=gamma+PI/2+trapSideRoadWidthAngle;
            float xPointD=xPointA+roadWidth*sin(gamma);
            float yPointD=yPointA-roadWidth*cos(gamma);
            setInk(cut);
            metaLine(currentInk, xPointA, yPointA, xPointD, yPointD);
            setInk(cut);
            metaLine(currentInk, xPointC, yPointC, xPointD, yPointD);
          }
        } 
        else {
          if (!skip) {
            setInk(cut);
            metaLine(currentInk, xPointA, yPointA, x[(9-n)%5], y[(9-n)%5]);
            if (!skipTriangle) {
              setInk(score);
            }
            metaLine(currentInk, xPointB, yPointB, x[(5-n)%5], y[(5-n)%5]);
          } 
          else {
            setInk(score);
            metaLine(currentInk, xPointA, yPointA, x[(9-n)%5], y[(9-n)%5]);
            metaLine(currentInk, xPointB, yPointB, x[(5-n)%5], y[(5-n)%5]);
          }
          if (!skipTriangle) {
            float xPointC=x[(5-n)%5];
            float yPointC=y[(5-n)%5];
            float gamma = atan2(yPointC-yPointB, xPointC-xPointB);
            //gamma=gamma-trapSideRoadWidthAngle;
            gamma=gamma+PI/2-trapSideRoadWidthAngle;
            float xPointD=xPointB+roadWidth*sin(gamma);
            float yPointD=yPointB-roadWidth*cos(gamma);
            setInk(cut);
            metaLine(currentInk, xPointB, yPointB, xPointD, yPointD);
            setInk(cut);
            metaLine(currentInk, xPointC, yPointC, xPointD, yPointD);
          }
          if (skip) {
            float xPointC=x[(9-n)%5];
            float yPointC=y[(9-n)%5];
            float gamma = atan2(yPointC-yPointA, xPointC-xPointA);
            //gamma=gamma-trapSideRoadWidthAngle;
            gamma=gamma+PI/2+trapSideRoadWidthAngle;
            float xPointD=xPointA+roadWidth*sin(gamma);
            float yPointD=yPointA-roadWidth*cos(gamma);
            setInk(cut);
            metaLine(currentInk, xPointA, yPointA, xPointD, yPointD);
            setInk(cut);
            metaLine(currentInk, xPointC, yPointC, xPointD, yPointD);
          }
        }
      }
    }


    setInk(ink);
    for (int n = 0;n<sides;n++) {
      metaLine(currentInk, x[n], y[n], x[(n+1)%sides], y[(n+1)%sides]);
    }
  }

  void drawHolePolygon(int sides, float greaterRadius, float rotation) {
    float innerRadius=greaterRadius*(greaterRadius*cos(PI/sides)-holeDepth)/(greaterRadius*cos(PI/sides));
    float[] x=new float[sides];
    float[] y=new float[sides];
    float[] ix=new float[sides];
    float[] iy=new float[sides];
    for (int n= 0;n<sides;n++) {
      x[n]=greaterRadius*sin(2*PI*n/sides+rotation);
      y[n]=0-greaterRadius*cos(2*PI*n/sides+rotation);
      ix[n]=innerRadius*sin(2*PI*n/sides+rotation);
      iy[n]=0-innerRadius*cos(2*PI*n/sides+rotation);
    }

    setInk(score);
    for (int n = 0;n<sides;n++) {
      metaLine(currentInk, x[n], y[n], x[(n+1)%sides], y[(n+1)%sides]);
    }
    setInk(cut);
    for (int n = 0;n<sides;n++) {
      metaLine(currentInk, ix[n], iy[n], ix[(n+1)%sides], iy[(n+1)%sides]);
      metaLine(currentInk, ix[n], iy[n], x[n], y[n]);
    }
  }

  void drawSimplePolygon(color pen, int sides, float greaterRadius, float rotation) {
    float[] x=new float[sides];
    float[] y=new float[sides];

    for (int n= 0;n<sides;n++) {
      x[n]=greaterRadius*sin(2*PI*n/sides+rotation);
      y[n]=0-greaterRadius*cos(2*PI*n/sides+rotation);
    }

    setInk(pen);
    for (int n = 0;n<sides;n++) {
      metaLine(currentInk, x[n], y[n], x[(n+1)%sides], y[(n+1)%sides]);
    }
  }

  void setInk(color dye)
  {
    currentInk=dye;
    stroke(dye);
  }
  /*
void drawPent(float greaterRadius, color ink){
   float[] x=new float[5];
   float[] y=new float[5];
   x[0]=0;
   x[1]=greaterRadius*cos(PI/2.5);
   x[2]=greaterRadius*cos(PI/1.25);
   
   }
   */
