/**************************************************************************\
* Pinoccio Library                                                         *
* https://github.com/Pinoccio/library-pinoccio                             *
* Copyright (c) 2014, Pinoccio Inc. All rights reserved.                   *
* ------------------------------------------------------------------------ *
*  This program is free software; you can redistribute it and/or modify it *
*  under the terms of the MIT License as described in license.txt.         *
\**************************************************************************/
#include <SPI.h>
#include <Wire.h>
#include <Scout.h>
#include <GS.h>
#include <bitlash.h>
#include <lwm.h>
#include <js0n.h>
#include "version.h"

#include "Timer.h"

Timer timer;

double kTicksPerGallon = 60.0;
int kMeasureIntervalInMillis = 6000;

unsigned long currentTime;
unsigned long lastTime;
int reading = 0;
bool tickTracked = false;
float flowRateInGallons;
float gallons=0;
int magnetPasses = 0;
int hallValue = digitalRead(2);


void setup() {
  Scout.setup(SKETCH_NAME, SKETCH_REVISION, SKETCH_BUILD);
  pinMode(2,INPUT_PULLUP);
  Serial.begin(115200);
  lastTime = millis();
  
}

void loop() {
  Scout.loop();
  //Serial.println(hallValue);
  int sensorState = 0;
  sensorState = digitalRead(2);
  
    currentTime = millis();
   if ((currentTime-lastTime) > kMeasureIntervalInMillis) {
     printWaterRate(); 
     lastTime=millis();
    
   }
   
   if ((sensorState == HIGH) && (!tickTracked)) {
       Shell.eval("led.blink(255, 255, 0, 100)");
       //Serial.println('HIGH');
       tickTracked=true;
       //Serial.println("tick");
       magnetPasses++;
     }
   
     if ((tickTracked) && (sensorState == LOW)) {
       tickTracked=false;
      //Serial.println("reset"); 
     }
}


void printWaterRate() {
  
  //flowRateInGallons = (magnetPasses/kTicksPerGallon)*(60000/kMeasureIntervalInMillis); 
  gallons = (magnetPasses/kTicksPerGallon);
  
  if (magnetPasses > 0) {
    Serial.print( "Gallons: " );
    Serial.print(gallons);
    Serial.print(",");
    Serial.print(millis());
    Serial.print("\n");
    magnetPasses = 0; // reset counter
    
  
    String sGallons = String(gallons);
    Shell.eval("message.scout(1,0)");
    Shell.eval("hq.report(\"gallons_at_main\", \""+sGallons+"\")");
  }
  
}
