Blockly.Blocks['setup'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Sketch Setup");
    this.appendDummyInput()
        .appendField("Load Objects Here");
    this.appendStatementInput("INSTANTIATIONS")
        .setCheck(null);
    this.appendDummyInput()
        .appendField("void setup() {");
    this.appendDummyInput()
        .appendField("Baud Rate")
        .appendField(new Blockly.FieldDropdown([["9600", "9600"], ["115200", "115200"]]), "BAUDRATE");
    this.appendStatementInput("STATEMENTS")
        .setCheck(null);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['tricolorled'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("TriColorLED Object");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Unique Name");
    this.appendValueInput("GREEN LED pin")
        .setCheck("Number")
        .appendField("GREEN PIN");
    this.appendValueInput("RED LED pin")
        .setCheck("Number")
        .appendField("RED PIN");
    this.appendValueInput("BLUE LED pin")
        .setCheck("Number")
        .appendField("BLUE PIN");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['setcolor'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("setColor")
        .appendField(new Blockly.FieldDropdown([["Green", "GREEN"], ["Red", "RED"], ["Blue", "BLUE"]]), "COLOR");
    this.appendValueInput("OBJECT")
        .setCheck(null)
        .appendField("TriColorLED name:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['ispressed'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Is Pressed");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Button Name");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['isreleased'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Is Released");
    this.appendValueInput("OBJECT")
        .setCheck(null)
        .appendField("Button Name");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['buttonpress'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Button Press Object");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Unique Name");
    this.appendValueInput("buttonPin")
        .setCheck(null)
        .appendField("Pin Selector");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['infrared'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Infra-red Object");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Unique Name");
    this.appendValueInput("rxPin")
        .setCheck("Number")
        .appendField("Receive Pin Selector");
    this.appendValueInput("txPin")
        .setCheck("Number")
        .appendField("Transmit Pin Selector");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['fireshot'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Fire Infra-red Shot");
    this.appendValueInput("object")
        .setCheck("String")
        .appendField("Infra-red Object name");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['shotdetected'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Shot Detected");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Infra-red object");
    this.setOutput(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['piezo'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Piezo");
    this.appendValueInput("UniqueName")
        .setCheck("String")
        .appendField("Unique Name");
    this.appendValueInput("pinSelector")
        .setCheck("Number")
        .appendField("Pin Selector");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['shotsound'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Make Shot Sound");
    this.appendValueInput("NAME")
        .setCheck(null)
        .appendField("Piezo object name:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};
Blockly.Blocks['pinselector'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Pin Selector")
        .appendField(new Blockly.FieldDropdown([["D0(serial receive)", "0"], ["D1(serial transmit)", "1"], ["D2", "2"], ["D3", "3"], ["D4", "4"], ["D5", "5"], ["D6", "6"], ["D7", "7"], ["D8", "8"], ["D9", "9"], ["D10", "10"], ["D11", "11"], ["D12", "12"], ["D13", "13"], ["D14 (A0)", "14"], ["D15(A1)", "15"], ["D16(A2)", "16"], ["D17(A3)", "17"], ["D18(A4)", "18"], ["D19(A5)", "19"], ["D20(A6 Readonly)", "20"], ["D21(A7 Readonly)", "21"]]), "NAME");
    this.setOutput(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['instantiate'] = {
  init: function() {
    this.appendValueInput("NAME")
        .setCheck(null)
        .appendField("Instatiate Object");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['import'] = {
  init: function() {
    this.appendValueInput("NAME")
        .setCheck(null)
        .appendField("Import Library for Object:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(290);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['start'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Start Block");
    this.setNextStatement(true, null);
    this.setColour(65);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['loop'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("void loop() {");
    this.appendStatementInput("NAME")
        .setCheck(null);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['statement'] = {
  init: function() {
    this.appendValueInput("statementValue")
        .setCheck("String")
        .appendField("statement");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['update'] = {
  init: function() {
    this.appendStatementInput("NAME")
        .setCheck(null)
        .appendField("update objects:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['flashcolor'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Flash LED color");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField(new Blockly.FieldDropdown([["Green", "GREEN"], ["Red", "RED"], ["Blue", "BLUE"]]), "COLOR")
        .appendField("LED Object name:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['loadobjects'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Load Objects Here");
    this.appendStatementInput("NAME")
        .setCheck(null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['timer'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Timer");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Unique Name");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['timerexpired'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Timer has expired");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Name of Timer");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['resettimer'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Reset Timer");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Name of Timer:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['settimerelapse'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Set timer elapse");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Name of timer");
    this.appendValueInput("ELAPSETIME")
        .setCheck("Number")
        .appendField("milliseconds:");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['timerisactive'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Timer is active");
    this.appendValueInput("OBJECT")
        .setCheck(null)
        .appendField("Timer Name");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};
Blockly.Blocks['nextcolor'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Set LED to next color");
    this.appendValueInput("OBJECT")
        .setCheck("String")
        .appendField("Name of led object");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['createfiresequence'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Create fire sequence");
    this.appendValueInput("OBJECT")
        .setCheck("String")
        .appendField("Name of IR object");
    this.appendValueInput("FIREDATA")
        .setCheck("String")
        .appendField("3 hex digit fire sequence");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['writepin'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Write Value")
        .appendField(new Blockly.FieldDropdown([["1", "1"], ["0", "0"]]), "PINVALUE");
    this.appendValueInput("WHICHPIN")
        .setCheck(null)
        .appendField("To Pin");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['readpin'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Read Pin");
    this.appendValueInput("WHICHPIN")
        .setCheck(null)
        .appendField("Pin Selector");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['currentcolor'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Current Color");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Name of LED object");
    this.setOutput(true, "String");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['define'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("define");
    this.appendValueInput("VALUE")
        .setCheck(null)
        .appendField("value");
    this.appendValueInput("NAME")
        .setCheck(null)
        .appendField("name");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);        
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['definename'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("define");
    this.appendValueInput("NAME")
        .setCheck(null)
        .appendField("name");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['gotipaddress'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("GotIpAddress");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['getmacaddress'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Get Mac Address");
    this.setOutput(true, "String");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['serveraddressunknown'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Server Address Not Known");
    this.setOutput(true, "Boolean");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['sendvalue'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Send String to Server");
    this.appendValueInput("VALUE")
        .setCheck("String")
        .appendField("String");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['createtimer'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Create Timer")
        .appendField(new Blockly.FieldDropdown([["1", "1"], ["2", "2"]]), "whichTimer");
    this.appendValueInput("FUNCTIONNAME")
        .setCheck("String")
        .appendField("Name of Function");
    this.appendValueInput("TIMEOUT")
        .setCheck("Number")
        .appendField("Timeout (milliseconds)");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['nil'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("nil");
    this.setOutput(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['getipaddress'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Get Ip Address");
    this.setOutput(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['setmode'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Set Mode")
        .appendField(new Blockly.FieldDropdown([["Input", "INPUT"], ["Output", "OUTPUT"]]), "MODE")
        .appendField("pin")
        .appendField(new Blockly.FieldDropdown([["0", "0"],["1", "1"],["2", "2"],["3", "3"],["4", "4"],["5", "5"],
                                                ["6", "6"],["7", "7"],["8", "8"],["9", "9"],
                                                ["10", "10"],["11", "11"],["12", "12"],["13", "13"]]), "PIN");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['substring'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Substring");
    this.appendValueInput("NAME")
        .setCheck("String")
        .appendField("Variable");
    this.appendValueInput("START")
        .setCheck("Number")
        .appendField("Start Index (Starting at 1)");
    this.appendValueInput("STOP")
        .setCheck("Number")
        .appendField("Stop Index (Starting at 1)");
    this.setOutput(true, "String");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['setgpio'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Set Gpio");
    this.appendValueInput("VALUE")
        .setCheck("Number")
        .appendField("High(1) or Low(0)");
    this.appendValueInput("PIN")
        .setCheck("Number")
        .appendField("Pin");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['ord'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("ORD");
    this.appendValueInput("VALUE")
        .setCheck("String")
        .appendField("Char");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['createsensorsketch'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Create Sensor Sketch");
    this.appendStatementInput("NAME")
        .setCheck(null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['readssidpassword'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Read SSID and Password");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['joinnetwork'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Join the Local Area network");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['listenforservercommand'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Listen For Server Command");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['comment'] = {
  init: function() {
    this.appendValueInput("COMMENT")
        .setCheck("String")
        .appendField("Comment");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['turnoff'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Turn Off Command Value");
    this.appendValueInput("VARIABLE")
        .setCheck("String")
        .appendField("Command Variable");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['turnon'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Turn On Command Value");
    this.appendValueInput("VARIABLE")
        .setCheck("String")
        .appendField("Command Variable");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['sendheartbeat'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Send Heartbeat to Server");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['extractservercommand'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Extract Server Command");
    this.appendValueInput("COMMAND")
        .setCheck(null)
        .appendField("Command Variable");
    this.setOutput(true, "String");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['extractrelaynumber'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Extract Relay Number");
    this.appendValueInput("COMMAND")
        .setCheck("String")
        .appendField("Server Command Variable");
    this.appendValueInput("START")
        .setCheck("Number")
        .appendField("Start extraction at column");
    this.setOutput(true, "Number");
    this.setColour(120);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

