#include <avr/interrupt.h>
#include <avr/power.h>
#include <avr/sleep.h>
#include <avr/io.h>
#include "PCM.h"
#include <stdint.h>
#include <avr/pgmspace.h>

#define SAMPLE_RATE 8000

int ledFlashPin = 12;
int trigger = 2;
int i = 0;

////Binary code for Han Solo's blaster sound effect - feel free to swap out the sound effect if you want a different noise. This sound effect was extracted by Baron von Brunk from the scene in Episode IV when Han correctly shoots Greedo first. Sound clip courtesy of George Lucas, copyright 1977.
const unsigned char DL44_Blaster_Sound[] PROGMEM = {
120, 173, 228, 200, 128,  98, 201, 244, // 0-7
150,  33,  86, 211, 136,  50,  80, 136, // 8-15
159, 153, 209, 230, 230, 135,  75, 191, // 16-23
214, 168, 110,  71,  42,  42,  69,  98, // 24-31
145, 177, 203, 211, 203, 180, 166, 147, // 32-39
110,  95,  80,  43,  26,  28,  36,  43, // 40-47
 41,  72,  83,  78,  63,  76,  80,  60, // 48-55
 75, 102, 117, 101, 123, 174, 194, 211, // 56-63
239, 246, 214, 120, 110, 159, 185, 160, // 64-71
110, 115, 127, 127, 100, 122, 111,  38, // 72-79
 27,  91, 109,  77,  68,  72,  75,  65, // 80-87
 63,  50,  72,  77,  74, 104, 144, 137, // 88-95
117, 162, 176, 183, 158, 159, 157, 138, // 96-103
124, 148, 210, 169, 122, 118, 135, 125, // 104-111
107, 131, 190, 184, 120, 165, 218, 213, // 112-119
223, 177, 176, 198, 198, 214, 209, 153, // 120-127
117, 150, 193, 202, 137,  52,  52, 168, // 128-135
164,  90,  38,  60, 130, 161, 181, 137, // 136-143
106,  85,  64,  48,  64,  81,  71,  63, // 144-151
 69, 127, 201, 163,  84, 139, 214, 164, // 152-159
108, 144, 143, 180, 230, 221, 219, 141, // 160-167
101, 118, 136, 154, 155,  93,  73, 181, // 168-175
195, 190, 177, 170, 104,  73, 156,  95, // 176-183
 35,  41,  42,  42,  71,  57,  71, 114, // 184-191
110, 138, 123, 146, 136, 148,  73,  52, // 192-199
138, 114, 147, 115,  99,  55,  59,  62, // 200-207
 41,  50,  43,  77,  35,  53,  99, 157, // 208-215
 89,  62,  98, 100, 169, 149, 187, 218, // 216-223
140, 108, 144, 124, 159, 166,  82, 136, // 224-231
113,  85, 200, 160,  95, 103, 136,  90, // 232-239
 56,  80,  44, 106,  78,  58,  90,  71, // 240-247
 82,  79,  96, 109,  69, 137, 172,  98, // 248-255
116, 155, 187, 198, 198, 199, 206, 222, // 256-263
206, 210, 212, 210, 150,  66,  99, 170, // 264-271
202, 188, 198, 153, 155, 149, 119, 153, // 272-279
120, 139, 121, 144, 123, 127, 134, 127, // 280-287
161, 144, 140, 119, 173, 150, 150, 169, // 288-295
195, 206, 203, 195, 198, 218, 220, 196, // 296-303
196, 217, 166, 161, 151, 187, 107,  62, // 304-311
 87, 119,  89,  22,  60,  99, 110,  46, // 312-319
 37,  79, 120, 117,  93, 142, 153, 120, // 320-327
148, 169, 195, 175, 172, 166, 175, 173, // 328-335
115, 101, 147, 151,  76,  90,  92,  94, // 336-343
 72,  67,  86,  63,  41,  19,  39,  46, // 344-351
 50,  37,  65,  81,  49,  28,  45,  82, // 352-359
105,  83,  79, 113,  94,  96, 117, 115, // 360-367
112, 128, 165, 169, 129, 148, 146, 160, // 368-375
203, 207, 185, 158, 172, 180, 177, 144, // 376-383
172, 180, 130, 117, 131, 128, 119, 112, // 384-391
138, 149, 115, 100,  94,  96, 104, 108, // 392-399
 71,  67,  88, 114,  68,  50,  80,  59, // 400-407
 98, 108,  94,  96,  97,  93,  86,  82, // 408-415
 97, 148, 129,  96, 118, 141, 112, 119, // 416-423
156, 157, 177, 181, 213, 171, 155, 204, // 424-431
204, 206, 192, 195, 213, 202, 191, 204, // 432-439
188, 168, 175, 194, 183, 137,  97, 146, // 440-447
206, 160, 128, 153, 147, 137, 131, 124, // 448-455
121, 107, 143, 154, 126,  94, 106, 149, // 456-463
124,  74,  56,  74,  79,  62,  52,  42, // 464-471
 36,  48,  85,  78,  48,  56,  62,  82, // 472-479
 68,  32,  37,  82, 103,  63,  56,  89, // 480-487
 91,  77,  80, 105,  97,  89, 100, 114, // 488-495
143, 132, 123, 113, 137, 171, 154, 151, // 496-503
159, 182, 192, 174, 182, 194, 187, 186, // 504-511
194, 214, 197, 199, 207, 222, 194, 178, // 512-519
212, 206, 183, 176, 173, 176, 196, 173, // 520-527
162, 150, 156, 151, 158, 142, 110,  83, // 528-535
 96, 179, 175, 100,  39,  97, 145, 128, // 536-543
 95,  72,  87, 131, 138,  93,  67,  68, // 544-551
 77,  93,  71,  46,  51,  67,  67,  60, // 552-559
 97,  52,  28,  73,  94,  86,  60,  68, // 560-567
109, 116, 116,  95,  96,  94, 134, 148, // 568-575
 88,  81, 108, 155, 147, 179, 171, 139, // 576-583
105, 122, 160, 181, 171, 140, 192, 207, // 584-591
158, 100, 152, 209, 206, 202, 180, 140, // 592-599
141, 185, 192, 163, 151, 139, 138, 157, // 600-607
181, 163, 149, 123, 100, 160, 191, 157, // 608-615
 97, 102, 112, 140, 140, 136, 137, 139, // 616-623
129, 114, 102,  75,  99,  87,  55,  44, // 624-631
 41,  22,  37, 102,  85,  40,  52,  69, // 632-639
 90,  95, 104,  77,  52,  64,  88,  91, // 640-647
 42,  47,  91,  75,  52,  52,  33,  32, // 648-655
 38,  77,  65,  59,  36,  13,  45,  85, // 656-663
 92,  65,  74, 105, 129, 106, 139, 137, // 664-671
130, 113, 101, 143, 156, 186, 186, 144, // 672-679
154, 192, 194, 207, 209, 222, 216, 210, // 680-687
218, 224, 229, 216, 171, 158, 191, 222, // 688-695
221, 192, 178, 176, 204, 214, 157, 121, // 696-703
168, 204, 216, 218, 221, 217, 218, 200, // 704-711
202, 210, 207, 178, 137, 121,  79, 129, // 712-719
163, 133,  86,  92,  97, 140, 168, 202, // 720-727
202, 180, 188, 138, 126,  90, 116, 142, // 728-735
163, 130,  50,  40,  62,  85, 109,  87, // 736-743
 72,  53,  40,  40,  78, 124,  79,  48, // 744-751
 23,  58,  67, 147, 199, 130,  81,  54, // 752-759
 76,  79,  97,  90,  63,  38,  38,  32, // 760-767
 47, 103,  67,  29,  41,  37,  32,  42, // 768-775
 76, 121,  98,  50,  38,  59,  94,  61, // 776-783
 81, 119,  86,  78,  86, 124, 182, 173, // 784-791
 83, 118, 174, 188, 178, 165, 200, 161, // 792-799
182, 214, 200, 170, 144, 127, 162, 185, // 800-807
176, 136, 185, 212, 128, 133, 126, 190, // 808-815
163,  89,  82,  83, 133, 170, 147,  81, // 816-823
 81, 125, 160, 183, 133, 100, 125, 166, // 824-831
214, 206, 211, 159, 115, 121,  83,  87, // 832-839
137, 188, 166, 113,  88, 113, 164, 184, // 840-847
196, 195, 152, 127, 178, 221, 190, 119, // 848-855
129, 170, 180, 137, 119, 129, 164, 201, // 856-863
151, 130, 114,  95,  83, 146, 166, 126, // 864-871
 72,  43,  38,  89, 159, 136, 105,  50, // 872-879
 32,  46, 106, 102,  44,  41,  92, 147, // 880-887
165, 124,  65,  89,  83,  87, 111,  68, // 888-895
 39,  46,  37,  31,  54,  77,  87, 100, // 896-903
 61,  77, 110, 169, 200, 132, 167, 166, // 904-911
189, 217, 186, 166, 111,  84, 124, 178, // 912-919
143, 133, 127, 124, 192, 188, 156, 109, // 920-927
 90, 141, 164, 170, 152, 177, 190, 115, // 928-935
131, 166,  91, 106, 177, 124,  89,  65, // 936-943
 78, 160, 142,  83, 117, 107, 127, 135, // 944-951
114, 149, 172, 197, 159, 163, 165, 185, // 952-959
205, 180, 218, 195, 102, 176, 200, 168, // 960-967
176, 175, 239, 144, 107, 133, 126, 175, // 968-975
229, 200, 107,  56,  33, 130, 189, 155, // 976-983
181,  85,  44,  59,  31, 116, 137, 158, // 984-991
128,  47,  31,  78, 119, 102,  98, 110, // 992-999
 92, 152, 207, 171, 158,  88,  65,  90, // 1000-1007
115, 194, 175, 100,  67,  77, 111, 126, // 1008-1015
168,  88,  18,  26,  48,  91, 157, 152, // 1016-1023
 66,  41,  40, 111, 172, 159, 136,  90, // 1024-1031
 33,  59,  37,  69,  70,  55, 102,  74, // 1032-1039
 51,  62,  77,  89, 159, 143, 148,  97, // 1040-1047
 97, 201, 186, 144, 136, 111,  41,  35, // 1048-1055
 53, 102, 122,  67,  35,  31,  57,  76, // 1056-1063
179, 182,  98, 122, 152, 198, 198, 175, // 1064-1071
178, 175, 116, 160, 205, 206, 210, 198, // 1072-1079
190, 188, 177, 132, 177, 157, 117, 114, // 1080-1087
125, 131, 195, 209, 167, 169, 142, 170, // 1088-1095
160,  92, 120, 157, 107,  82, 102, 131, // 1096-1103
121, 125, 134, 131, 115, 109, 149, 177, // 1104-1111
161, 127, 152, 122, 146, 223, 148,  94, // 1112-1119
117, 143, 170, 192, 131, 142, 191, 160, // 1120-1127
132, 169, 205, 179, 201, 194, 176, 143, // 1128-1135
139, 179, 192, 152, 151, 121,  45, 108, // 1136-1143
170, 144, 146, 135,  42,  62, 104,  81, // 1144-1151
 90, 122,  98,  45,  97, 164, 168, 114, // 1152-1159
 46,  45,  68,  83,  94, 105,  82,  48, // 1160-1167
 43,  98, 180, 154, 121, 154, 169, 100, // 1168-1175
113, 201, 209, 111,  59,  67, 102,  83, // 1176-1183
 46, 120, 107,  94,  90, 115, 143, 120, // 1184-1191
 88,  94,  91,  86,  76,  46,  47,  35, // 1192-1199
 41,  65, 104,  52,  53,  99,  94, 108, // 1200-1207
142, 197, 193, 176, 162, 162, 129,  99, // 1208-1215
129, 162, 208, 168, 124, 118, 111, 132, // 1216-1223
159, 161, 116,  92, 103, 127,  96,  74, // 1224-1231
 71,  61,  63,  72, 125, 166, 137,  76, // 1232-1239
105,  99,  95,  96, 112, 160, 137, 160, // 1240-1247
145, 201, 233, 210, 194, 157, 197, 222, // 1248-1255
227, 229, 234, 177, 211, 195,  93, 120, // 1256-1263
192, 200, 139, 154, 154, 151, 141, 123, // 1264-1271
156, 159, 108,  75,  96, 125, 138, 127, // 1272-1279
133, 117,  83,  81, 140, 161,  86,  70, // 1280-1287
 91,  82,  63, 118, 170,  90,  75, 136, // 1288-1295
126, 164, 204, 188, 203, 198, 185, 204, // 1296-1303
195, 195, 150, 105, 143, 165, 173, 108, // 1304-1311
100, 128, 134, 109,  88, 129, 103,  57, // 1312-1319
 89, 111,  45,  60,  81, 100, 117,  51, // 1320-1327
 49,  60, 104, 128, 126, 122, 120, 122, // 1328-1335
 88,  99, 113, 116, 108, 155, 168, 134, // 1336-1343
107,  84,  75,  70,  73,  82, 128, 145, // 1344-1351
106,  84, 133, 170, 181, 200, 189, 183, // 1352-1359
146,  84, 156, 222, 184,  93, 120, 173, // 1360-1367
168, 102,  52, 105, 174, 137,  72, 124, // 1368-1375
158, 154, 147, 183, 170, 196, 133,  85, // 1376-1383
171, 149, 102,  88, 119, 168, 153, 116, // 1384-1391
101, 132, 171, 138, 111, 118, 106,  84, // 1392-1399
113, 113,  68,  44,  70,  96, 100,  61, // 1400-1407
 52,  51,  68,  63,  51,  98, 143, 123, // 1408-1415
 74,  90, 130, 137,  74,  74, 113, 116, // 1416-1423
 61,  26,  34,  85,  89,  83,  88,  49, // 1424-1431
 66,  67,  80, 157, 107,  64, 135, 114, // 1432-1439
103, 134, 166, 114,  94, 168, 224, 167, // 1440-1447
181, 215, 223, 190, 140, 211, 207, 188, // 1448-1455
207, 200, 130, 129, 163, 203, 188, 163, // 1456-1463
148, 120,  53,  46, 101, 124, 115,  70, // 1464-1471
 77,  99, 112, 118, 120, 109, 155, 111, // 1472-1479
159, 194, 149, 126, 163, 149, 161, 167, // 1480-1487
124, 206, 218, 170, 112, 189, 224, 228, // 1488-1495
160, 126, 180, 195, 117, 112, 199, 213, // 1496-1503
175,  87, 142, 177, 182, 152, 103, 135, // 1504-1511
180, 163, 156, 151, 208, 206,  87, 110, // 1512-1519
162, 125, 119, 105,  50, 119, 191, 133, // 1520-1527
 90,  87,  82, 102,  49,  66, 209, 209, // 1528-1535
157, 115,  82, 119, 127,  80, 100, 116, // 1536-1543
 77,  60,  46, 127, 140, 145,  90,  97, // 1544-1551
155, 153, 176, 107, 119, 116, 190, 126, // 1552-1559
116, 147, 170, 198, 127, 136, 133, 155, // 1560-1567
103, 123,  54,  70,  76,  31,  96, 123, // 1568-1575
 80,  20,  30,  55,  86,  23,  32,  70, // 1576-1583
 52,  67,  62,  22,  63,  44,  22,  16, // 1584-1591
 43,  45,  16,  99,  78,  65,  94, 143, // 1592-1599
 57,  51,  97, 123, 130,  44,  86,  97, // 1600-1607
113, 131,  95,  30,  88, 175, 146,  57, // 1608-1615
123, 150, 132, 123,  67,  71,  72, 165, // 1616-1623
136, 163, 167, 172, 199, 165, 152, 177, // 1624-1631
201, 137, 163, 153, 225, 200, 148, 147, // 1632-1639
148, 184, 225, 219, 161, 228, 216, 222, // 1640-1647
156, 153, 192, 191, 162,  70,  87, 133, // 1648-1655
226, 137,  88, 206, 193, 172, 177, 118, // 1656-1663
162, 221, 166, 183, 241, 211, 181, 234, // 1664-1671
200, 138, 193, 224, 225, 155, 117, 170, // 1672-1679
200, 224, 150, 155, 153,  54,  92, 113, // 1680-1687
103,  59,  39,  89, 114, 172, 107,  76, // 1688-1695
140, 175, 220, 201, 129, 117, 172, 173, // 1696-1703
162, 200, 204, 127, 120, 132, 174, 185, // 1704-1711
134, 145, 121, 131, 103, 122, 126,  96, // 1712-1719
135,  71,  57, 106, 108,  81,  64, 120, // 1720-1727
105,  91, 106,  85, 108, 112,  70,  33, // 1728-1735
 71,  72,  43,  39,  34,  74,  92,  60, // 1736-1743
 43,  28,  14,  40,  37,  35,  36,  21, // 1744-1751
 35,  37,  30,  24,  65,  70,  78,  83, // 1752-1759
 35, 108, 180, 170, 125,  42,  80, 123, // 1760-1767
122,  72,  24,  93, 125, 138, 122,  76, // 1768-1775
 52, 128, 139, 104, 141, 125, 129, 181, // 1776-1783
144, 116, 125, 100, 150, 133, 113, 113, // 1784-1791
113, 163, 160, 157, 143, 111, 158, 181, // 1792-1799
137, 118, 114, 130, 186, 201, 208, 230, // 1800-1807
201, 190, 176, 149, 163, 155, 167, 173, // 1808-1815
114, 187, 187, 191, 187, 153, 210, 214, // 1816-1823
220, 202, 197, 186, 202, 237, 236, 235, // 1824-1831
223, 220, 217, 189, 180, 176, 154, 137, // 1832-1839
178, 130,  74,  98,  70,  84,  77,  51, // 1840-1847
 86,  63,  68,  99,  89,  83,  95,  94, // 1848-1855
109, 119,  65, 107, 119,  82, 103, 104, // 1856-1863
 75, 101, 109, 102,  76,  65,  83,  47, // 1864-1871
 74,  66,  50,  68,  43,  69,  77,  58, // 1872-1879
108,  81,  76,  96,  84, 125, 108,  90, // 1880-1887
 99,  66,  74,  95, 106, 150, 149, 142, // 1888-1895
156, 149, 169, 177, 174, 168, 120, 120, // 1896-1903
107,  93, 119,  67,  81, 122,  90, 118, // 1904-1911
106,  78,  86,  88,  90,  80,  70,  97, // 1912-1919
 92, 120, 121,  69,  80,  80,  71,  76, // 1920-1927
107, 130, 164, 177, 191, 212, 175, 141, // 1928-1935
188, 181, 205, 219, 190, 229, 230, 227, // 1936-1943
224, 214, 189, 202, 214, 219, 152, 119, // 1944-1951
159, 113, 135, 191, 178, 218, 160, 102, // 1952-1959
178, 124,  94, 153, 163, 186, 143, 115, // 1960-1967
182, 155, 143, 126, 142, 166, 121, 186, // 1968-1975
193, 137, 156, 137, 147, 138,  47,  99, // 1976-1983
100,  69,  94, 118,  94,  45,  83, 140, // 1984-1991
130,  96,  94,  50,  92,  85,  68,  75, // 1992-1999
 60,  67,  85, 101, 101,  88,  47, 115, // 2000-2007
 95,  78,  84,  73, 100,  94, 101,  55, // 2008-2015
 21,  25,  79, 116,  98,  26,  31,  72, // 2016-2023
 63,  90, 126,  55,  23,  74,  60,  87, // 2024-2031
 66,  21,  99, 175, 143, 149, 161, 122, // 2032-2039
 78,  56, 137, 144, 126, 146, 104, 134, // 2040-2047
137, 101,  93, 108,  98, 132, 159, 164, // 2048-2055
137,  97, 151, 129,  75,  50,  80,  97, // 2056-2063
131, 161, 149, 125,  77,  97, 165, 163, // 2064-2071
178, 171, 174, 157, 104, 164, 218, 194, // 2072-2079
117, 116, 162, 197, 166, 175, 146, 125, // 2080-2087
157, 189, 178, 183, 173, 149, 186, 177, // 2088-2095
177, 172, 223, 152, 145, 207, 222, 175, // 2096-2103
169, 185, 148, 196, 156, 187, 191, 141, // 2104-2111
158, 180, 179, 141, 101, 136, 173, 128, // 2112-2119
138, 155, 147, 154, 155, 144, 176, 142, // 2120-2127
102, 151, 157, 160, 144, 103, 123, 189, // 2128-2135
165, 149, 147, 113, 113, 147, 168, 154, // 2136-2143
138, 119, 118,  95, 140, 159, 139, 126, // 2144-2151
112, 100, 130, 155, 157, 156, 121, 139, // 2152-2159
169, 155, 124, 145, 150, 167, 123,  94, // 2160-2167
100,  94,  93,  73,  98, 101,  92,  61, // 2168-2175
 27,  47,  54,  51,  46,  34,  33,  41, // 2176-2183
 39,  47,  44,  41,  62,  34,  39,  45, // 2184-2191
 67, 129, 135,  57,  63, 136, 127, 118, // 2192-2199
100, 103, 154, 139, 108, 143, 144, 106, // 2200-2207
107, 104, 128, 138,  49,  50,  49,  87, // 2208-2215
138, 105,  45,  80, 102,  44, 107, 112, // 2216-2223
 88,  86, 105, 112, 124, 105, 130, 207, // 2224-2231
139,  80, 181, 180, 132, 168, 128, 153, // 2232-2239
215, 197, 187, 156, 157, 190, 140, 157, // 2240-2247
170, 213, 173,  66, 148, 216, 168, 104, // 2248-2255
 64, 132, 152, 129, 198, 207, 149,  76, // 2256-2263
153, 198, 184, 163, 140, 164, 142, 168, // 2264-2271
201, 219, 145,  93, 153, 197, 196, 152, // 2272-2279
 91, 106, 207, 186, 147, 118, 112, 164, // 2280-2287
192, 161, 130, 105,  37, 125, 150, 101, // 2288-2295
114,  95,  95, 161, 197, 168, 189, 162, // 2296-2303
165, 222, 158, 160, 199, 196, 161, 134, // 2304-2311
193, 182, 150, 119,  81,  95, 126, 130, // 2312-2319
133,  80,  34,  88, 127, 133, 109,  45, // 2320-2327
  6,  30,  32,  57,  87,  40,  18,  32, // 2328-2335
 65,  66,  92,  81,  57,  81,  68, 112, // 2336-2343
129, 120, 115, 193, 195, 202, 187, 110, // 2344-2351
165, 214, 207, 176, 206, 213, 232, 171, // 2352-2359
139, 183, 208, 148,  84, 107, 131, 152, // 2360-2367
130, 109, 102, 128,  60,  32,  74,  66, // 2368-2375
 49,  39,  25,  57,  90,  55,  50,  78, // 2376-2383
 93, 151, 113,  74, 127,  75, 137, 170, // 2384-2391
140, 161, 191, 130, 142, 196, 157, 177, // 2392-2399
119, 144, 155, 156, 169, 174, 173, 104, // 2400-2407
118, 181, 200, 158, 154, 106,  84, 149, // 2408-2415
188, 190, 158, 107,  52, 160, 164, 152, // 2416-2423
169, 104,  90,  84, 158, 131, 144, 129, // 2424-2431
 70,  62, 130, 139,  73,  94,  90,  48, // 2432-2439
 76, 148, 130, 123,  67,  24, 125, 173, // 2440-2447
 97,  80,  59,  53,  99, 112,  63,  75, // 2448-2455
 94,  63,  42,  65,  87,  94, 113,  54, // 2456-2463
 55, 100, 103, 148, 170,  87, 134, 195, // 2464-2471
157, 171, 173, 182, 195, 153, 139, 203, // 2472-2479
204, 186, 189, 130, 189, 167, 153, 171, // 2480-2487
104, 122, 115, 108, 114, 146, 131,  65, // 2488-2495
 63,  85,  90,  94,  76,  89,  83,  86, // 2496-2503
 72,  83, 117, 111, 149, 126,  96, 126, // 2504-2511
145, 163, 124, 119, 138, 128, 200, 172, // 2512-2519
179, 174, 135, 174, 191, 196, 170, 180, // 2520-2527
153, 136, 178, 184, 168, 174, 198, 144, // 2528-2535
120, 186, 186, 169, 156,  90, 118, 182, // 2536-2543
154, 155, 154, 124,  82, 112, 123, 126, // 2544-2551
150,  88,  45,  70,  75,  81, 116,  88, // 2552-2559
 75, 102, 167, 155, 156, 151, 125, 170, // 2560-2567
140, 158, 170, 162, 186, 150, 140, 183, // 2568-2575
201, 181, 156, 161, 168, 129, 120, 142, // 2576-2583
132, 130, 101,  49, 113,  96, 106, 108, // 2584-2591
 35,  18,  64, 121,  80,  78,  60,  44, // 2592-2599
 77,  96,  49,  61,  78,  66,  69,  80, // 2600-2607
116, 140, 156, 123,  53,  80, 174, 187, // 2608-2615
172, 120, 126, 124, 127, 162, 114,  84, // 2616-2623
 70,  55,  73, 114, 123, 150, 140, 132, // 2624-2631
 97, 100, 157, 111, 178, 158, 136, 151, // 2632-2639
139, 198, 182, 156, 124,  76, 101, 185, // 2640-2647
162,  97,  71,  68, 108, 148, 118, 104, // 2648-2655
 90,  78, 120,  62,  51, 101, 107, 139, // 2656-2663
 82,  53,  71, 128, 186, 142,  89,  94, // 2664-2671
101, 161, 159,  93, 149, 133, 176, 164, // 2672-2679
129, 203, 217, 215, 192, 148, 130, 163, // 2680-2687
209, 203, 171, 163, 130, 142, 211, 166, // 2688-2695
127, 134,  85, 137, 125, 126, 165, 111, // 2696-2703
111,  86,  33,  83, 133, 114, 141, 143, // 2704-2711
 71,  52,  78, 117, 100,  75,  81,  79, // 2712-2719
122, 166, 140, 107, 124, 110, 151, 152, // 2720-2727
145, 163, 130, 173, 158, 112, 155, 201, // 2728-2735
174, 194, 148, 124, 185, 157, 212, 204, // 2736-2743
161, 175, 159, 141, 187, 203, 150, 172, // 2744-2751
152, 160, 168, 167, 197, 147, 144, 144, // 2752-2759
105,  89, 106, 131, 103,  64,  34,  39, // 2760-2767
 45,  81,  68,  80,  86,  32,  63,  72, // 2768-2775
 94, 121, 110, 119,  97,  75, 129, 123, // 2776-2783
109,  94,  89, 100,  93, 126, 126, 103, // 2784-2791
 91, 111,  69, 101, 160, 144, 135, 100, // 2792-2799
 89, 112, 147, 177, 128,  62, 114, 118, // 2800-2807
 84, 116,  91,  69, 108,  79,  84,  66, // 2808-2815
103, 182, 120, 119,  91,  74, 136, 162, // 2816-2823
124, 133, 109, 131, 161, 108, 176, 203, // 2824-2831
161, 170, 135, 100, 117, 139, 197, 122, // 2832-2839
 87,  88,  85, 116, 162, 153, 127, 148, // 2840-2847
112,  95, 112, 164, 129, 129, 137, 141, // 2848-2855
176, 192, 164, 119, 132, 166, 168, 139, // 2856-2863
100, 113, 177, 189, 139, 111,  86, 147, // 2864-2871
137,  86, 145,  74, 100, 137, 100,  60, // 2872-2879
 93, 112,  88,  88,  75,  88,  91, 163, // 2880-2887
155, 112, 100, 101, 107, 122, 190, 157, // 2888-2895
109, 207, 149,  82, 168, 235, 179, 145, // 2896-2903
153, 120, 146, 169, 209, 143, 130, 135, // 2904-2911
 90, 115, 136, 136,  76, 107, 112, 106, // 2912-2919
123, 138, 174, 121, 124, 120, 130, 119, // 2920-2927
111, 177, 171, 150, 136,  71, 103, 171, // 2928-2935
159, 161, 145,  90,  74, 127, 166, 168, // 2936-2943
104, 148, 136, 113, 179, 112, 140, 171, // 2944-2951
147, 169, 110,  90, 130, 163, 167, 159, // 2952-2959
151,  97, 119, 122, 165, 142, 108, 131, // 2960-2967
 55, 108, 146, 125, 111,  93, 114,  85, // 2968-2975
 87,  68, 127, 146, 139, 110,  43,  95, // 2976-2983
 76, 127,  99, 126, 163,  90,  82,  99, // 2984-2991
160, 137, 138, 112, 108, 135, 174, 150, // 2992-2999
 73, 120, 123,  95, 109, 170, 159, 121, // 3000-3007
158, 114, 115, 163, 185, 119,  83, 111, // 3008-3015
 80,  97, 134, 202, 125, 129, 142,  96, // 3016-3023
138, 152, 142,  67,  82,  99, 114, 118, // 3024-3031
 39,  67, 130, 123, 151, 118,  63,  76, // 3032-3039
126, 148, 145, 124, 109, 115, 136, 106, // 3040-3047
107, 149, 117, 168, 120, 101, 111, 134, // 3048-3055
122, 114,  94,  72, 148, 147, 200, 182, // 3056-3063
152, 133, 136, 149, 179, 177,  88,  99, // 3064-3071
128, 111, 116,  94, 107,  77, 103, 133, // 3072-3079
 77, 129, 136, 162, 130, 133, 109,  84, // 3080-3087
145, 126, 187, 145, 106, 147, 120, 152, // 3088-3095
144, 136,  94,  98, 178, 128, 118,  86, // 3096-3103
112, 169, 154, 150, 119, 114, 141, 161, // 3104-3111
146, 139, 143, 123, 137, 124, 100,  94, // 3112-3119
134, 148,  91, 132, 104, 102, 125, 154, // 3120-3127
125, 108, 139,  88, 159, 130, 144, 166, // 3128-3135
140, 160, 146, 156, 125, 151, 170, 112, // 3136-3143
118, 100, 107, 162, 143, 153, 102, 123, // 3144-3151
118, 153, 169, 108, 153, 113, 108,  97, // 3152-3159
118, 120, 108, 139, 131, 121, 135,  88, // 3160-3167
 93,  85,  68, 108,  59,  71,  66, 100, // 3168-3175
105, 140, 140, 100, 132,  89, 176, 161, // 3176-3183
126, 135,  95, 129, 120, 133, 144, 125, // 3184-3191
143, 177, 162, 134, 114, 160, 126, 145, // 3192-3199
175, 126, 160,  92, 127, 147, 159, 198, // 3200-3207
112,  85,  99, 164, 163, 144, 124,  65, // 3208-3215
109, 145, 125, 149,  90, 123, 181, 109, // 3216-3223
132, 103, 151, 158, 161, 152,  97, 112, // 3224-3231
 99, 112,  94, 112, 105, 115, 140,  94, // 3232-3239
 76, 135, 105, 163, 172,  80, 100, 127, // 3240-3247
148, 108, 135, 155, 120, 115,  99, 102, // 3248-3255
123, 141, 178, 145, 112,  88, 114, 194, // 3256-3263
140, 137, 152,  93, 125, 146, 155, 153, // 3264-3271
118, 147, 176, 156, 145, 156, 133, 122, // 3272-3279
120,  93,  99,  87,  66, 119,  72,  64, // 3280-3287
134, 122, 112,  67,  78, 120, 142, 176, // 3288-3295
143,  90,  92, 125, 181, 185, 149, 156, // 3296-3303
127, 120, 135, 175, 210, 162, 161, 107, // 3304-3311
 93, 133, 137, 130,  94, 108, 101, 100, // 3312-3319
114, 101, 118, 126, 129, 171, 148, 115, // 3320-3327
 81, 123, 130, 108, 136,  81, 104, 117, // 3328-3335
 70, 124, 110, 108, 171, 124, 100,  61, // 3336-3343
 82, 136, 138, 147, 122, 103,  93,  83, // 3344-3351
127, 139, 118, 134, 147,  99,  97, 125, // 3352-3359
142, 110,  91, 134, 105, 109, 108, 146, // 3360-3367
120,  97, 127, 123, 127, 116,  97, 122, // 3368-3375
140, 120, 161, 135,  91, 107, 150, 162, // 3376-3383
132, 137, 167, 128, 154, 143, 118, 148, // 3384-3391
113, 107, 131, 147, 100, 116, 164, 158, // 3392-3399
127, 156, 143, 148, 192, 171, 151, 125, // 3400-3407
120, 128, 190, 202, 138, 124, 159, 167, // 3408-3415
186, 174, 120, 125, 134, 140, 157, 118, // 3416-3423
 95, 107, 104, 101,  99,  91, 128, 153, // 3424-3431
119, 120, 113,  63,  91, 125, 115, 121, // 3432-3439
 71,  88, 134, 128, 120,  69,  40,  89, // 3440-3447
112, 159, 169,  98,  91, 111, 150, 157, // 3448-3455
163, 135, 163, 157, 113, 146, 168, 162, // 3456-3463
167, 176, 116, 127, 133, 147, 158, 154, // 3464-3471
133, 118, 148, 111, 112, 118, 129, 141, // 3472-3479
120, 115, 109, 102, 137, 161, 133, 121, // 3480-3487
126, 113, 106, 130, 127, 105, 152, 165, // 3488-3495
150, 159, 118, 122, 142, 125, 123, 102, // 3496-3503
100, 130, 135, 112,  98,  94, 101, 118, // 3504-3511
106,  67,  70,  80,  65, 127, 102,  71, // 3512-3519
 73,  63, 139,  93,  81, 120, 114, 137, // 3520-3527
136, 130, 105, 121, 150, 178, 141, 118, // 3528-3535
116, 128, 170, 135, 151, 111, 127, 161, // 3536-3543
140, 176, 171, 150, 156, 165, 109, 110, // 3544-3551
115, 119, 115,  97,  91,  69,  87,  93, // 3552-3559
130, 113,  81, 105,  84,  97, 126, 123, // 3560-3567
123, 141, 139, 108, 120, 123, 154, 147, // 3568-3575
104,  87, 113, 139, 128, 102,  68, 106, // 3576-3583
123, 151, 162, 117, 108, 120, 143, 159, // 3584-3591
172, 195, 183, 162, 173, 169, 156, 167, // 3592-3599
133, 121, 156, 165, 127,  89, 123, 145, // 3600-3607
146, 165, 195, 131, 170, 215, 181, 185, // 3608-3615
156, 143, 121, 168, 191, 142, 130, 139, // 3616-3623
155, 109,  91, 126, 123, 135, 130, 125, // 3624-3631
 89,  92, 121, 115, 117, 129, 121, 109, // 3632-3639
102,  97, 114,  89, 104,  93, 109, 129, // 3640-3647
120, 114,  57,  90, 113, 112,  99,  67, // 3648-3655
117, 133,  95,  79,  96, 108, 105, 112, // 3656-3663
 92,  73, 107, 126, 110,  50,  66, 132, // 3664-3671
 92, 127, 134, 101, 117, 108, 100,  89, // 3672-3679
115, 107, 139, 147, 100,  90, 107, 127, // 3680-3687
112, 151, 152, 132, 105, 110, 169, 123, // 3688-3695
163, 174, 117, 101, 131, 175, 137, 170, // 3696-3703
154, 137, 126, 124, 142, 121, 156, 172, // 3704-3711
159, 127, 137, 137, 169, 159, 133, 154, // 3712-3719
140, 150, 101, 123, 161, 122, 149, 143, // 3720-3727
126, 129, 124, 177, 188, 162, 168, 155, // 3728-3735
114, 114, 137, 147, 143, 122, 142, 161, // 3736-3743
134, 142, 159, 161, 148, 120, 151, 108, // 3744-3751
119, 166, 154, 135,  82,  98,  88, 101, // 3752-3759
133, 117,  70,  97, 141, 135, 159,  97, // 3760-3767
 99, 128, 157, 161,  96, 118,  95,  98, // 3768-3775
118, 117, 120,  56, 110, 101,  70,  81, // 3776-3783
 73, 112,  64, 107,  98,  69, 120, 126, // 3784-3791
120,  89, 123, 154, 145, 122, 121,  88, // 3792-3799
111, 142, 131, 118,  91, 119,  89, 125, // 3800-3807
131,  87, 113, 122, 111, 120, 133, 149, // 3808-3815
152, 113, 150, 137, 156, 158, 129, 144, // 3816-3823
128, 121, 110, 129, 130, 119,  97, 104, // 3824-3831
132, 152, 152, 128, 110, 105, 132, 166, // 3832-3839
141, 134, 149, 163, 174, 150, 128, 105, // 3840-3847
145, 123, 142, 121,  90,  74,  72, 147, // 3848-3855
119, 148, 121, 120, 128, 117, 135, 146, // 3856-3863
167, 136, 132, 112, 148, 144, 164, 176, // 3864-3871
106, 125, 171, 226, 190, 140, 127, 119, // 3872-3879
164, 173, 168, 123, 129, 148, 160, 183, // 3880-3887
142, 149, 117, 128, 121,  72, 122, 125, // 3888-3895
140, 106,  81,  93,  54,  99,  87, 103, // 3896-3903
112,  83, 130, 101, 120, 118,  93, 143, // 3904-3911
131, 139, 118, 111, 135, 123, 120, 100, // 3912-3919
132, 136, 147, 137,  86,  84, 105, 141, // 3920-3927
128, 134, 106,  95,  88,  97, 149, 107, // 3928-3935
120, 101, 119, 131,  99, 175, 122, 134, // 3936-3943
132,  90, 136, 100, 164, 144, 117, 121, // 3944-3951
104, 139,  98, 114,  78, 109, 129, 108, // 3952-3959
137,  96, 132, 117, 125, 159, 112, 140, // 3960-3967
133, 165, 171, 115, 118, 120, 168, 137, // 3968-3975
120, 116, 111, 164, 152, 147, 106,  96, // 3976-3983
135, 164, 198, 165, 136, 151, 177, 173, // 3984-3991
178, 170, 154, 142, 148, 174, 136, 117, // 3992-3999
102, 112, 132, 106,  88,  69,  93, 126, // 4000-4007
115, 108,  78,  89,  63,  80, 129, 114, // 4008-4015
125,  73,  91,  80,  49, 101,  98,  86, // 4016-4023
 94, 111, 131, 139, 139, 123, 131, 124, // 4024-4031
141, 165, 129, 149, 115, 123, 137, 122, // 4032-4039
161, 120, 154, 155, 120, 170, 129, 166, // 4040-4047
181, 141, 183, 130, 145, 151, 127, 166, // 4048-4055
110,  95,  92,  73, 116, 105, 134, 106, // 4056-4063
 74, 128, 113, 118, 116, 125, 140, 130, // 4064-4071
155, 171, 160, 116,  87, 135, 142, 144, // 4072-4079
135, 109, 114, 127, 183, 163, 101,  86, // 4080-4087
117, 171, 151, 110,  93,  75, 114, 154, // 4088-4095
183, 133,  84, 118, 128, 179, 193, 175, // 4096-4103
165, 131, 145, 137, 128, 127, 100, 137, // 4104-4111
103,  94, 130,  89, 130, 143, 135, 140, // 4112-4119
 83, 122, 122, 105, 142, 128, 147, 110, // 4120-4127
 97, 127,  80,  98, 135, 101,  93,  90, // 4128-4135
137, 157, 108,  90, 121, 139, 121, 129, // 4136-4143
135, 120, 108, 122, 132, 134, 120, 143, // 4144-4151
155, 145, 130, 125, 132, 118, 117, 128, // 4152-4159
144, 116, 131, 144, 108, 111, 123, 118, // 4160-4167
123, 101, 102, 114,  90, 111, 122, 112, // 4168-4175
 88,  90, 105, 100, 125, 118,  83, 111, // 4176-4183
124, 144, 136, 103, 137, 143, 155, 162, // 4184-4191
142, 140, 125, 143, 169, 142, 131, 130, // 4192-4199
169, 200, 162, 147, 150, 168, 173, 142, // 4200-4207
128, 114, 110, 133, 136, 121, 112, 110, // 4208-4215
114, 139, 135, 109,  89,  64,  77,  95, // 4216-4223
112, 119, 109, 102, 109, 104, 127, 124, // 4224-4231
103, 122, 111, 111, 100,  97, 106, 107, // 4232-4239
123, 141, 140, 117, 128, 161, 175, 165, // 4240-4247
133, 133, 152, 164, 187, 180, 154, 128, // 4248-4255
134, 180, 211, 207, 166, 150, 161, 141, // 4256-4263
120, 110,  92,  86,  98, 109, 109,  83, // 4264-4271
 97, 137, 144, 140, 119, 104,  94,  99, // 4272-4279
111, 126, 131, 128, 132, 135, 135, 138, // 4280-4287
140, 134, 120, 122, 125, 116, 126, 108, // 4288-4295
104, 117, 108, 107, 130, 150, 135, 139, // 4296-4303
135, 133, 136, 128, 105,  86, 123, 164, // 4304-4311
158, 135, 115,  95, 122, 150, 128,  71, // 4312-4319
 40,  71, 104, 113, 102,  91, 109, 117, // 4320-4327
137, 168, 151, 133, 127, 129, 145, 124, // 4328-4335
102, 113, 118,  87,  94, 121, 138, 143, // 4336-4343
106, 101, 105,  98, 125, 121, 127, 143, // 4344-4351
129, 141, 132, 146, 168, 151, 141, 141, // 4352-4359
140, 128, 133, 144, 136, 108,  86,  76, // 4360-4367
 97, 118, 122, 110,  71,  69, 112, 157, // 4368-4375
162, 145, 130, 124, 138, 161, 168, 157, // 4376-4383
119, 125, 148, 137, 125, 118, 113, 103, // 4384-4391
105, 127, 134, 115, 115, 118, 153, 166, // 4392-4399
148, 170, 169, 162, 160, 145, 147, 140, // 4400-4407
112, 136, 153, 133, 120, 113, 101,  99, // 4408-4415
108, 125, 133, 119, 134, 136, 121, 124, // 4416-4423
119, 121, 135, 138, 154, 144, 117, 132, // 4424-4431
146, 155, 177, 147, 105, 109, 112, 118, // 4432-4439
100,  75,  82,  81, 105, 141, 131, 133, // 4440-4447
100,  96,  97, 107, 141, 148, 144, 110, // 4448-4455
118, 147, 148, 149, 154, 153, 160, 134, // 4456-4463
115, 107, 117, 146, 137, 111,  93, 116, // 4464-4471
136, 135, 131, 107,  90, 119, 132, 162, // 4472-4479
158, 128, 122, 101, 108, 101,  94,  85, // 4480-4487
 89, 112, 110, 100,  77,  71,  94, 110, // 4488-4495
122, 120, 116, 117, 110, 136, 150, 149, // 4496-4503
151, 123, 148, 134,  85,  92, 123, 125, // 4504-4511
135, 156, 130, 121, 115, 125, 110,  93, // 4512-4519
117, 140, 131, 117, 133, 138, 102, 106, // 4520-4527
135, 149, 138, 116, 147, 144, 138, 157, // 4528-4535
145, 149, 133, 121, 140, 110, 104, 119, // 4536-4543
127, 147, 140, 126, 125, 121, 128, 144, // 4544-4551
134, 114, 118, 120, 149, 146, 115, 102, // 4552-4559
 93, 147, 176, 148, 101,  98, 134, 125, // 4560-4567
113, 122, 126, 135, 129, 137, 144, 127, // 4568-4575
124, 140, 154, 151, 160, 172, 167, 155, // 4576-4583
149, 140, 146, 149, 153, 147, 127, 140, // 4584-4591
147, 152, 137, 127, 135, 131, 139, 141, // 4592-4599
126, 126, 100, 104, 124,  92, 107, 111, // 4600-4607
109, 100,  76,  88, 118, 121, 115, 121, // 4608-4615
112,  98,  84,  93, 113, 108, 106,  97, // 4616-4623
 88, 112, 122, 116, 128, 143, 146, 141, // 4624-4631
147, 150, 147, 135, 136, 150, 129, 107, // 4632-4639
113,  98,  98, 115, 101, 133, 136, 123, // 4640-4647
131, 121, 104,  81,  90, 124, 130, 117, // 4648-4655
128, 110,  94,  96, 110, 127, 110,  96, // 4656-4663
121, 125, 115, 120, 130, 142, 135, 134, // 4664-4671
161, 135, 104, 112, 115, 154, 163, 136, // 4672-4679
150, 156, 136, 123, 123, 139, 128, 121, // 4680-4687
122, 115, 130, 120, 127, 137, 123, 141, // 4688-4695
141, 128, 124, 103, 103, 102,  99, 114, // 4696-4703
113, 108, 112, 117, 128, 135, 139, 136, // 4704-4711
130, 134, 134, 143, 131, 117, 114, 134, // 4712-4719
149, 116, 124, 156, 174, 170, 151, 154, // 4720-4727
172, 168, 183, 180, 160, 132, 127, 159, // 4728-4735
162, 134, 103, 117, 126, 112, 102,  98, // 4736-4743
119, 162, 158, 165, 164, 121, 110, 120, // 4744-4751
136, 137, 122, 118, 137, 124,  88,  80, // 4752-4759
 91, 106,  99, 100, 105,  86,  82, 118, // 4760-4767
143, 150, 158, 145, 127, 124, 118, 117, // 4768-4775
134, 132, 131, 135, 146, 159, 146, 130, // 4776-4783
126, 124, 144, 158, 153, 153, 128, 116, // 4784-4791
121, 103,  96,  90, 100,  99,  87,  88, // 4792-4799
108, 123, 101, 102, 126, 139, 133, 103, // 4800-4807
 78,  96, 101, 110, 111,  87, 101, 103, // 4808-4815
 85,  97, 113, 130, 144, 113, 126, 161, // 4816-4823
117, 112, 134, 139, 171, 141, 120, 129, // 4824-4831
 98, 107, 125, 118, 140, 134, 134, 153, // 4832-4839
138, 124, 112, 105, 115, 111, 112, 131, // 4840-4847
106,  87, 104, 125, 148, 122, 116, 137, // 4848-4855
128, 129, 158, 174, 136, 109, 116, 136, // 4856-4863
149, 140, 122, 125, 137, 135, 144, 141, // 4864-4871
147, 158, 152, 174, 184, 181, 162, 145, // 4872-4879
139, 149, 161, 116, 107, 122, 146, 181, // 4880-4887
140, 104, 112, 124, 144, 138, 115, 125, // 4888-4895
123, 116, 125,  95, 103,  83,  64,  82, // 4896-4903
 88, 112,  84,  85, 123, 122, 131, 127, // 4904-4911
100, 130, 140, 112, 129, 140, 157, 167, // 4912-4919
144, 142, 134, 139, 131, 121, 121, 113, // 4920-4927
124,  98,  99, 114,  95, 127, 149, 134, // 4928-4935
135, 142, 157, 158, 131, 117, 137, 121, // 4936-4943
124, 128, 113, 118,  87,  73, 102, 107, // 4944-4951
 98,  89, 110, 146, 150, 128, 121, 130, // 4952-4959
123, 157, 168, 150, 153, 107, 105, 125, // 4960-4967
 98, 106, 112, 129, 126,  74, 105, 145, // 4968-4975
152, 144, 125, 130, 134, 151, 135, 122, // 4976-4983
135, 141, 169, 161, 125,  98, 105, 133, // 4984-4991
111, 113, 140, 137, 139, 128, 108, 120, // 4992-4999
147, 149, 132, 111, 113, 130, 117,  97, // 5000-5007
104, 120, 155, 156, 130, 127, 140, 177, // 5008-5015
161, 139, 132, 129, 168, 146, 109, 115, // 5016-5023
100, 130, 121, 101, 133, 138, 117, 105, // 5024-5031
103, 103, 110, 106, 115, 102,  88, 117, // 5032-5039
136, 127, 143, 157, 173, 160, 116, 125, // 5040-5047
122, 140, 152, 121, 132, 119, 117, 136, // 5048-5055
104,  99, 118, 136, 148, 134, 138, 143, // 5056-5063
144, 152, 133, 138, 141, 128, 116,  97, // 5064-5071
100, 103, 133, 121,  90,  99,  92, 116, // 5072-5079
112,  92, 122, 121, 149, 128,  93, 110, // 5080-5087
104, 137, 146, 143, 119, 102, 108, 101, // 5088-5095
 99, 102, 108, 100, 110, 111, 100, 124, // 5096-5103
122, 112, 109, 123, 140, 118, 107, 111, // 5104-5111
135, 151, 125, 101, 123, 139, 146, 162, // 5112-5119
150, 155, 159, 151, 132, 103, 125, 146, // 5120-5127
113, 118, 143, 144, 150, 121,  95, 119, // 5128-5135
148, 141, 110, 112, 120, 125, 129, 104, // 5136-5143
 82,  93, 115, 121, 108, 113, 125, 121, // 5144-5151
139, 135, 136, 156, 139, 140, 120, 116, // 5152-5159
147, 136, 130, 113, 114, 142, 161, 140, // 5160-5167
133, 157, 150, 167, 156, 127, 135, 150, // 5168-5175
163, 165, 174, 155, 143, 147, 127, 123, // 5176-5183
130, 133, 121,  99, 109, 108, 105, 116, // 5184-5191
103, 122, 156, 160, 154, 148, 147, 140, // 5192-5199
140, 133, 129, 121, 117, 103, 105, 113, // 5200-5207
121, 138, 129, 124, 121, 134, 129,  93, // 5208-5215
 96, 114, 138, 145, 120, 102, 109, 123, // 5216-5223
110, 108, 109, 116, 125, 137, 147, 123, // 5224-5231
121, 109,  65,  81,  75,  71,  95,  74, // 5232-5239
 80, 104, 113, 119, 101,  86, 105, 115, // 5240-5247
151, 157, 134, 133, 107, 109, 130, 130, // 5248-5255
167, 168, 133, 118, 114, 140, 122, 108, // 5256-5263
120, 126, 149, 143, 103, 112, 135, 136, // 5264-5271
157, 149, 159, 169, 152, 145, 130, 124, // 5272-5279
156, 130, 103, 106, 101, 142, 127, 104, // 5280-5287
142, 141, 113, 113, 128, 163, 152, 124, // 5288-5295
133, 139, 146, 117,  85, 101, 133, 132, // 5296-5303
146, 140, 115,  99,  80, 102, 119, 135, // 5304-5311
136, 116, 126, 128, 122, 132, 150, 178, // 5312-5319
185, 160, 135, 131, 156, 141, 121, 152, // 5320-5327
143, 140, 120, 115, 142, 122, 122, 134, // 5328-5335
137, 162, 150, 118, 149, 151, 164, 171, // 5336-5343
148, 139, 147, 133, 116,  97,  85, 114, // 5344-5351
114, 101, 108, 127, 102,  68,  77, 108, // 5352-5359
109,  78,  62,  92, 111, 121, 114,  90, // 5360-5367
117, 112, 104, 129, 129, 132, 151, 121, // 5368-5375
122, 119,  87,  90,  75,  96, 119, 111, // 5376-5383
100, 120, 134, 122, 144, 146, 179, 163, // 5384-5391
136, 122, 111, 128, 113, 145, 128, 143, // 5392-5399
134, 129, 153, 130, 145, 122, 121, 115, // 5400-5407
101, 126, 161, 131, 114, 139, 155, 162, // 5408-5415
130, 104, 120, 135, 119, 135, 121, 112, // 5416-5423
100,  76, 133, 138, 136, 141, 139, 158, // 5424-5431
144, 131, 127, 146, 146, 151, 127, 110, // 5432-5439
115, 115, 114,  74,  98, 120, 119, 126, // 5440-5447
 99, 112, 122, 135, 129, 124, 135, 117, // 5448-5455
134, 140, 131, 128, 148, 155, 130, 109, // 5456-5463
124, 143, 121, 103, 115, 133, 172, 158, // 5464-5471
104, 113, 108, 131, 149, 119, 118,  99, // 5472-5479
125, 156, 132, 145, 151, 163, 135, 122, // 5480-5487
152, 151, 146, 119, 145, 145, 141, 133, // 5488-5495
100, 117, 121, 117, 127, 128, 119, 110, // 5496-5503
 86,  99, 111, 127, 114, 100, 119, 130, // 5504-5511
139, 107, 100, 127, 146, 145, 120, 115, // 5512-5519
139, 121,  92,  92, 110, 125, 100,  78, // 5520-5527
 90, 110, 119, 112, 114,  93, 125, 142, // 5528-5535
121, 130, 130, 157, 145, 149, 142, 132, // 5536-5543
120, 121, 129, 121, 115,  99,  81,  91, // 5544-5551
113, 122, 135, 124, 135, 154, 136, 130, // 5552-5559
137,  94, 117, 121, 105, 145, 138, 105, // 5560-5567
112, 135, 157, 160, 143, 154, 154, 141, // 5568-5575
131, 111, 109, 135, 130, 127, 114, 132, // 5576-5583
161, 127, 130, 141, 148, 166, 140, 154, // 5584-5591
145, 120, 148, 141, 123, 102,  85,  85, // 5592-5599
101,  79, 112, 128, 112, 127, 114, 120, // 5600-5607
 85, 101, 140, 131, 135, 125, 137, 152, // 5608-5615
103,  88,  88, 107, 148, 117,  93, 137, // 5616-5623
136, 144, 140, 144, 188, 176, 180, 177, // 5624-5631
177, 182, 165, 159, 169, 135, 115, 140, // 5632-5639
133, 125, 117,  96, 101, 117, 112, 105, // 5640-5647
112, 103, 116, 146, 136, 125, 115, 119, // 5648-5655
125, 131,  92,  75,  83,  83, 115, 112, // 5656-5663
 83,  94, 106, 124, 127,  90, 102,  93, // 5664-5671
 98, 124, 120, 131, 128, 134, 132, 127, // 5672-5679
139, 170, 177, 167, 158, 151, 156, 147, // 5680-5687
153, 127,  92, 109, 115, 101,  97,  99, // 5688-5695
120, 111, 111, 121, 141, 155, 130, 140, // 5696-5703
148, 136, 119, 101, 101, 118, 115, 105, // 5704-5711
 93, 111, 124, 119,  91,  90, 108, 104, // 5712-5719
115, 130, 146, 155, 156, 139, 150, 137, // 5720-5727
136, 147, 140, 139, 107,  86,  93, 103, // 5728-5735
 94, 104, 102, 107, 124, 121, 123, 113, // 5736-5743
141, 172, 158, 139, 133, 120, 114, 117, // 5744-5751
127, 130, 131, 125, 131, 149, 154, 136, // 5752-5759
130, 119, 113, 136, 122, 115, 104, 118, // 5760-5767
155, 162, 151, 140, 138, 148, 134, 116, // 5768-5775
150, 173, 158, 151, 135, 153, 144, 111, // 5776-5783
115, 118, 141, 114,  83,  73,  77,  96, // 5784-5791
 97, 106, 141, 136, 132, 124, 145, 137, // 5792-5799
126, 144, 124, 146, 147, 144, 136, 120, // 5800-5807
132, 154, 124, 117, 123, 138, 120, 106, // 5808-5815
139, 118, 110, 124, 127, 117, 113,  92, // 5816-5823
 90, 122, 145, 139, 117, 127, 135, 120, // 5824-5831
127, 112, 132, 129, 118, 133, 131, 142, // 5832-5839
134, 144, 149, 151, 137, 121, 103, 102, // 5840-5847
126, 110, 120, 102,  79,  97,  85,  80, // 5848-5855
 82, 104,  97, 115, 117, 116, 139, 121, // 5856-5863
139, 171, 181, 181, 138, 145, 161, 128, // 5864-5871
158, 153, 127, 138, 145, 131, 124,  96, // 5872-5879
111, 133, 140, 153, 145, 145, 123, 103, // 5880-5887
108, 122, 118,  89, 102, 120, 112, 105, // 5888-5895
111, 123, 104, 129, 117, 113, 112, 123, // 5896-5903
122, 134, 136, 136, 132, 109, 130, 108, // 5904-5911
138, 121, 125, 170, 157, 156, 152, 121, // 5912-5919
123, 107,  89, 114, 124, 116, 123, 107, // 5920-5927
106, 139, 144, 154, 126, 124, 126, 123, // 5928-5935
130, 126, 111, 114, 108, 101, 115, 114, // 5936-5943
103, 106, 116, 109, 122, 126, 119, 128, // 5944-5951
137, 130, 151, 165, 138, 158, 180, 167, // 5952-5959
175, 160, 147, 147, 134, 127, 111, 120, // 5960-5967
112, 116, 136, 130, 116, 114, 117, 117, // 5968-5975
100,  96,  96, 101, 116, 134, 141, 106, // 5976-5983
100, 116, 137, 133, 118, 135, 128, 130, // 5984-5991
135, 106, 130, 127, 111, 123, 101, 119, // 5992-5999
122, 121, 140, 132, 146, 151, 143, 137, // 6000-6007
142, 140, 101, 107, 126, 132, 155, 144, // 6008-6015
 98,  87,  87,  96, 107, 110, 102,  94, // 6016-6023
107, 119, 144, 150, 149, 152, 125, 122, // 6024-6031
126, 125, 122, 127, 142, 144, 148, 132, // 6032-6039
140, 161, 151, 143, 147, 131, 134, 130, // 6040-6047
122, 125, 117, 121, 109,  95, 107, 106, // 6048-6055
 92, 102,  86, 107, 148, 142, 130, 114, // 6056-6063
118, 140, 113, 124, 138, 120, 129, 142, // 6064-6071
138, 137, 140, 141, 150, 134, 130, 138, // 6072-6079
144, 157, 140, 130, 123, 107, 116, 103, // 6080-6087
108, 113, 109,  98, 104, 112, 110, 142, // 6088-6095
151, 155, 140, 140, 154, 155, 145, 127, // 6096-6103
122, 124, 112, 119, 146, 133, 125, 121, // 6104-6111
108, 112, 101, 108, 113, 112, 138, 129, // 6112-6119
130, 138, 122, 124, 144, 148, 145, 138, // 6120-6127
139, 145, 119, 104, 115, 109, 105,  90, // 6128-6135
 91,  90,  89, 123, 112, 130, 143, 129, // 6136-6143
158, 135, 118, 124, 104, 116, 126, 135, // 6144-6151
125, 117, 112, 119, 127, 144, 153, 131, // 6152-6159
121, 130, 139, 131, 157, 145, 131, 121, // 6160-6167
 98, 100, 109, 130, 154, 148, 133, 131, // 6168-6175
106, 128, 133, 116, 146, 133, 128, 147, // 6176-6183
130, 139, 128, 125, 136, 103,  88,  98, // 6184-6191
 99,  87,  91, 113, 135, 130, 122, 114, // 6192-6199
 99, 105, 113, 117, 118, 126, 132, 123, // 6200-6207
143, 149, 156, 156, 128, 126, 128, 125, // 6208-6215
133, 155, 159, 152, 134, 116, 110, 121, // 6216-6223
135, 120, 105, 103, 120, 120, 112, 131, // 6224-6231
136, 129, 141, 151, 159, 137, 135, 144, // 6232-6239
140, 160, 149, 153, 153, 124, 117, 106, // 6240-6247
 99, 116, 100, 102, 130, 135, 124, 108, // 6248-6255
107, 116, 128, 114, 107, 104, 117, 131, // 6256-6263
127, 133, 156, 150, 149, 145, 140, 141, // 6264-6271
127, 146, 120,  95,  94,  99,  99, 124, // 6272-6279
125,  99, 102, 116, 124, 114, 110, 113, // 6280-6287
135, 150, 153, 151, 138, 112, 116, 124, // 6288-6295
113, 108, 114, 130, 123, 125, 139, 117, // 6296-6303
104, 114, 123, 153, 154, 134, 142, 138, // 6304-6311
136, 134, 135, 110, 103, 105, 106, 124, // 6312-6319
106, 104, 118, 137, 132, 137, 149, 135, // 6320-6327
141, 145, 143, 143, 124, 138, 126,  98, // 6328-6335
119, 123, 109,  99, 107, 115, 126, 108, // 6336-6343
103, 115, 114, 137, 140, 138, 166, 145, // 6344-6351
135, 131, 136, 138, 114, 135, 152, 130, // 6352-6359
124, 120, 116, 125, 111, 126, 121, 112, // 6360-6367
123, 136, 140, 141, 130, 107, 108, 109, // 6368-6375
134, 142, 122, 138, 124, 121, 134, 119, // 6376-6383
135, 121, 126, 129, 118, 119, 113, 110, // 6384-6391
130, 156, 152, 160, 153, 151, 147, 142, // 6392-6399
143, 125, 108, 118, 136, 124, 133, 145, // 6400-6407
134, 117, 121, 129, 135, 135, 120, 104, // 6408-6415
 96, 103, 105, 100,  88, 105, 125, 123, // 6416-6423
118, 128, 122, 107, 122, 134, 118,  92, // 6424-6431
102, 107, 112, 110, 110, 126, 139, 129, // 6432-6439
119, 138, 136, 136, 130, 126, 136, 146, // 6440-6447
151, 149, 152, 140, 128, 127, 135, 134, // 6448-6455
134, 143, 145, 152, 135, 121, 132, 131, // 6456-6463
138, 134, 114, 113, 104, 114, 116,  98, // 6464-6471
106, 107, 116, 128, 135, 132, 105,  89, // 6472-6479
104, 107, 129, 124, 103, 121, 116, 125, // 6480-6487
118, 120, 118, 112, 125, 122, 126, 124, // 6488-6495
126, 136, 140, 152, 153, 145, 157, 167, // 6496-6503
161, 161, 154, 152, 150, 149, 140, 125, // 6504-6511
113, 106, 108, 103,  98, 100, 114, 117, // 6512-6519
116, 114, 118, 135, 139, 133, 121, 124, // 6520-6527
129, 143, 130, 113, 119, 116, 125, 116, // 6528-6535
107,  99,  98, 106, 120, 117, 108, 110, // 6536-6543
118, 134, 142, 156, 148, 148, 146, 148, // 6544-6551
138, 137, 136, 127, 144, 139, 130, 111, // 6552-6559
105, 108, 112, 118, 130, 128, 127, 120, // 6560-6567
125, 140, 141, 141, 139, 141, 137, 131, // 6568-6575
118, 114, 102, 106, 108, 105, 123, 122, // 6576-6583
113, 113, 103, 102, 101,  99, 108, 119, // 6584-6591
128, 120, 139, 149, 143, 148, 149, 150, // 6592-6599
142, 144, 132, 133, 143, 115, 112, 115, // 6600-6607
110, 117, 119, 122, 122, 126, 137, 145, // 6608-6615
142, 145, 130, 137, 139, 138, 144, 135, // 6616-6623
145, 140, 130, 119, 117, 131, 128, 116, // 6624-6631
121, 119, 104, 101, 110, 114, 106, 115, // 6632-6639
119, 128, 133, 125, 117, 108, 115, 125, // 6640-6647
129, 123, 118, 120, 123, 125, 124, 134, // 6648-6655
139, 138, 144, 144, 137, 133, 132, 137, // 6656-6663
143, 138, 141, 143, 153, 149, 144, 136, // 6664-6671
125, 122, 121, 130, 127, 110, 112, 119, // 6672-6679
109, 107, 113, 116, 115, 112, 102, 120, // 6680-6687
122, 123, 132, 116, 110, 117, 116, 108, // 6688-6695
110, 111, 110, 109, 125, 131, 121, 118, // 6696-6703
125, 128, 131, 141, 141, 145, 146, 149, // 6704-6711
152, 150, 141, 133, 143, 140, 139, 138, // 6712-6719
138, 132, 126, 129, 131, 120, 115, 108, // 6720-6727
103, 114, 106, 115, 120, 109, 114, 114, // 6728-6735
123, 135, 129, 123, 125, 125, 128, 120, // 6736-6743
107, 113, 111, 115, 117, 111, 129, 136, // 6744-6751
125, 125, 126, 134, 141, 126, 123, 123, // 6752-6759
126, 142, 140, 141, 139, 127, 127, 127, // 6760-6767
130, 131, 128, 118, 116, 123, 117, 121, // 6768-6775
126, 135, 134, 128, 131, 127, 136, 133, // 6776-6783
121, 121, 122, 132, 142, 145, 139, 135, // 6784-6791
136, 141, 139, 135, 121, 116, 115, 113, // 6792-6799
125, 132, 130, 126, 128, 129, 122, 115, // 6800-6807
117, 112, 108, 110, 114, 115, 112, 111, // 6808-6815
125, 137, 145, 142, 130, 123, 118, 119, // 6816-6823
119, 117, 124, 132, 122, 131, 136, 130, // 6824-6831
127, 121, 132, 139, 143, 143, 136, 128, // 6832-6839
122, 119, 135, 134, 132, 128, 117, 128, // 6840-6847
126, 126, 124, 124, 113, 111, 128, 117, // 6848-6855
112, 113, 115, 120, 130, 138, 128, 127, // 6856-6863
128, 134, 132, 127, 132, 129, 124, 115, // 6864-6871
112, 115, 121, 122, 126, 123, 117, 126, // 6872-6879
139, 137, 127, 130, 130, 122, 120, 127, // 6880-6887
133, 126, 121, 121, 117, 126, 135, 132, // 6888-6895
127, 126, 125, 129, 136, 133, 122, 121, // 6896-6903
116, 118, 121, 123, 120, 123, 125, 120, // 6904-6911
131, 139, 143, 139, 136, 131, 135, 132, // 6912-6919
128, 122, 117, 121, 128, 136, 139, 140, // 6920-6927
128, 123, 125, 127, 131, 130, 123, 121, // 6928-6935
123, 129, 125, 125, 130, 120, 119, 121, // 6936-6943
123, 124, 118, 119, 123, 122, 118, 112, // 6944-6951
115, 113, 116, 122, 121, 119, 121, 125, // 6952-6959
128, 130, 123, 127, 135, 133, 138, 135, // 6960-6967
129, 129, 134, 138, 129, 130, 128, 127, // 6968-6975
127, 127, 129, 134, 138, 136, 139, 134, // 6976-6983
131, 131, 125, 121, 123, 125, 125, 123, // 6984-6991
119, 126, 127, 123, 114, 111, 111, 110, // 6992-6999
118, 113, 122, 122, 121, 127, 120, 124, // 7000-7007
127, 127, 127, 129, 124, 122, 126, 127, // 7008-7015
132, 133, 129, 127, 136, 137, 130, 133, // 7016-7023
131, 129, 128, 119, 119, 130, 136, 132, // 7024-7031
129, 127, 127, 124, 127, 132, 131, 131, // 7032-7039
130, 126, 127, 125, 125, 125, 122, 119, // 7040-7047
114, 113, 116, 125, 126, 125, 121, 113, // 7048-7055
117, 125, 128, 124, 120, 118, 125, 136, // 7056-7063
143, 134, 131, 128, 131, 136, 135, 131, // 7064-7071
126, 124, 125, 130, 125, 121, 121, 125, // 7072-7079
130, 125, 125, 131, 127, 125, 125, 129, // 7080-7087
130, 129, 134, 133, 123, 130, 135, 131, // 7088-7095
133, 129, 127, 122, 116, 117, 123, 123, // 7096-7103
119, 119, 125, 127, 123, 130, 132, 127, // 7104-7111
127, 130, 134, 133, 127, 120, 119, 127, // 7112-7119
124, 115, 118, 123, 121, 121, 120, 117, // 7120-7127
121, 122, 121, 119, 124, 127, 125, 126, // 7128-7135
123, 125, 131, 136, 137, 137, 139, 137, // 7136-7143
136, 132, 129, 122, 120, 124, 125, 122, // 7144-7151
124, 120, 120, 120, 123, 132, 125, 123, // 7152-7159
121, 122, 127, 128, 132, 131, 132, 132, // 7160-7167
127, 119, 123, 124, 117, 116, 118, 123, // 7168-7175
121, 121, 123, 123, 124, 128, 129, 131, // 7176-7183
131, 129, 127, 125, 123, 130, 133, 137, // 7184-7191
134, 129, 131, 129, 130, 127, 127, 125, // 7192-7199
116, 117, 123, 129, 127, 125, 122, 119, // 7200-7207
120, 121, 121, 123, 126, 129, 132, 135, // 7208-7215
135, 133, 130, 128, 123, 123, 121, 120, // 7216-7223
119, 121, 125, 129, 133, 133, 132, 127, // 7224-7231
124, 125, 125, 120, 124, 126, 126, 129, // 7232-7239
132, 131, 133, 127, 126, 126, 123, 123, // 7240-7247
121, 123, 123, 125, 125, 123, 125, 126, // 7248-7255
129, 131, 129, 128, 129, 129, 127, 127, // 7256-7263
122, 118, 120, 119, 119, 122, 124, 121, // 7264-7271
123, 129, 129, 131, 129, 128, 127, 127, // 7272-7279
125, 125, 127, 132, 131, 133, 133, 129, // 7280-7287
126, 123, 126, 127, 129, 127, 128, 125, // 7288-7295
125, 126, 125, 125, 125, 123, 124, 125, // 7296-7303
123, 123, 127, 125, 125, 121, 119, 121, // 7304-7311
121, 121, 123, 123, 126, 127, 127, 127, // 7312-7319
129, 128, 126, 125, 126, 128, 127, 129, // 7320-7327
131, 130, 129, 127, 127, 129, 133, 133, // 7328-7335
132, 131, 133, 133, 133, 131, 129, 128, // 7336-7343
127, 127, 124, 121, 121, 121, 124, 127, // 7344-7351
123, 126, 123, 121, 119, 119, 119, 121, // 7352-7359
127, 128, 125, 123, 126, 127, 126, 128, // 7360-7367
128, 124, 124, 125, 124, 123, 124, 125, // 7368-7375
125, 125, 123, 124, 125, 125, 125, 124, // 7376-7383
127, 127, 130, 129, 129, 132, 131, 132, // 7384-7391
131, 132, 133, 131, 129, 129, 127, 123, // 7392-7399
121, 124, 126, 123, 125, 125, 125, 123, // 7400-7407
122, 122, 121, 121, 123, 123, 123, 124, // 7408-7415
126, 127, 125, 129, 131, 130, 129, 130, // 7416-7423
130, 130, 129, 129, 129, 128, 127, 125, // 7424-7431
124, 123, 121, 120, 121, 123, 124, 123, // 7432-7439
124, 126, 127, 129, 129, 129, 131, 130, // 7440-7447
127, 125, 125, 127, 125, 125, 125, 127, // 7448-7455
127, 128, 126, 123, 124, 124, 123, 125, // 7456-7463
124, 125, 126, 127, 126, 126, 127, 129, // 7464-7471
129, 127, 127, 127, 127, 127, 126, 125, // 7472-7479
126, 126, 123, 123, 123, 124, 123, 125, // 7480-7487
125, 125, 127, 128, 129, 125, 125, 127, // 7488-7495
125, 126, 128, 129, 130, 130, 128, 128, // 7496-7503
129, 127, 127, 125, 123, 125, 126, 127, // 7504-7511
125, 123, 125, 125, 124, 123, 123, 123, // 7512-7519
123, 123, 124, 125, 125, 127, 128, 130, // 7520-7527
129, 129, 129, 129, 128, 127, 125, 126, // 7528-7535
125, 124, 125, 125, 124, 124, 125, 125, // 7536-7543
125, 125, 126, 127, 129, 130, 129, 129, // 7544-7551
129, 129, 129, 130, 129, 128, 127, 127, // 7552-7559
125, 125, 125, 125, 125, 123, 123, 124, // 7560-7567
124, 123, 126, 128, 129, 128, 129, 128, // 7568-7575
127, 127, 128, 127, 125, 125, 125, 125, // 7576-7583
125, 127, 128, 127, 125, 125, 125, 123, // 7584-7591
124, 123, 125, 126, 127, 127, 127, 125, // 7592-7599
125, 125, 125, 125, 127, 129, 129, 128, // 7600-7607
128, 127, 127, 127, 126, 125, 125, 124, // 7608-7615
124, 125, 126, 125, 125, 126, 127, 127, // 7616-7623
126, 126, 125, 125, 125, 127, 127, 129, // 7624-7631
129, 129, 128, 126, 126, 125, 126, 125, // 7632-7639
125, 125, 126, 125, 126, 128, 127, 127, // 7640-7647
127, 127, 126, 123, 126, 126, 125, 125, // 7648-7655
126, 125, 125, 125, 127, 125, 125, 126, // 7656-7663
125, 126, 125, 125, 125, 126, 125, 125, // 7664-7671
125, 125, 125, 128, 128, 129, 129, 129, // 7672-7679
130, 127, 127, 125, 125, 126, 126, 128, // 7680-7687
127};// 7688-7688

void setup(void)
{
    DDRD &= B00000011;
    DDRB = B00000000;
    PORTD |= B11111100;
    PORTB |= B11111111;
    pinMode (trigger, INPUT);
    pinMode(13,OUTPUT);      // This is the LED that blinks when the chip is awake.
    digitalWrite(13,HIGH);   // Turn on LED on pin 13
    pinMode(ledFlashPin, OUTPUT);
    digitalWrite(ledFlashPin,LOW);
}

void loop(void)
{
      delay(10);
          sleepNow();
    // LED turns off when sleeping, then back on upon wake.
}
void sleepNow(void)
{
    // Set pin 2 as interrupt and attach handler:
    attachInterrupt(0, pinInterrupt, LOW);
    //
    // Preferred sleep mode:
    set_sleep_mode(SLEEP_MODE_PWR_DOWN);
    //
    // Set sleep enable (SE) bit:
    sleep_enable();
    //
    // Put the device to sleep:
    digitalWrite(13,LOW);   // Turn LED off to indicate sleep:
    sleep_mode();
    // Upon waking up, sketch continues from this point.
    sleep_disable();
    detachInterrupt(0);
    digitalWrite(13,HIGH);   // Turn LED on to indicate awake:
    if ((digitalRead(trigger) == LOW)) {
    playBlast();
    digitalWrite(ledFlashPin, HIGH);
    for (int i = 0; i < 11; i++) {
    digitalWrite(ledFlashPin, HIGH);
//    Define for how long the light blink stays on
    delay(50);            
    digitalWrite(ledFlashPin, LOW);   
//    Define for how long the light blink stays off
    delay(40);
    }
  }
}

void pinInterrupt(void)
{
}
void playBlast()
{
  startPlayback(DL44_Blaster_Sound, sizeof(DL44_Blaster_Sound));
}
