/*
 * MainWindow.java
 *
 * Created on February 19, 2010, 4:36 PM
 */

package beesignqueen;

import gnu.io.CommPortIdentifier;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 *
 * @author  quasiben
 */

public class MainWindow extends javax.swing.JFrame{
    private Main sc = new Main(this);
    public String PortId;
    private JMenu ToolsMenu;

    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
        list();
        //FlowerTable.getModel().addTableModelListener(this);
        //FlowerTable.getSelectionModel().addListSelectionListener(FlowerTable);
        FlowerTable.getSelectionModel().addListSelectionListener (new
                SharedListSelectionHandler(FlowerTable));
        stopButton.setEnabled(false); // begin with this disabled
        startButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                startButton.setEnabled(false);
                Thread counterThread = new Thread(sc, "Counter");
                counterThread.start();

                stopButton.setEnabled(true);
                stopButton.requestFocus();
            }
        });
        stopButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                stopButton.setEnabled(false);
                sc.stopClock();
                startButton.setEnabled(true);
                startButton.requestFocus();
            }
        });
        
                
        outputTextArea.setWrapStyleWord(true);
        outputTextArea.setAutoscrolls(true);
        outputTextArea.setText("setting auto scrolls\n");
    }
    
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel) e.getSource();
        String columnName = model.getColumnName(column);
        Object data = model.getValueAt(row, column);
        //System.out.println("row: "+row+" col: "+column);
        //System.out.println("row: "+row+" col: "+column);
        
        FlowerTable.setValueAt(1,row,2);
        //System.out.println("Data: "+data);
        //sc.updateFlowerArray();
     }
    
     public javax.swing.JMenu getToolsMenu() {
         return ToolsMenu;   
    }
     
     public javax.swing.JMenu getSerialPortMenu() {
         return SerialPortMenu1;
    }
     
     javax.swing.JTable getFlowerTable() {
         return FlowerTable;
     }
             
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        startButton = new javax.swing.JButton();
        stopButton = new javax.swing.JButton();
        outputPane = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        outputTextArea = new javax.swing.JTextArea();
        jScrollPaneTable = new javax.swing.JScrollPane();
        FlowerTable = new javax.swing.JTable();
        updateFlowerButton = new javax.swing.JButton();
        jMenuBar2 = new javax.swing.JMenuBar();
        jMenu3 = new javax.swing.JMenu();
        jMenu4 = new javax.swing.JMenu();
        ToolsMenu1 = new javax.swing.JMenu();
        SerialPortMenu1 = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jLabel1.setText("QueenBee Data Collector");

        startButton.setText("Start");

        stopButton.setText("Stop");
        stopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopButtonActionPerformed(evt);
            }
        });

        outputTextArea.setColumns(20);
        outputTextArea.setEditable(false);
        outputTextArea.setLineWrap(true);
        outputTextArea.setRows(5);
        jScrollPane1.setViewportView(outputTextArea);

        outputPane.addTab("Output", jScrollPane1);

        FlowerTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"0", new Integer(0), null},
                {"1", new Integer(4), null},
                {"2", new Integer(11), null},
                {"3", new Integer(7), null},
                {"4", new Integer(2), null},
                {"5", new Integer(8), null},
                {"6", new Integer(1), null},
                {"7", new Integer(4), null}
            },
            new String [] {
                "FlowerId", "Input Value", "Current Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.Integer.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                true, true, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPaneTable.setViewportView(FlowerTable);

        updateFlowerButton.setText("Update Values");
        updateFlowerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateFlowerButtonActionPerformed(evt);
            }
        });

        jMenu3.setText("File");
        jMenuBar2.add(jMenu3);

        jMenu4.setText("Edit");
        jMenuBar2.add(jMenu4);

        ToolsMenu1.setText("Tools");

        SerialPortMenu1.setText("SerialPort");
        ToolsMenu1.add(SerialPortMenu1);

        jMenuBar2.add(ToolsMenu1);

        setJMenuBar(jMenuBar2);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addContainerGap()
                                        .addComponent(jLabel1))
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(166, 166, 166)
                                        .addComponent(startButton)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(stopButton)))
                                .addGap(458, 458, 458))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(updateFlowerButton)
                                .addGap(31, 31, 31)))
                        .addComponent(jScrollPaneTable, javax.swing.GroupLayout.PREFERRED_SIZE, 369, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(outputPane, javax.swing.GroupLayout.PREFERRED_SIZE, 908, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(24, 24, 24)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(startButton)
                            .addComponent(stopButton))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE)
                        .addComponent(updateFlowerButton))
                    .addComponent(jScrollPaneTable, javax.swing.GroupLayout.DEFAULT_SIZE, 184, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(outputPane, javax.swing.GroupLayout.PREFERRED_SIZE, 173, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void stopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_stopButtonActionPerformed

    private void updateFlowerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateFlowerButtonActionPerformed
        // TODO add your handling code here:
        int row = FlowerTable.getRowCount();
        int col = FlowerTable.getColumnCount();
        for(int i = 0; i < row; i++) {
            Object val = FlowerTable.getValueAt(i, 1);
            //System.out.println("row: " + row + " col: " + 1);
            //System.out.println("Current Value: " + val);
            FlowerTable.setValueAt(val,i, 2);
        }
        sc.updateFlowerArray();
}//GEN-LAST:event_updateFlowerButtonActionPerformed
 
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable FlowerTable;
    private javax.swing.JMenu SerialPortMenu1;
    private javax.swing.JMenu ToolsMenu1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu4;
    private javax.swing.JMenuBar jMenuBar2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPaneTable;
    private javax.swing.JTabbedPane outputPane;
    public javax.swing.JTextArea outputTextArea;
    private javax.swing.JButton startButton;
    public javax.swing.JButton stopButton;
    private javax.swing.JButton updateFlowerButton;
    // End of variables declaration//GEN-END:variables
     
    public javax.swing.JTextArea getoutputTextArea() {
        return outputTextArea;
    }
     
    class SerialMenuListener implements ActionListener {
       public void actionPerformed(ActionEvent e) {
      if(SerialPortMenu1 == null) {
        System.out.println("serialMenu is null");
        return;
      }
      int count = SerialPortMenu1.getItemCount();
      for (int i = 0; i < count; i++) {
        ((JCheckBoxMenuItem)SerialPortMenu1.getItem(i)).setState(false);
      }
      JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
      item.setState(true);
      String name = item.getText();
      PortId = name;
      System.out.println("Port Id: "+PortId);
      //System.out.println(item.getLabel());
      //Preferences.set("serial.port", name);
      //System.out.println("set to " + get("serial.port"));
        }
    }
    
    @Override
    public void list() {
            // get list of ports available on this particular computer,
            // by calling static method in CommPortIdentifier.
            Enumeration pList = CommPortIdentifier.getPortIdentifiers();
            System.out.println("Listing Ports");
            SerialMenuListener serialMenuListener = new  SerialMenuListener();
            // Process the list.
            while (pList.hasMoreElements()) {
                CommPortIdentifier cpi = (CommPortIdentifier) pList.nextElement();
                System.out.print("Port " + cpi.getName() + " ");
                JMenuItem menuItem;
                menuItem = new JCheckBoxMenuItem(cpi.getName());
                menuItem.addActionListener(serialMenuListener);
                SerialPortMenu1.add(menuItem);        
                if (cpi.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                    System.out.println("is a Serial Port: " + cpi);
                } else if (cpi.getPortType() == CommPortIdentifier.PORT_PARALLEL) {
                    System.out.println("is a Parallel Port: " + cpi);
                } else {
                    System.out.println("is an Unknown Port: " + cpi);
                }
            }
        }
}

 class SharedListSelectionHandler implements ListSelectionListener {
     public static javax.swing.JTable FlowerTable;
    
     SharedListSelectionHandler(javax.swing.JTable _FlowerTable) {
         FlowerTable = _FlowerTable;
     }
        public void valueChanged(ListSelectionEvent e) { 
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();

            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            
            boolean isAdjusting = e.getValueIsAdjusting(); 
            System.out.println("Event for indexes "
                          + firstIndex + " - " + lastIndex
                          + "; isAdjusting is " + isAdjusting
                          + "; selected indexes:");

            if (lsm.isSelectionEmpty()) {
                System.out.println(" <none>");
            } else {
                // Find out which indexes are selected.
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                for (int i = minIndex; i <= maxIndex; i++) {
                    if (lsm.isSelectedIndex(i)) {
                        System.out.println(" " + i);
                    }
                }
            }
            int row = FlowerTable.getSelectedRow();
            int col = FlowerTable.getSelectedColumn();
            Object val = FlowerTable.getValueAt(row,col);  
            System.out.println("row: "+row+" col: "+col);
            System.out.println("Current Value: "+val);

        }
    }
