/*
Magic Button Base Unit Firmware v1.0
2017 Allan Murray
 */

#include <IRremote.h>

int RECV_PIN = 2;
int RELAY_PIN=13;
int LED_PIN=12;
int BUTTON_PIN=11;
int MODE_PIN=10;
int LDR_PIN=A6;
int TIME_DELAY=6000;// Delay between toggling in LDR mode

bool relayON=false;

unsigned long lastTime=0;
unsigned long thisTime=0;

IRrecv irrecv(RECV_PIN);

decode_results results;

void setup()
{

  pinMode(BUTTON_PIN, INPUT_PULLUP);
  pinMode(MODE_PIN, INPUT_PULLUP);
  pinMode(RELAY_PIN, OUTPUT);
  pinMode(LED_PIN, OUTPUT);
  digitalWrite(RELAY_PIN, HIGH);   
  digitalWrite(LED_PIN, HIGH); 
  delay(500);              
  digitalWrite(LED_PIN, LOW);   
  digitalWrite(RELAY_PIN, relayON);  

  Serial.begin(9600);
  irrecv.enableIRIn(); // Start the receiver
  Serial.println("OK ");

}


void switchActivated()
{
  Serial.println("SWITCH");
  relayON=!relayON;
  digitalWrite(RELAY_PIN, relayON);
  delay(500);
}


void loop() {
  
  if (irrecv.decode(&results)) {
    Serial.println(results.value);
    if ((results.value==16769055) | (results.value==3772778743) ){ //Valid values from remote
    switchActivated();
    }
    irrecv.resume(); 
  }

 if (digitalRead(BUTTON_PIN)==LOW) {   //Pull switch activated
  switchActivated();
   while (digitalRead(BUTTON_PIN)==LOW){}
   delay(100);
 }

 if (digitalRead(MODE_PIN)==LOW) { //If LDR mode on
  int val = analogRead(LDR_PIN); 
  bool LDRon=(val>600);
  digitalWrite(LED_PIN,LDRon);
  thisTime=millis();
  if ((LDRon!=relayON) && ((thisTime-lastTime)>TIME_DELAY)) {
    lastTime=thisTime;
    relayON=LDRon;
    digitalWrite(RELAY_PIN, relayON); 
  }
  else
  digitalWrite(LED_PIN,LOW);
 }


}



