/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#ifndef __MOTORCONTROL_H__
#define __MOTORCONTROL_H__
    
/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
   
    
/* ========================================
 * Global defines, Typedefs, Structures
 * ======================================== */
typedef enum MCD 
{
    forward = 0,
    left,
    backward,
    right,
    standstill,
    stop = 0xff
} MC_Direction;
           
typedef struct MC 
{
    MC_Direction direction;
    uint8 distance;
    uint8 ledcolor;
} MoveControl;
    
#define redledflag      0x01
#define greenledflag    0x02
#define blueledflag     0x04

/* ========================================
 * Public Functions 
 * ======================================== */
void MC_Update_MoveControl_Data( MoveControl *NextMovement );
void MC_Update_Govalue( uint8 GoValue);
void MC_Perform_Movement();
void MC_ClearMovement_Array();
void MC_Reply_Notification();
void MC_SendNotification();   

    
    
    
#endif // __MOTORCONTROL_H__
/* [] END OF FILE */
