/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#ifndef BLE_PROCESS_H
#define BLE_PROCESS_H

    
/*****************************************************************************
* Included headers
*****************************************************************************/
#include <project.h>
#include "stdbool.h"

/*****************************************************************************
* Macros 
*****************************************************************************/

#define BLE_STATE_ADVERTISING			(0x01)
#define BLE_STATE_CONNECTED				(0x02)
#define BLE_STATE_DISCONNECTED			(0x00)

#define MTU_XCHANGE_DATA_LEN			(0x0020)

#define ROBOT_SERVICE_INDEX             CYBLE_ROBOTCONTROLSERVICE_SERVICE_INDEX   /* (0x00u) Index of RobotControlService service in the cyBle_customs array */
#define ROBOT_SERVICE_HANDLE            CYBLE_ROBOTCONTROLSERVICE_SERVICE_HANDLE    /*  (0x000Eu) Handle of RobotControlService service */

#define RC_MOVECONTROL_INDEX            CYBLE_ROBOTCONTROLSERVICE_MOVECONTROL_CHAR_INDEX    /*  (0x00u)  Index of MoveControl characteristic */
#define RC_MOVECONTROL_HANDLE           CYBLE_ROBOTCONTROLSERVICE_MOVECONTROL_CHAR_HANDLE    /*  (0x0010u)  Handle of MoveControl characteristic */
#define RC_MOVEACK_INDEX                CYBLE_ROBOTCONTROLSERVICE_MOVEACKNOWLEDGEMENT_CHAR_INDEX    /*  (0x01u)  Index of Moveacknowledgement characteristic */
#define RC_MOVEACK_HANDLE               CYBLE_ROBOTCONTROLSERVICE_MOVEACKNOWLEDGEMENT_CHAR_HANDLE    /*  (0x0012u)  Handle of Moveacknowledgement characteristic */
#define RC_MOVEGO_INDEX                 CYBLE_ROBOTCONTROLSERVICE_MOVECONTROLGO_CHAR_INDEX    /*  (0x02u)  Index of MoveControlGo characteristic */
#define RC_MOVEGO_HANDLE                CYBLE_ROBOTCONTROLSERVICE_MOVECONTROLGO_CHAR_HANDLE   /*   (0x0015u)  Handle of MoveControlGo characteristic */
  
#define RC_MOVECONTROL_DIRECTION_INDEX  (0x00u)
#define RC_MOVECONTROL_DISTANCE_INDEX   (0x01u)
#define RC_MOVECONTROL_COLOR_INDEX      (0x02u)    
#define RC_MOVEACK_ACK_INDEX            (0x00u)
#define RC_MOVEGO_GO_INDEX              (0x00u)
    
    
    
    
/*****************************************************************************
* Extern variables
*****************************************************************************/
extern uint8 deviceConnected;
extern bool enterHibernateFlag;

/*****************************************************************************
* Public functions
*****************************************************************************/
void CustomEventHandler(uint32 event, void * eventParam);
void BLE_SetVersionData();
void UpdateConnectionParam(void);
void BLE_WriteMovementReceivedNotification(volatile uint8 *FlagValue);
void BLE_ResetGoCharacteristic();
    
#endif
/* [] END OF FILE */
