//Wichita State University GoBabyGo code
//Author: Satya V P K Maddukuri: Volunteering the WSU-Go Baby Go bulid & representing IEEE-HKN
//Co-Author1: Nathan Smith : Advising ENGR 202 students for their GoBabyGo build.
//Co-Author2: Tom Mc Guire.
//Using a custom head set (Forward/Left/Right)
//Using an IR Remote (Forward/Left/Right)
//Using a DC motor with a custom built steering linkage and a 10K OHM potentiometer (for feedback) to control the steering.
//Edited By: Brandon Nece
//Editions: The code for the KY033 sensor to return the steering motor to a forward motion
//Editions: Removed juttering from the forward motion when turning
//*For Public Use* 


#include "DualVNH5019MotorShield.h"
DualVNH5019MotorShield md;

int receiverpin_A = 3;                //'A' button in remote, stop remote
int receiverpin_B = 5;                //'B' button in remote, forward moment
int receiverpin_C = 11;               //'C' button in remote, left moment
int receiverpin_D = 13;               //'D' button in remote, right moment
int line_sensor = 8;                 //line hunter sensor

int headbutton_back = A2;           //'back' button near head, forward moment
int headbutton_left = A3;           //'left' button near head, left moment
int headbutton_right = A4;          //'right' button near head, right moment

int check = 0;
int j = 0;
int i = 0;

int turned_left = 0;                //indicates if moved left
int turned_right = 0;               //indicates if moved right
int line_sensor_value = 0;          //value comes from line hunter

void _mForward()                    //Move Forward
{
  Serial.println("before loop");
  int i;
  if(j==0)
  {
    for( i = 0; i <= 230; i+=1)
    {
      if(i > 45) {
      j=1;
      md.setM1Speed(i);
      delay(11);
    }
  }
  if(j==1)
  {
    md.setM1Speed(230);
  }
  Serial.println("after loop!");
  }
}
void _mLeft()                     //Move Left
{
  md.setM2Speed(-250);             //constant speed from datasheet
  Serial.println("go left!");
  _mForward();
}

void _mRight()                    //Move Right
{
  md.setM2Speed(250);              //constant speed from datasheet
  Serial.println("go right!");
  _mForward();
}

void _mStop()                     //Move Stop
{
  md.setM1Speed(0);               //Zero speed from datasheet
  Serial.println("STOP!");
}

void _mReturn()                   //returns steer wheels to zero
{
 if(turned_left > 0)                                    //turn right
 {
  Serial.println("returning from left");              
  _mStop();
  line_sensor_value = digitalRead(line_sensor);
  while(line_sensor_value >0)
  {
    md.setM2Speed(250);
    line_sensor_value = digitalRead(line_sensor);
  }
  md.setM2Speed(0);
  turned_left = 0;
  Serial.println("returned");
 }
 if(turned_right > 0)                                  //turn left
 {
  _mStop();
  line_sensor_value = digitalRead(line_sensor);
  Serial.println("returning from right");
  while(line_sensor_value >0)
  {
    md.setM2Speed(-250);
    line_sensor_value = digitalRead(line_sensor);
  }
  md.setM2Speed(0);
  turned_right=0;
  Serial.println("returned");
 }
}
void setup()
{
  pinMode(receiverpin_A,INPUT);               //input pins
  pinMode(receiverpin_B,INPUT);
  pinMode(receiverpin_C,INPUT);
  pinMode(receiverpin_D,INPUT);
  pinMode(headbutton_back,INPUT);
  pinMode(headbutton_left,INPUT);
  pinMode(headbutton_right,INPUT);
  pinMode(line_sensor,INPUT);

  md.init();
  Serial.begin(9600);
  _mStop();
}

void loop()
{
  int A = digitalRead(receiverpin_A);         //reads from D2
  int B = digitalRead(receiverpin_B);         //reads from D0
  int C = digitalRead(receiverpin_C);         //reads from D3
  int D = digitalRead(receiverpin_D);         //reads from D1
  int HB = analogRead(headbutton_back);       //reads value from head back button
  int HL = analogRead(headbutton_left);       //reads value from head left button
  int HR = analogRead(headbutton_right);      //reads value from head right button

  //checks to see if the turning happened
  if(D==0 && turned_left > 0)
  {
    _mReturn();
  }
  if(B==1 && turned_right > 0)
  {
    _mReturn();
  }
  if(HL < 950 && turned_left > 0)
  {
    _mReturn();
  }
  if(HR < 950 && turned_right > 0)
  {
    _mReturn();
  }

  //remote activation
  if(B==1 || C==1 || D ==1)                   //a dummy variable for remote loop
  {
    check =1;
    Serial.println("check active!");
  }
  if(check == 1)
  {
    if(A==1)                                //to come out of remote loop
    {
      check =0;
      Serial.println("check IN-active!");
    }
    else if(C==1)                           //for forward movement
    {
      _mForward();    
    }
    else if(D==1)                           //for left movement
    {
      while(D==1)
      {
        _mLeft();
        turned_left = 1;
        D = digitalRead(receiverpin_D); 
      }
    }
    else if(B==1)                           //for right movement
    {
      while(B==1)
      {
        _mRight();
        turned_right = 1;
        B = digitalRead(receiverpin_B); 
      }
    }
    else if(A==0 && B==0 && C==0 && D==0)   //to stop
    {
      j=0;
      _mStop();
    }
  }
  else if (HB > 950)                      //manual mode //forward movement
  {
    _mForward();
    Serial.println("---------HB---------");Serial.println(HB);
  }
  else if(HL>950)                         //for left movement
  {
    _mLeft();
    turned_left = 1;
  }
  else if(HR>950)                       //for right movement
  {
    _mRight();
    turned_right = 1;
  }
  else if(HB < 900 && HL < 900 && HR < 900) //to stop
  {
    _mStop();
  }
}

