#include <IRremote.h>

int RECV_PIN = 11; 
int Bu = 0;
int R = 0;
int G = 0;
int B = 0;

IRrecv irrecv(RECV_PIN);
IRsend irsend;

decode_results results;

void setup()
{
  Serial.begin(9600);
  pinMode(3, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  digitalWrite(3,LOW);
  digitalWrite(4,LOW);
  digitalWrite(5,LOW);
  digitalWrite(6,LOW);
  digitalWrite(7,LOW);
  irrecv.enableIRIn(); // Start the receiver
}


void dump(decode_results *results) {
  // Dumps out the decode_results structure.
  // Call this after IRrecv::decode()
  int count = results->rawlen;
  Serial.print("<");
  if (results->decode_type == UNKNOWN) {
    Serial.print("Unknown encoding: ");
  }
  else if (results->decode_type == NEC) {
    Serial.print("NEC: ");
  }
  else if (results->decode_type == SONY) {
    Serial.print("SONY: ");
  }
  else if (results->decode_type == RC5) {
    Serial.print("RC5: ");
  }
  else if (results->decode_type == RC6) {
    Serial.print("RC6: ");
  }
  else if (results->decode_type == PANASONIC) {
    Serial.print("PANASONIC - Address: ");
    Serial.print(results->address, HEX);
    Serial.print(" Value: ");
  }
  else if (results->decode_type == LG) {
    Serial.print("LG: ");
  }
  else if (results->decode_type == JVC) {
    Serial.print("\JVC: ");
  }
  else if (results->decode_type == AIWA_RC_T501) {
    Serial.print("AIWA RC T501: ");
  }
  else if (results->decode_type == WHYNTER) {
    Serial.print("Whynter: ");
  }
  Serial.print(results->value, HEX);
  Serial.print(">");
  Serial.print(" (");
  Serial.print(results->bits, DEC);
  Serial.println(" bits)");
  Serial.print("Raw (");
  Serial.print(count, DEC);
  Serial.print("): ");

  for (int i = 1; i < count; i++) {
    if (i & 1) {
      Serial.print(results->rawbuf[i]*USECPERTICK, DEC);
    }
    else {
      Serial.write('-');
      Serial.print((unsigned long) results->rawbuf[i]*USECPERTICK, DEC);
    }
    Serial.print(" ");
  }
  Serial.println();
}

void loop() {
  int commandString = Serial.read() - '0';
    if ((commandString == 0) && (Bu == 0)){
      Bu = 1;
      Serial.println("BUZZER ON");
      digitalWrite(4, HIGH);
    } else if ((commandString == 0) && (Bu == 1)){
      Bu = 0;
      Serial.println("BUZZER OFF");
      digitalWrite(4, LOW);
    } else if ((commandString == 1) && (R == 0)){
      Serial.println("LED RED ON");
      digitalWrite(5, HIGH);
      R = 1;
    } else if ((commandString == 1) && (R == 1)){
      Serial.println("LED RED OFF");
      digitalWrite(5, LOW);
      R = 0;
    } else if ((commandString == 2) && (G == 0)){
      Serial.println("LED GREEN ON");
      digitalWrite(6, HIGH);
      G = 1;
    } else if ((commandString == 2) && (G == 1)){
      Serial.println("LED GREEN OFF");
      digitalWrite(6, LOW);
      G = 0;
    } else if ((commandString == 3) && (B == 0)){
      Serial.println("LED BLUE ON");
      digitalWrite(7, HIGH);
      B = 1;
    } else if ((commandString == 3) && (B == 1)){
      Serial.println("LED BLUE OFF");
      digitalWrite(7, LOW);
      B = 0;
    } 
  if (irrecv.decode(&results)) {
    Serial.println(results.value, HEX);
    dump(&results);
    irrecv.resume(); // Receive the next value
  }
}
