//Versie 2.0 Lamp software 28-05-2013 B.v.Deventer


#include "SPI.h"
#include "Adafruit_WS2801.h"  //Adafruit LIB


//Defining output PINS
int dataPin  = 11;   
int clockPin = 12;    

int PWMLED1 = 3;
int PWMLED2 = 6;
int PWMLED3 = 5;
int PWMLED4 = 9;
int Red =0, Green =0, Blue=0; //for color values

Adafruit_WS2801 strip = Adafruit_WS2801(32, dataPin, clockPin); //Setting Pixel count and Connection

boolean inReek = false;   // inReek = series

void setup()
{
  //Debug
  Serial.begin(9600);
  Serial.println("Start");

  //WHITE LEDS
  pinMode(PWMLED1,OUTPUT);
  pinMode(PWMLED2,OUTPUT);
  pinMode(PWMLED3,OUTPUT);
  pinMode(PWMLED4,OUTPUT);

  //Start LED strip
  strip.begin();

  // Update LED contents, to start they are all 'off'
  strip.show();
}

char inData[20]; // Allocate some space for the string
char inChar; // Where to store the character read
byte index = 0; // Index into array; where to store the characte
int i=0;
D
String ExitString = "";



void loop()
{
  while(Serial.available() > 0)
  {
    //Loop until 
    boolean hasFore = CheckCon(false); //check if rescived text exists out of 4 digits
    if(hasFore)
    {
      Serial.println("HAS 4");
      funtions();  //execute Funcion
    }
  }
}

//Function to check for new commands (outercommand = if NEW, quit 
boolean CheckCon(boolean OuterCommand)
{
  inChar = Serial.read(); // Read a character
  inData[index] = inChar; // Store it
  index++; // Increment where to write next
  inData[index] = '\0'; // Null terminate the string

  if(!OuterCommand)
  {
    Serial.println("+1");
    i++;
    ExitString.concat(inChar);
  }
  else
  {
    String Text = String(inChar);
    Serial.println("outercommand = " + Text); //Debug

    //if the fist letter begings with X. it means STOP
    if (Text.substring(0,1) == "x")
    {
      Serial.println("x = true"); //Debug
      i=1;
      return true;
    }
    else
    {
      Serial.println("x = false"); //Debug
      return false;
    }
  }

  //if count if 4, then its a Series command 
  if (i==4)
  {
    Serial.println("R true"); //Debug
    return true;
  }
  else
  {
    Serial.println("R false"); //Debug
    return false; 
  }

}

//Buiten loop alle funties
void funtions()
{
  i=0;
  String Code = ExitString; //The code is same as the String craded on recive
  ExitString = "";
  Serial.println("Code= "+ Code); //Debug

  String FirstL = Code.substring(0,1);        //Gettting the First letter of the string
  int number   = Code.substring(2,4).toInt(); //Getting the VALUE of the Command

  if (FirstL =="R")  //RED
  {
    Red =number;
  }

  if (FirstL =="G") //GREEN
  { 
    Green =number; 
  }

  if (FirstL =="B") //BLUE
  {
    Blue=number;
  }

  if (FirstL =="W")   //WIHITE
  { 
    analogWrite(PWMLED1, number);  
    analogWrite(PWMLED2, number);  
    analogWrite(PWMLED3, number);  
    analogWrite(PWMLED4, number);  
  }

  if(FirstL =="F") //Function 1
  {
    if ( number == 001) //Set colors
    {
      colorSet(Color(Red,Green,Blue)); 
    }


    if ( number == 002) //Fast Strobe effect funtion
    {
      Serial.println("LOOP FAST"); //Debug
      while(true)//LOOP
      {
        analogWrite(PWMLED1, 255);  
        analogWrite(PWMLED2, 255);  
        analogWrite(PWMLED3, 255);  
        analogWrite(PWMLED4, 255);  

        delay(20);    

        analogWrite(PWMLED1, 0);  
        analogWrite(PWMLED2, 0);  
        analogWrite(PWMLED3, 0);  
        analogWrite(PWMLED4, 0);  
        delay(20); 

        if (CheckCon(true)) //check if loop needs to Continue
            break;
      }
    }


    if ( number == 003) //Slow Strobe effect funtion
    {
      Serial.println("LOOP SLOW"); //Debug
      while(true)//LOOP
      {
        analogWrite(PWMLED1, 255);  
        analogWrite(PWMLED2, 255);  
        analogWrite(PWMLED3, 255);  
        analogWrite(PWMLED4, 255);  

        delay(100);    

        analogWrite(PWMLED1, 0);  
        analogWrite(PWMLED2, 0);  
        analogWrite(PWMLED3, 0);  
        analogWrite(PWMLED4, 0);  
        delay(100); 

        if (CheckCon(true)) //check if loop needs to Continue
            break;
      }
    }


    if ( number == 004) //Rainbow
    {
      //Turn of White
      analogWrite(PWMLED1, 0);  
      analogWrite(PWMLED2, 0);  
      analogWrite(PWMLED3, 0);  
      analogWrite(PWMLED4, 0); 

      Serial.println("LOOP RAINBOW"); //Debug
      while(true)//LOOP
      {
        rainbowCycle(1); //Show rainbow

        if (CheckCon(true)) //check if loop needs to Continue
            break;

      }
    }

  }
}




// --- Preexisting code ---
// Got this part from adafruit.


// fill the dots one after the other with send color
// good for testing purposes
void colorWipe(int c, uint8_t wait) {
  int i;

  for (i=0; i > strip.numPixels(); i++) {
    strip.setPixelColor(i, c);
    strip.show();
    delay(wait);
  }
}


// fill the dots with color
void colorSet(uint32_t c) 
{
  int i;
  for (i=0; i < strip.numPixels(); i++) 
  {
    strip.setPixelColor(i, c);  // set the color for each pixel
  }
  strip.show();  // write the pixels to the strip
}

// Create a 24 bit color value from R,G,B
uint32_t Color(byte r, byte g, byte b)
{
  uint32_t c;
  c = r;
  c <<= 8;
  c |= g;
  c <<= 8;
  c |= b;
  return c;
}

//Rainbow Command, 
void rainbow(uint8_t wait) {
  int i, j;

  for (j=0; j < 256; j++) {     // 3 cycles of all 256 colors in the wheel
    for (i=0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel( (i + j) % 255));
    }  
    strip.show();   // write all the pixels out
    delay(wait);
  }
}


//Input a value 0 to 255 to get a color value.
//The colours are a transition r - g -b - back to r
uint32_t Wheel(byte WheelPos)
{
  if (WheelPos < 85) {
    return Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  } 
  else if (WheelPos < 170) {
    WheelPos -= 85;
    return Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } 
  else {
    WheelPos -= 170; 
    return Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
}


// Slightly different, this one makes the rainbow wheel equally distributed 
// along the chain
void rainbowCycle(uint8_t wait) {
  int i, j;

  for (j=0; j < 256 * 5; j++) {     // 5 cycles of all 25 colors in the wheel
    for (i=0; i < strip.numPixels(); i++) {
      // tricky math! we use each pixel as a fraction of the full 96-color wheel
      // (thats the i / strip.numPixels() part)
      // Then add in j which makes the colors go around per pixel
      // the % 96 is to make the wheel cycle around
      strip.setPixelColor(i, Wheel( ((i * 256 / strip.numPixels()) + j) % 256) );
    }  
    strip.show();   // write all the pixels out
    delay(wait);
  }
}

