#include "Wire.h"
#include "I2Cdev.h"
#include "MPU6050.h"
#include <Servo.h> 

Servo servo1; //X
Servo servo2; //Y
Servo servo3; //Z

MPU6050 accelgyro;

int16_t ax, ay, az;
int16_t gx, gy, gz;

//Usado para calcular o angulo - Variaveis do acelerometro
double accXangle;
double accYangle;
double accZangle;
//Usado para calcular o angulo - Variaveis do giroscopio
double gyroXangle = 180;
double gyroYangle = 180;
double gyroZangle = 180;

uint32_t timer;

void setup() {
 
  Wire.begin();

  // Inicializando a comunicação serial
  // funciona em 8MHz ou em 16MHz
  Serial.begin(9600);

  // Iniciando dispositivos
  Serial.println("Inicializando cominicação I2C...");
  
  accelgyro.initialize();

  // Testando a conexão com a MPU6050
  Serial.println("Testando a conexão com MPU6050...");
  Serial.println(accelgyro.testConnection() ? "MPU6050 conectada com sucesso" : "Falha na conexão com a MPU6050");
  
  servo1.attach(9);  // Eje X
  //servo2.attach(9);
  servo3.attach(8);  // Eje Z
    
  timer = micros();
}

void loop() {
  // Fazendo a leitura de conexão com a MPU6050
  accelgyro.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);

  // Calcular os angulos com base nos sensores do acelerometro
  accXangle = (atan2(ax,az) + PI)* RAD_TO_DEG;
  accYangle = (atan2(ay,az) + PI)* RAD_TO_DEG;
  accZangle = (atan2(ax,ay) + PI)* RAD_TO_DEG;  

  double gyroXrate = ((double)gx / 200.0);
  double gyroYrate = -((double)gy / 200.0);
  double gyroZrate = ((double)gz / 200.0);
  
  //###################### Calcular o ângulo de giro sem qualquer filtro ######################### 
  gyroXangle += gyroXrate*((double)(micros()-timer)/1000000); 
  gyroYangle += gyroYrate*((double)(micros()-timer)/1000000);
  gyroZangle += gyroZrate*((double)(micros()-timer)/1000000);
 
  servo1.write(gyroYangle);
  servo2.write(gyroXangle);
  servo3.write(gyroZangle);

  timer = micros();
  // A taxa de amostras máxima do acelerometro é de 1KHz
  delay(1); 

//  //Tabela Separada para os valores accel/gyro x/y/z values
//  Serial.print("a/g:\t");
//  Serial.print(ax); Serial.print("\t");
//  Serial.print(ay); Serial.print("\t");
//  Serial.print(az); Serial.print("\t");
//  Serial.print(gx); Serial.print("\t");
//  Serial.print(gy); Serial.print("\t");
//  Serial.println(gz);
  
  //Angulo Giroscopio x/y/z
  Serial.print(gyroXangle); Serial.print("\t");
  //Serial.print(gyroYangle); Serial.print("\t"); 
  Serial.print(gyroZangle); Serial.print("\t");
    
  Serial.print("\n");
}

