/*
   nRF24L01 Transceiver:
   1 - GND
   2 - VCC 3.3V !!! NOT 5V
   3 - CE to Arduino pin 9
   4 - CSN to Arduino pin 10
   5 - SCK to Arduino pin 13
   6 - MOSI to Arduino pin 11
   7 - MISO to Arduino pin 12
   8 - UNUSED
   - 
   Analog Joystick:
   GND to Arduino GND
   VCC to Arduino +5V
   X Pot to Arduino A0
   Y Pot to Arduino A2
   Push Button 1 to D3
   Push Button 2 to D4
 */

#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>
/*-----( Declare Constants and Pin Numbers )-----*/
#define CE_PIN   9
#define CSN_PIN 10
#define JOYSTICK_X A0
#define JOYSTICK_K1 4
#define JOYSTICK_Y A2
#define JOYSTICK_K2 3

// NOTE: the "LL" at the end of the constant is "LongLong" type
const uint64_t pipe = 0xE8E8F0F0E1LL; // Define the transmit pipe


/*-----( Declare objects )-----*/
RF24 radio(CE_PIN, CSN_PIN); // Create a Radio
/*-----( Declare Variables )-----*/
int joystick[4];  // 4 element array holding Joystick (X, Y, K1, K2) readings

void setup()   /****** SETUP: RUNS ONCE ******/
{
  Serial.begin(9600);
  radio.begin();
  radio.openWritingPipe(pipe);
}//--(end setup )---


void loop()   /****** LOOP: RUNS CONSTANTLY ******/
{
 
  
  joystick[0] = analogRead(JOYSTICK_X);
  joystick[1] = digitalRead(JOYSTICK_K1);

  joystick[2] = analogRead(JOYSTICK_Y);
  joystick[3] = digitalRead(JOYSTICK_K2);
  
  radio.write( joystick, sizeof(joystick) );

}
