/*
   nRF24L01 Transceiver
   1 - GND
   2 - VCC 3.3V !!! NOT 5V
   3 - CE to Arduino pin 9
   4 - CSN to Arduino pin 10
   5 - SCK to Arduino pin 13
   6 - MOSI to Arduino pin 11
   7 - MISO to Arduino pin 12
   8 - UNUSED

 
 */

#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>
#include <Servo.h>
/*-----( Declare Constants and Pin Numbers )-----*/
#define CE_PIN   9
#define CSN_PIN 10




// NOTE: the "LL" at the end of the constant is "LongLong" type
const uint64_t pipe = 0xE8E8F0F0E1LL; // Define the transmit pipe


/*-----( Declare objects )-----*/
RF24 radio(CE_PIN, CSN_PIN); // Create a Radio
/*-----( Declare Variables )-----*/
int joystick[4];  // 4 element array holding Joystick (X, Y, K1, K2) readings

Servo servo1; // Rudder Servo
Servo servo2; // Trim Servo 1
Servo servo3; // Trim Servo 2
Servo servo4; // Main Mast Halyard Servo
Servo servo5; // Mizzen Mast Halyard Servo
int pos = 90;
int val1; // Rudder
int val2; // Trim
int val3; // Main Halyard
int val4; // Mizzen Halyard

void setup()   /****** SETUP: RUNS ONCE ******/
{
  Serial.begin(9600);
  delay(1000);
  Serial.println("Nrf24L01 Receiver Starting");
  radio.begin();
  radio.openReadingPipe(1,pipe);
  radio.startListening();;

   servo1.attach(3);
   servo2.attach(4);
   servo3.attach(5);
   servo4.attach(6);
   servo5.attach(7);
   
}//--(end setup )---


void loop()   /****** LOOP: RUNS CONSTANTLY ******/
{
  if ( radio.available() )
  {
    // Read the data payload until we've received everything
    bool done = false;
    while (!done) 
   
    {
      // Fetch the data payload
      done = radio.read( joystick, sizeof(joystick) );
     
      
      Serial.print("X = ");
      Serial.print(joystick[0]);
      Serial.print(" K1 = ");      
      Serial.print(joystick[1]);
      Serial.print("y = ");
      Serial.print(joystick[2]);
      Serial.print(" K2 = ");      
      Serial.print(joystick[3]);

      val1 = map(joystick[0], 0, 1023, 80, 160);     // scale it to use it with the servo (value between 0 and 180) 
      Serial.print("  ");
      Serial.print(val1);
      servo1.write(val1);// sets the servo position according to the scaled value 
     
      val2 = map(joystick[2], 0, 1023, 70, 109);
      Serial.print("  ");
      Serial.print(val2);
      servo2.write(val2);
      servo3.write(val2);

        
      if ( joystick[1] == LOW && joystick[3] == HIGH){
        val3 = 70;
        val4 = 107;

        servo4.write(val3); // sets the servo position to lower the sails
        servo5.write(val4);
        
        Serial.print("  ");
        Serial.print(val3);
        Serial.print("  ");
        Serial.println(val4);
      
      }
           
      if ( joystick[3] == LOW && joystick [1] == HIGH){
        val3 = 125;
        val4 = 80;

        servo4.write(val3); // sets the servo position to lower the sails
        servo5.write(val4);
        
        Serial.print("  ");
        Serial.print(val3);
        Serial.print("  ");
        Serial.println(val4);
      }

      else if (joystick[3] == HIGH && joystick [1] == HIGH) {
        val3 = 91; // Value is 91 because the center of the chap servos was a little off causing an annoying small continuous movement
        val4 = 91;

        servo4.write(val3); // sets the servo position to lower the sails
        servo5.write(val4);
        
        Serial.print("  ");
        Serial.print(val3);
        Serial.print("  ");
        Serial.println(val4);
      }
        
      delay (5); 
    }
  }
  else
  {    
      Serial.println("No radio available");

     servo1.write(129); // sets all servos to neutral position in the event of a loss of signal
     servo2.write(90);
     servo3.write(90); 
     servo4.write(91);
     servo5.write(91); 
     
  }
    
                        
   
}    

