//  _ ___ _______     ___ ___ ___  ___ _   _ ___ _____ ___ 
// / |_  )__ /   \   / __|_ _| _ \/ __| | | |_ _|_   _/ __| 
// | |/ / |_ \ |) | | (__ | ||   / (__| |_| || |  | | \__ \ 
// |_/___|___/___/   \___|___|_|_\\___|\___/|___| |_| |___/ 
// 
// LCD Screen
// 
// Made by Cory Brighton
// License: CC-BY-SA 3.0
// Downloaded from: http://123d.circuits.io/circuits/120143-lcd-screen

// Controlling a servo position using a potentiometer (variable resistor) 
// by Michal Rinott <http://people.interaction-ivrea.it/m.rinott> 

#include <Servo.h> 
 
Servo myservo;  // create servo object to control a servo
Servo ser1;
Servo ser2;
Servo ser3;
 
int con1 = 0;  // analog pin used to connect the potentiometer
int con2 = 1;
int con3 = 2;
int con4 = 3;
int val;    // variable to read the value from the analog pin 
int val1;
int val2;
int val3;

void setup() 
{ 
  myservo.attach(7);  // attaches the servo on pin 9 to the servo object 
  ser1.attach(6);
  ser2.attach(5);
  ser3.attach(4);
} 
 
void loop() 
{ 
  val = analogRead(con1);            // reads the value of the potentiometer (value between 0 and 1023) 
  val = map(val, 0, 1023, 0, 179);     // scale it to use it with the servo (value between 0 and 180) 
  val1 = analogRead(con2);
  val1 = map(val1, 0, 1023, 0, 179);
  val2 = analogRead(con3);
  val2 = map(val2, 0, 1023, 0, 179);
  val3 = analogRead(con4);
  val3 = map(val3, 0, 1023, 0, 179);
  
  myservo.write(val);                  // sets the servo position according to the scaled value 
  ser1.write(val1);
  ser2.write(val2);
  ser3.write(val3);
  delay(15);                           // waits for the servo to get there 
} 
