/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import android.content.Context;
import cc.arduino.ADKCommunication;
import com.android.future.usb.UsbAccessory;
import java.io.IOException;

public class ArduinoAdkUsb {
    private Context myParent;
    public static final String VERSION = "##version##";
    private ADKCommunication comm;

    public ArduinoAdkUsb(Context context) {
        this.myParent = context;
        this.welcome();
        this.comm = new ADKCommunication(this.myParent);
    }

    public int available() {
        return this.comm.available();
    }

    public byte[] buffer() {
        return this.comm.getRawBuffer();
    }

    public byte readByte() {
        return this.comm.readByte();
    }

    public int read() {
        return this.comm.readByte() & 0xFF;
    }

    public char readChar() {
        return (char)this.comm.readByte();
    }

    public void connect(UsbAccessory usbAccessory) {
        try {
            this.comm.connect(usbAccessory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.comm.isConnected();
    }

    public void write(char c) {
        try {
            this.comm.write((byte)c);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void write(int n) {
        try {
            this.comm.write((byte)(n & 0xFF));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void write(byte by) {
        try {
            this.comm.write(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public UsbAccessory[] list() {
        return this.comm.getAccessories();
    }

    private void welcome() {
        System.out.println("##name## ##version## by ##author##");
    }

    public static String version() {
        return VERSION;
    }
}

